/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridMapFile {
    private static final Logger _log = LoggerFactory.getLogger(GridMapFile.class);
    private File _file;
    private long _loaded;
    private ImmutableMultimap<String, String> _map = ImmutableMultimap.of();

    public GridMapFile(File file) {
        this._file = file;
        this.refresh();
    }

    public GridMapFile(String filename) {
        this(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        block6: {
            try {
                boolean readable;
                long now = System.currentTimeMillis();
                boolean bl = readable = this._file.canRead() || this._loaded == 0L;
                if (!readable) {
                    _log.error("WARNING: Could not read grid-mapfile. Will use cached copy.");
                    break block6;
                }
                if (this._loaded >= this._file.lastModified()) break block6;
                _log.debug("GridMapFileHandler reading {}", (Object)this._file);
                BufferedReader reader = new BufferedReader(new FileReader(this._file));
                try {
                    this._map = GridMapFile.read(reader);
                    this._loaded = now;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                _log.error("Failed to load grid-mapfile: " + e.getMessage());
            }
        }
    }

    private static ImmutableMultimap<String, String> read(BufferedReader reader) throws IOException {
        String line;
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        while ((line = reader.readLine()) != null) {
            int last_quote;
            if ((line = line.trim()).length() == 0 || line.charAt(0) != '\"' || (last_quote = (line = line.substring(1)).lastIndexOf(34)) == -1) continue;
            String dn = line.substring(0, last_quote);
            String user = line.substring(last_quote + 1).trim();
            if (user == null || user.length() <= 0) continue;
            map.put((Object)dn.trim(), (Object)GridMapFile.removeQuotes(user.trim()));
        }
        return map.build();
    }

    private static String removeQuotes(String quotedString) {
        if (quotedString != null) {
            quotedString = quotedString.replace('\"', ' ').trim();
        }
        return quotedString;
    }

    public String getMappedUsername(String dn) {
        ImmutableCollection names = this._map.get((Object)dn);
        return names.isEmpty() ? null : (String)names.asList().get(0);
    }

    public Collection<String> getMappedUsernames(String dn) {
        return this._map.get((Object)dn);
    }
}

