/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.FileLineSource;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.SourceBackedPredicateMap;
import org.dcache.gplazma.plugins.VOMapLineParser;
import org.dcache.gplazma.util.NameRolePair;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoRoleMapPlugin
implements GPlazmaMappingPlugin {
    private static final Logger _log = LoggerFactory.getLogger(VoRoleMapPlugin.class);
    private static final long REFRESH_PERIOD = TimeUnit.SECONDS.toMillis(10L);
    private static final String VOROLEMAP = "gplazma.vorolemap.file";
    private final SourceBackedPredicateMap<NameRolePair, String> _map;

    public VoRoleMapPlugin(Properties properties) throws IOException {
        String path = properties.getProperty(VOROLEMAP);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.vorolemap.file");
        this._map = new SourceBackedPredicateMap(new FileLineSource(path, REFRESH_PERIOD), new VOMapLineParser());
    }

    VoRoleMapPlugin(SourceBackedPredicateMap<NameRolePair, String> map) {
        this._map = map;
    }

    private boolean containsPrimaryGroupName(Set<Principal> principals) {
        for (GroupNamePrincipal p : Iterables.filter(principals, GroupNamePrincipal.class)) {
            if (!p.isPrimaryGroup()) continue;
            return true;
        }
        return false;
    }

    private boolean addMappingFor(FQANPrincipal fqanPrincipal, GlobusPrincipal globusPrincipal, boolean isPrimary, Set<Principal> principals, Set<Principal> authorizedPrincipals) {
        String fqan;
        String dn = globusPrincipal.getName();
        List<String> names = this._map.getValuesForPredicatesMatching(new NameRolePair(dn, fqan = fqanPrincipal.getName()));
        if (names.isEmpty()) {
            return false;
        }
        String name = names.get(0);
        principals.add((Principal)new GroupNamePrincipal(name, isPrimary));
        authorizedPrincipals.add((Principal)fqanPrincipal);
        authorizedPrincipals.add((Principal)globusPrincipal);
        _log.info("VOMS authorization successful for user with DN: {} and FQAN: {} for user name: {}.", new Object[]{dn, fqan, name});
        return true;
    }

    public void map(Set<Principal> principals, Set<Principal> authorizedPrincipals) throws AuthenticationException {
        ArrayList fqanPrincipals = Lists.newArrayList((Iterable)Iterables.filter(principals, FQANPrincipal.class));
        ArrayList globusPrincipals = Lists.newArrayList((Iterable)Iterables.filter(principals, GlobusPrincipal.class));
        boolean hasPrimary = this.containsPrimaryGroupName(authorizedPrincipals);
        boolean authorized = false;
        for (FQANPrincipal fqanPrincipal : fqanPrincipals) {
            boolean found = false;
            boolean isPrimary = fqanPrincipal.isPrimaryGroup() && !hasPrimary;
            FQAN fqan = fqanPrincipal.getFqan();
            do {
                for (GlobusPrincipal globusPrincipal : globusPrincipals) {
                    if (!this.addMappingFor(fqanPrincipal, globusPrincipal, isPrimary, principals, authorizedPrincipals)) continue;
                    authorized = true;
                    found = true;
                    hasPrimary |= isPrimary;
                }
                fqan = fqan.getParent();
            } while (isPrimary && !found && fqan != null);
        }
        if (!authorized) {
            String logmessage = String.format("VOMS Authorization failed. No authorization record for user with DNs: '%s' and FQANs: '%s' found.", globusPrincipals, fqanPrincipals);
            _log.info(logmessage);
            throw new AuthenticationException("no record");
        }
    }
}

