/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.auth.FQAN;
import org.dcache.gplazma.plugins.LineParser;
import org.dcache.gplazma.plugins.MapPredicate;
import org.dcache.gplazma.util.NameRolePair;
import org.dcache.util.Glob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VOMapLineParser
implements LineParser<DNFQANPredicate, String> {
    private static final Logger _log = LoggerFactory.getLogger(VOMapLineParser.class);
    private static final String SOME_WS = "\\s+";
    private static final String DN_WILDCARD = "\\*";
    private static final String QUOTED_TERM = "\"[^\"]*\"";
    private static final String UNQUOTED_DN = "(?:/[\\w\\d\\s,;:@\\-\\*\\.=]+)+";
    private static final String DN = "\\*|(?:(?:/[\\w\\d\\s,;:@\\-\\*\\.=]+)+)|(?:\"[^\"]*\")";
    private static final String UNQUOTED_FQAN = "(?:/[\\w\\d,;:@\\-\\*\\.]+)+(?:/[\\w\\d\\s,;:@\\-\\*=]+)*";
    private static final String FQAN = "(?:(?:/[\\w\\d,;:@\\-\\*\\.]+)+(?:/[\\w\\d\\s,;:@\\-\\*=]+)*)|(?:\"[^\"]*\")";
    private static final String USERNAME = "[\\w.][\\w.\\-]*";
    private static final String COMMENT = "#.*";
    private static final Pattern ROLE_MAP_FILE_LINE_PATTERN = Pattern.compile("(?:\\s+)?(\\*|(?:(?:/[\\w\\d\\s,;:@\\-\\*\\.=]+)+)|(?:\"[^\"]*\"))(?:\\s+((?:(?:/[\\w\\d,;:@\\-\\*\\.]+)+(?:/[\\w\\d\\s,;:@\\-\\*=]+)*)|(?:\"[^\"]*\")))?\\s+([\\w.][\\w.\\-]*)(?:\\s+)?(?:#.*)?");
    private static final int RM_DN_GROUP = 1;
    private static final int RM_FQAN_GROUP = 2;
    private static final int RM_KEY_GROUP = 3;

    VOMapLineParser() {
    }

    @Override
    public Map.Entry<DNFQANPredicate, String> accept(String line) {
        if (Strings.isNullOrEmpty((String)line.trim()) || line.startsWith("#")) {
            return null;
        }
        Matcher matcher = ROLE_MAP_FILE_LINE_PATTERN.matcher(line);
        if (matcher.matches()) {
            String dn = matcher.group(1).replace("\"", "");
            String vorole = Strings.nullToEmpty((String)matcher.group(2));
            FQAN fqan = new FQAN(vorole.replace("\"", ""));
            return new DNFQANStringEntry(new DNFQANPredicate(dn, fqan), matcher.group(3));
        }
        _log.warn("Ignored malformed line in VORoleMap-File: '{}'", (Object)line);
        return null;
    }

    private static final class DNFQANStringEntry
    implements Map.Entry<DNFQANPredicate, String> {
        private final DNFQANPredicate _key;
        private String _value;

        public DNFQANStringEntry(DNFQANPredicate key, String value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public DNFQANPredicate getKey() {
            return this._key;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        @Override
        public String setValue(String value) {
            this._value = value;
            return this._value;
        }
    }

    static class DNFQANPredicate
    implements MapPredicate<NameRolePair> {
        private final Pattern _dnPattern;
        private final FQAN _fqan;

        public DNFQANPredicate(String dnGlob, FQAN fqan) {
            this._dnPattern = Glob.parseGlobToPattern((String)dnGlob);
            this._fqan = fqan;
        }

        @Override
        public boolean matches(NameRolePair dnfqan) {
            String dn = Strings.nullToEmpty((String)dnfqan.getName());
            FQAN fqan = new FQAN(Strings.nullToEmpty((String)dnfqan.getRole()));
            return this._dnPattern.matcher(dn).matches() && (this._fqan.toString().isEmpty() || this._fqan.equals((Object)fqan));
        }
    }
}

