/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.util.GridMapFile;
import org.globus.gsi.jaas.GlobusPrincipal;

public class GridMapFilePlugin
implements GPlazmaMappingPlugin {
    private final GridMapFile _gridMapFile;
    private static final String GRIDMAP = "gplazma.gridmap.file";

    public GridMapFilePlugin(Properties properties) {
        String path = properties.getProperty(GRIDMAP);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.gridmap.file");
        this._gridMapFile = new GridMapFile(path);
    }

    private Map.Entry<Principal, String> getMappingFor(Set<Principal> principals) {
        Principal loginName = (Principal)Iterables.find(principals, (Predicate)Predicates.instanceOf(LoginNamePrincipal.class), null);
        for (Principal principal : principals) {
            String name;
            Collection<String> names;
            if (!(principal instanceof GlobusPrincipal) && !(principal instanceof KerberosPrincipal) || (names = this._gridMapFile.getMappedUsernames(principal.getName())).isEmpty()) continue;
            if (loginName == null) {
                name = (String)Iterables.get(names, (int)0);
            } else {
                if (!names.contains(loginName.getName())) continue;
                name = loginName.getName();
            }
            return new AbstractMap.SimpleImmutableEntry<Principal, String>(principal, name);
        }
        return null;
    }

    public void map(Set<Principal> principals, Set<Principal> authorizedPrincipals) throws AuthenticationException {
        if (Iterables.any(principals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class))) {
            return;
        }
        this._gridMapFile.refresh();
        Map.Entry<Principal, String> entry = this.getMappingFor(principals);
        if (entry == null) {
            throw new AuthenticationException("no mapping");
        }
        UserNamePrincipal principal = new UserNamePrincipal(entry.getValue());
        principals.add((Principal)principal);
        authorizedPrincipals.add(entry.getKey());
    }
}

