/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Objects;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.gplazma.plugins.LineParser;
import org.dcache.gplazma.plugins.MapPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthzMapLineParser
implements LineParser<StringPredicate, UserAuthzInformation> {
    private static final Logger _log = LoggerFactory.getLogger(AuthzMapLineParser.class);
    private static final String SOME_WS = "\\s+";
    private static final String AUTHORIZE = "[Aa][Uu][Tt][Hh][Oo][Rr][Ii][Zz][Ee]";
    private static final String USERNAME = "[\\w.][\\w.\\-]*";
    private static final String ACCESS = "(?:[Rr][Ee][Aa][Dd]-[Oo][Nn][Ll][Yy])|(?:[Rr][Ee][Aa][Dd]-[Ww][Rr][Ii][Tt][Ee])";
    private static final String UID = "\\d+";
    private static final String GID = "\\d+(?:,\\d+)*";
    private static final String PATH = "(?:\"[^\\00]+\")|(?:(?:(?:\\\\\\s)|[^\\s\\00])+)";
    private static final Pattern USER_MAP_FILE_LINE_PATTERN = Pattern.compile("(?:\\s+)?[Aa][Uu][Tt][Hh][Oo][Rr][Ii][Zz][Ee]\\s+([\\w.][\\w.\\-]*)\\s+((?:[Rr][Ee][Aa][Dd]-[Oo][Nn][Ll][Yy])|(?:[Rr][Ee][Aa][Dd]-[Ww][Rr][Ii][Tt][Ee]))\\s+(\\d+)\\s+(\\d+(?:,\\d+)*)\\s+((?:\"[^\\00]+\")|(?:(?:(?:\\\\\\s)|[^\\s\\00])+))\\s+((?:\"[^\\00]+\")|(?:(?:(?:\\\\\\s)|[^\\s\\00])+))(?:\\s+((?:\"[^\\00]+\")|(?:(?:(?:\\\\\\s)|[^\\s\\00])+)))?");
    private static final int UM_KEY_GROUP = 1;
    private static final int UM_ACCESS_GROUP = 2;
    private static final int UM_UID_GROUP = 3;
    private static final int UM_GID_GROUP = 4;
    private static final int UM_HOME_GROUP = 5;
    private static final int UM_ROOT_GROUP = 6;
    private static final int UM_FS_ROOT_GROUP = 7;

    AuthzMapLineParser() {
    }

    private static long[] toLongs(String[] s) {
        long[] longs = new long[s.length];
        for (int i = 0; i < s.length; ++i) {
            longs[i] = Long.parseLong(s[i]);
        }
        return longs;
    }

    private static String stripQuotes(String s) {
        if (s != null && s.startsWith("\"") && s.endsWith("\"") && s.length() > 1) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @Override
    public Map.Entry<StringPredicate, UserAuthzInformation> accept(String line) {
        if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("version 2.")) {
            return null;
        }
        Matcher matcher = USER_MAP_FILE_LINE_PATTERN.matcher(line);
        if (matcher.lookingAt()) {
            String key = matcher.group(1);
            String access = matcher.group(2);
            String uid = matcher.group(3);
            long[] gids = AuthzMapLineParser.toLongs(matcher.group(4).split(","));
            String home = AuthzMapLineParser.stripQuotes(matcher.group(5));
            String root = AuthzMapLineParser.stripQuotes(matcher.group(6));
            String fsroot = AuthzMapLineParser.stripQuotes(matcher.group(7));
            return new AbstractMap.SimpleImmutableEntry<StringPredicate, UserAuthzInformation>(new StringPredicate(key), new UserAuthzInformation(key, access, Long.parseLong(uid), gids, home, root, fsroot));
        }
        _log.warn("Ignored malformed line in AuthzDB-File: '{}'", (Object)line);
        return null;
    }

    public static class UserAuthzInformation {
        private final String _username;
        private final String _access;
        private final long _uid;
        private final long[] _gids;
        private final String _home;
        private final String _root;
        private final String _fsroot;

        public UserAuthzInformation(String username, String access, long uid, long[] gids, String home, String root, String fsroot) {
            this._username = username;
            this._access = access;
            this._uid = uid;
            this._gids = gids;
            this._home = home;
            this._root = root;
            this._fsroot = fsroot;
        }

        public String getUsername() {
            return this._username;
        }

        public String getAccess() {
            return this._access;
        }

        public boolean isReadOnly() {
            return !Objects.equal((Object)this._access, (Object)"read-write");
        }

        public long getUid() {
            return this._uid;
        }

        public long[] getGids() {
            return this._gids;
        }

        public String getHome() {
            return this._home;
        }

        public String getRoot() {
            return this._root;
        }

        public String getFsroot() {
            return this._fsroot;
        }

        public int hashCode() {
            int hash = this._username.hashCode() ^ this._access.hashCode() ^ this._gids.hashCode() ^ this._home.hashCode() ^ this._root.hashCode() ^ this._fsroot.hashCode() ^ Objects.hashCode((Object[])new Object[]{this._uid});
            return hash;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof UserAuthzInformation) {
                UserAuthzInformation otherInfo = (UserAuthzInformation)other;
                return Objects.equal((Object)this._username, (Object)otherInfo._username) && Objects.equal((Object)this._access, (Object)otherInfo._access) && this._uid == otherInfo._uid && Arrays.equals(this._gids, otherInfo._gids) && Objects.equal((Object)this._home, (Object)otherInfo._home) && Objects.equal((Object)this._root, (Object)otherInfo._root) && Objects.equal((Object)this._fsroot, (Object)otherInfo._fsroot);
            }
            return false;
        }
    }

    public static class StringPredicate
    implements MapPredicate<String> {
        private final String _string;

        public StringPredicate(String string) {
            this._string = string;
        }

        @Override
        public boolean matches(String object) {
            return this._string.equals(object);
        }
    }
}

