/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.LoginGidPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.LoginUidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.AuthzMapLineParser;
import org.dcache.gplazma.plugins.FileLineSource;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.dcache.gplazma.plugins.SourceBackedPredicateMap;

public class AuthzDbPlugin
implements GPlazmaMappingPlugin,
GPlazmaSessionPlugin {
    private static final long REFRESH_PERIOD = TimeUnit.SECONDS.toMillis(10L);
    private static final String AUTHZDB = "gplazma.authzdb.file";
    private static final String UID = "gplazma.authzdb.uid";
    private static final String GID = "gplazma.authzdb.gid";
    private final ImmutableList<PrincipalType> _uidOrder;
    private final ImmutableList<PrincipalType> _gidOrder;
    private final SourceBackedPredicateMap<String, AuthzMapLineParser.UserAuthzInformation> _map;

    public AuthzDbPlugin(Properties properties) throws IOException {
        String path = properties.getProperty(AUTHZDB);
        String uid = properties.getProperty(UID);
        String gid = properties.getProperty(GID);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.authzdb.file");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.authzdb.uid");
        Preconditions.checkArgument((gid != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.authzdb.gid");
        this._map = new SourceBackedPredicateMap(new FileLineSource(path, REFRESH_PERIOD), new AuthzMapLineParser());
        this._uidOrder = AuthzDbPlugin.parseOrder(uid);
        this._gidOrder = AuthzDbPlugin.parseOrder(gid);
    }

    AuthzDbPlugin(SourceBackedPredicateMap<String, AuthzMapLineParser.UserAuthzInformation> map, ImmutableList<PrincipalType> uidOrder, ImmutableList<PrincipalType> gidOrder) {
        this._map = map;
        this._uidOrder = uidOrder;
        this._gidOrder = gidOrder;
    }

    static ImmutableList<PrincipalType> parseOrder(String s) {
        ImmutableList.Builder order = ImmutableList.builder();
        for (String e : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)s)) {
            order.add((Object)PrincipalType.valueOf(e.toUpperCase()));
        }
        return order.build();
    }

    private AuthzMapLineParser.UserAuthzInformation getEntity(String name) throws AuthenticationException {
        List<AuthzMapLineParser.UserAuthzInformation> mappings = this._map.getValuesForPredicatesMatching(name);
        if (mappings.isEmpty()) {
            throw new AuthenticationException("no mapping exists for " + name);
        }
        return (AuthzMapLineParser.UserAuthzInformation)Iterables.get(mappings, (int)0);
    }

    private AuthzMapLineParser.UserAuthzInformation getEntity(List<PrincipalType> order, Long loginUid, Long loginGid, String loginName, String userName, String primaryGroup) throws AuthenticationException {
        for (PrincipalType type : order) {
            switch (type) {
                case UID: {
                    if (loginUid == null) break;
                    return new AuthzMapLineParser.UserAuthzInformation(null, null, loginUid, null, null, null, null);
                }
                case GID: {
                    if (loginGid == null) break;
                    return new AuthzMapLineParser.UserAuthzInformation(null, null, 0L, new long[]{loginGid}, null, null, null);
                }
                case LOGIN: {
                    if (loginName == null) break;
                    return this.getEntity(loginName);
                }
                case USER: {
                    if (userName == null) break;
                    return this.getEntity(userName);
                }
                case GROUP: {
                    if (primaryGroup == null) break;
                    return this.getEntity(primaryGroup);
                }
            }
        }
        throw new AuthenticationException("no mappable principal");
    }

    public void map(Set<Principal> principals, Set<Principal> authorizedPrincipals) throws AuthenticationException {
        ArrayList names = Lists.newArrayList();
        String loginName = null;
        Long loginUid = null;
        Long loginGid = null;
        String userName = null;
        String primaryGroup = null;
        for (Principal principal : principals) {
            if (principal instanceof LoginNamePrincipal) {
                if (loginName != null) {
                    throw new AuthenticationException("multiple login names");
                }
                loginName = principal.getName();
                continue;
            }
            if (principal instanceof LoginUidPrincipal) {
                if (loginUid != null) {
                    throw new AuthenticationException("multiple login UIDs");
                }
                loginUid = ((LoginUidPrincipal)principal).getUid();
                continue;
            }
            if (principal instanceof LoginGidPrincipal) {
                if (loginGid != null) {
                    throw new AuthenticationException("multiple login GIDs");
                }
                loginGid = ((LoginGidPrincipal)principal).getGid();
                continue;
            }
            if (principal instanceof UserNamePrincipal) {
                if (userName != null) {
                    throw new AuthenticationException("multiple usernames");
                }
                userName = principal.getName();
                names.add(userName);
                continue;
            }
            if (!(principal instanceof GroupNamePrincipal)) continue;
            if (((GroupNamePrincipal)principal).isPrimaryGroup()) {
                if (primaryGroup != null) {
                    throw new AuthenticationException("multiple primary group names");
                }
                primaryGroup = principal.getName();
            }
            names.add(principal.getName());
        }
        ArrayList uids = Lists.newArrayList();
        ArrayList gids = Lists.newArrayList();
        for (String name : names) {
            List<AuthzMapLineParser.UserAuthzInformation> mappings = this._map.getValuesForPredicatesMatching(name);
            for (AuthzMapLineParser.UserAuthzInformation mapping : mappings) {
                uids.add(mapping.getUid());
                gids.addAll(Longs.asList((long[])mapping.getGids()));
            }
        }
        if (loginName != null && !names.contains(loginName)) {
            throw new AuthenticationException("not authorized to use login name: " + loginName);
        }
        if (loginUid != null && !uids.contains(loginUid)) {
            throw new AuthenticationException("not authorized to use UID: " + loginUid);
        }
        if (loginGid != null && !gids.contains(loginGid)) {
            throw new AuthenticationException("not authorized to use GID: " + loginGid);
        }
        AuthzMapLineParser.UserAuthzInformation user = this.getEntity((List<PrincipalType>)this._uidOrder, loginUid, null, loginName, userName, primaryGroup);
        authorizedPrincipals.add((Principal)new UidPrincipal(user.getUid()));
        if (user.getUsername() != null) {
            authorizedPrincipals.add((Principal)new UserNamePrincipal(user.getUsername()));
        }
        AuthzMapLineParser.UserAuthzInformation group = this.getEntity((List<PrincipalType>)this._gidOrder, null, loginGid, loginName, userName, primaryGroup);
        long primaryGid = group.getGids()[0];
        authorizedPrincipals.add((Principal)new GidPrincipal(primaryGid, true));
        Iterator i$ = gids.iterator();
        while (i$.hasNext()) {
            long gid = (Long)i$.next();
            if (gid == primaryGid) continue;
            authorizedPrincipals.add((Principal)new GidPrincipal(gid, false));
        }
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        Principal principal = (Principal)Iterables.find(authorizedPrincipals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class), null);
        if (principal != null) {
            List<AuthzMapLineParser.UserAuthzInformation> mappings = this._map.getValuesForPredicatesMatching(principal.getName());
            for (AuthzMapLineParser.UserAuthzInformation mapping : mappings) {
                attrib.add(new HomeDirectory(mapping.getHome()));
                attrib.add(new RootDirectory(mapping.getRoot()));
                attrib.add(new ReadOnly(mapping.isReadOnly()));
            }
        }
    }

    static enum PrincipalType {
        UID,
        GID,
        LOGIN,
        USER,
        GROUP;

    }
}

