/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.DCapProrocolChallenge;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.PoolPassiveIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.util.Map;
import java.util.UUID;
import org.dcache.net.ChallengeReader;
import org.dcache.net.ProtocolConnectionPool;
import org.dcache.net.ProtocolConnectionPoolFactory;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.DCapChallengeReader;
import org.dcache.pool.movers.DCapOutputByteBuffer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverIoBuffer;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCapProtocol_3_nio
implements MoverProtocol,
ChecksumMover {
    private static Logger _log = LoggerFactory.getLogger(DCapProtocol_3_nio.class);
    private static Logger _logSocketIO = LoggerFactory.getLogger((String)"logger.dev.org.dcache.io.socket");
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + DCapProtocol_3_nio.class.getName()));
    private static final int INC_SPACE = 0x3200000;
    private final Args _args;
    private final Map<String, Object> _context;
    private final CellEndpoint _cell;
    private long _bytesTransferred = -1L;
    private long _transferStarted = 0L;
    private long _transferTime = -1L;
    private long _lastTransferred = System.currentTimeMillis();
    private ByteBuffer _bigBuffer = null;
    private String _status = "None";
    private boolean _io_ok = true;
    private long _ioError = -1L;
    private PnfsId _pnfsId = null;
    private int _sessionId = -1;
    private boolean _wasChanged = false;
    private Checksum _clientChecksum = null;
    private ChecksumFactory _checksumFactory;
    private MessageDigest _digest;
    private final MoverIoBuffer _defaultBufferSize = new MoverIoBuffer(262144, 262144, 262144);
    private final MoverIoBuffer _maxBufferSize = new MoverIoBuffer(0x100000, 0x100000, 0x100000);
    private SpaceMonitorHandler _spaceMonitorHandler = null;
    private static ProtocolConnectionPoolFactory protocolConnectionPoolFactory = null;

    private void initialiseBuffer(MoverIoBuffer bufferSize) {
        try {
            this._bigBuffer = this._bigBuffer == null ? ByteBuffer.allocate(bufferSize.getIoBufferSize()) : this._bigBuffer;
        }
        catch (OutOfMemoryError om) {
            this._bigBuffer = ByteBuffer.allocate(32768);
        }
    }

    private void initialiseDataSocket(SocketChannel socketChannel, MoverIoBuffer bufferSize) throws SocketException {
    }

    private MoverIoBuffer prepareBufferSize(StorageInfo storage) {
        MoverIoBuffer bufferSize = new MoverIoBuffer(this._defaultBufferSize);
        String tmp = null;
        try {
            tmp = storage.getKey("send");
            if (tmp != null) {
                bufferSize.setSendBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getSendBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            tmp = storage.getKey("receive");
            if (tmp != null) {
                bufferSize.setRecvBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getRecvBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            tmp = storage.getKey("bsize");
            if (tmp != null) {
                bufferSize.setIoBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getIoBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return bufferSize;
    }

    public DCapProtocol_3_nio(CellEndpoint cell) {
        this._cell = cell;
        this._args = this._cell.getArgs();
        this._context = this._cell.getDomainContext();
        _log.info("DCapProtocol_3 (nio) created $Id: DCapProtocol_3_nio.java,v 1.17 2007-10-02 13:35:52 tigran Exp $");
        this._defaultBufferSize.setBufferSize(this.getParameterInt("defaultSendBufferSize", this._defaultBufferSize.getSendBufferSize()), this.getParameterInt("defaultRecvBufferSize", this._defaultBufferSize.getRecvBufferSize()), this.getParameterInt("defaultIoBufferSize", this._defaultBufferSize.getIoBufferSize()));
        this._maxBufferSize.setBufferSize(this.getParameterInt("maxSendBufferSize", this._maxBufferSize.getSendBufferSize()), this.getParameterInt("maxRecvBufferSize", this._maxBufferSize.getRecvBufferSize()), this.getParameterInt("maxIoBufferSize", this._maxBufferSize.getIoBufferSize()));
        _log.info("Setup : Defaults Buffer Sizes  : {}", (Object)this._defaultBufferSize);
        _log.info("Setup : Max Buffer Sizes       : {}", (Object)this._maxBufferSize);
    }

    private synchronized int getParameterInt(String name, int defaultValue) {
        String stringValue = (String)this._context.get("dCap3-" + name);
        stringValue = stringValue == null ? this._args.getOpt(name) : stringValue;
        try {
            return stringValue == null ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String toString() {
        return "SM=" + this._spaceMonitorHandler + ";S=" + this._status;
    }

    protected String getCellName() {
        return this._cell.getCellInfo().getCellName();
    }

    protected String getCellDomainName() {
        return this._cell.getCellInfo().getDomainName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runIO(RepositoryChannel fileChannel, ProtocolInfo protocol, StorageInfo storage, PnfsId pnfsId, Allocator allocator, IoMode access) throws Exception {
        block91: {
            Exception ioException = null;
            if (!(protocol instanceof DCapProtocolInfo)) {
                throw new CacheException(44, "protocol info not DCapProtocolInfo");
            }
            DCapProtocolInfo dcapProtocolInfo = (DCapProtocolInfo)protocol;
            this._pnfsId = pnfsId;
            this._spaceMonitorHandler = new SpaceMonitorHandler(allocator);
            try {
                String allocation = storage.getKey("alloc-size");
                if (allocation != null) {
                    long allocSpace = Long.parseLong(allocation);
                    if (allocSpace <= 0L) {
                        _log.info("Options : alloc-space = {} ....Ignoring", (Object)allocSpace);
                    } else {
                        this._spaceMonitorHandler.setAllocationSpace(allocSpace);
                        _log.info("Options : alloc-space = {}", (Object)allocSpace);
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                String io = storage.getKey("io-error");
                if (io != null) {
                    this._ioError = Long.parseLong(io);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            _log.info("ioError = {}", (Object)this._ioError);
            MoverIoBuffer bufferSize = this.prepareBufferSize(storage);
            _log.info("Client : Buffer Sizes : {}", (Object)bufferSize);
            this.initialiseBuffer(bufferSize);
            SocketChannel socketChannel = null;
            DCapOutputByteBuffer cntOut = new DCapOutputByteBuffer(1024);
            this._sessionId = dcapProtocolInfo.getSessionId();
            if (!dcapProtocolInfo.isPassive()) {
                int port = dcapProtocolInfo.getPort();
                String[] hosts = dcapProtocolInfo.getHosts();
                String host = null;
                IOException bufferedException = null;
                for (int i = 0; i < hosts.length; ++i) {
                    try {
                        host = hosts[i];
                        socketChannel = SocketChannel.open();
                        socketChannel.configureBlocking(true);
                        Socket socket = socketChannel.socket();
                        socket.setKeepAlive(true);
                        socket.setTcpNoDelay(true);
                        if (bufferSize.getRecvBufferSize() > 0) {
                            socket.setReceiveBufferSize(bufferSize.getRecvBufferSize());
                        }
                        if (bufferSize.getSendBufferSize() > 0) {
                            socket.setSendBufferSize(bufferSize.getSendBufferSize());
                        }
                        socketChannel.connect(new InetSocketAddress(InetAddress.getByName(host), port));
                        break;
                    }
                    catch (IOException ee) {
                        _log.warn("Can't connect to {} : {}", (Object)host, (Object)ee.toString());
                        bufferedException = ee;
                        socketChannel = null;
                        continue;
                    }
                }
                if (socketChannel == null) {
                    throw bufferedException;
                }
                Socket socket = socketChannel.socket();
                if (_logSocketIO.isDebugEnabled()) {
                    _logSocketIO.debug("Socket OPEN remote = {}:{} local = {}:{}", new Object[]{socket.getInetAddress(), socket.getPort(), socket.getLocalAddress(), socket.getLocalPort()});
                }
                _log.info("Using : Buffer Sizes (send/recv/io) : {}/{}/{}", new Object[]{socket.getSendBufferSize(), socket.getReceiveBufferSize(), this._bigBuffer.capacity()});
                _log.info("Connected to {}:{}", (Object)host, (Object)port);
                this._bigBuffer.clear();
                this._bigBuffer.putInt(this._sessionId).putInt(0);
                this._bigBuffer.flip();
                socketChannel.write(this._bigBuffer);
            } else {
                ProtocolConnectionPool pcp = protocolConnectionPoolFactory.getConnectionPool(bufferSize.getRecvBufferSize());
                InetAddress localAddress = NetworkUtils.getLocalAddressForClient((String[])dcapProtocolInfo.getHosts());
                InetSocketAddress socketAddress = new InetSocketAddress(localAddress, pcp.getLocalPort());
                byte[] challenge = UUID.randomUUID().toString().getBytes();
                PoolPassiveIoFileMessage msg = new PoolPassiveIoFileMessage("pool", socketAddress, challenge);
                msg.setId((long)dcapProtocolInfo.getSessionId());
                _log.info("waiting for client to connect ({}:{})", (Object)localAddress, (Object)pcp.getLocalPort());
                CellPath cellpath = dcapProtocolInfo.door();
                this._cell.sendMessage(new CellMessage(cellpath, (Object)msg));
                DCapProrocolChallenge dcapChallenge = new DCapProrocolChallenge(this._sessionId, challenge);
                socketChannel = pcp.getSocket((Object)dcapChallenge);
                Socket socket = socketChannel.socket();
                socket.setKeepAlive(true);
                socket.setTcpNoDelay(true);
                if (bufferSize.getSendBufferSize() > 0) {
                    socket.setSendBufferSize(bufferSize.getSendBufferSize());
                }
            }
            this._transferStarted = System.currentTimeMillis();
            this._bytesTransferred = 0L;
            this._lastTransferred = this._transferStarted;
            this._spaceMonitorHandler.setInitialSpace(fileChannel.size());
            boolean notDone = true;
            RequestBlock requestBlock = new RequestBlock();
            while (notDone && this._io_ok) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted By Operator");
                }
                try {
                    requestBlock.read(socketChannel);
                    _log.debug("Request Block : {}", (Object)requestBlock);
                }
                catch (EOFException eofe) {
                    _log.error("Dataconnection closed by peer : {}", (Object)eofe.toString());
                    throw eofe;
                }
                catch (BufferUnderflowException bue) {
                    throw new CacheException(43, "Protocol Violation (csl<4)");
                }
                this._lastTransferred = System.currentTimeMillis();
                switch (requestBlock.getCommandCode()) {
                    case 1: {
                        if (!this._io_ok) {
                            String errmsg = "WRITE denied (IO not ok)";
                            _log.error(errmsg);
                            cntOut.writeACK(1, 204, errmsg);
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        if (access == IoMode.WRITE) {
                            cntOut.writeACK(1);
                            socketChannel.write(cntOut.buffer());
                            this.doTheWrite(fileChannel, cntOut, socketChannel);
                            if (this._io_ok) {
                                cntOut.writeFIN(1);
                                socketChannel.write(cntOut.buffer());
                                break;
                            }
                            _log.error("Reporting IO problem to client");
                            cntOut.writeFIN(1, 204, "[2]Problem in writing");
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        String errmsg = "WRITE denied (not allowed)";
                        _log.error(errmsg);
                        cntOut.writeACK(1, 204, errmsg);
                        socketChannel.write(cntOut.buffer());
                        break;
                    }
                    case 2: {
                        this._digest = null;
                        long blockSize = requestBlock.nextLong();
                        _log.debug("READ byte={}", (Object)blockSize);
                        if (this._io_ok) {
                            cntOut.writeACK(2);
                            socketChannel.write(cntOut.buffer());
                            this.doTheRead(fileChannel, cntOut, socketChannel, blockSize);
                            if (this._io_ok) {
                                cntOut.writeFIN(2);
                                socketChannel.write(cntOut.buffer());
                                break;
                            }
                            String errmsg = "FIN : READ failed (IO not ok)";
                            _log.error(errmsg);
                            cntOut.writeFIN(2, 204, errmsg);
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        String errmsg = "ACK : READ denied (IO not ok)";
                        _log.error(errmsg);
                        cntOut.writeACK(2, 204, errmsg);
                        socketChannel.write(cntOut.buffer());
                        break;
                    }
                    case 3: {
                        this._digest = null;
                        long offset = requestBlock.nextLong();
                        int whence = requestBlock.nextInt();
                        this.doTheSeek(fileChannel, whence, offset, access == IoMode.WRITE);
                        if (this._io_ok) {
                            cntOut.writeACK(fileChannel.position());
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        String errmsg = "SEEK failed : IOError ";
                        _log.error(errmsg);
                        cntOut.writeACK(3, 6, errmsg);
                        socketChannel.write(cntOut.buffer());
                        break;
                    }
                    case 11: {
                        this._digest = null;
                        long offset = requestBlock.nextLong();
                        int whence = requestBlock.nextInt();
                        long blockSize = requestBlock.nextLong();
                        if (this._io_ok) {
                            cntOut.writeACK(11);
                            socketChannel.write(cntOut.buffer());
                            this.doTheSeek(fileChannel, whence, offset, access == IoMode.WRITE);
                            if (this._io_ok) {
                                this.doTheRead(fileChannel, cntOut, socketChannel, blockSize);
                            }
                            if (this._io_ok) {
                                cntOut.writeFIN(11);
                                socketChannel.write(cntOut.buffer());
                                break;
                            }
                            String errmsg = "FIN : SEEK_READ failed (IO not ok)";
                            _log.error(errmsg);
                            cntOut.writeFIN(11, 204, errmsg);
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        String errmsg = "SEEK_AND_READ denied : IOError ";
                        _log.error(errmsg);
                        cntOut.writeACK(11, 204, errmsg);
                        socketChannel.write(cntOut.buffer());
                        break;
                    }
                    case 12: {
                        this._digest = null;
                        long offset = requestBlock.nextLong();
                        int whence = requestBlock.nextInt();
                        if (this._io_ok) {
                            cntOut.writeACK(12);
                            socketChannel.write(cntOut.buffer());
                            this.doTheSeek(fileChannel, whence, offset, access == IoMode.WRITE);
                            if (this._io_ok) {
                                this.doTheWrite(fileChannel, cntOut, socketChannel);
                            }
                            if (this._io_ok) {
                                cntOut.writeFIN(12);
                                socketChannel.write(cntOut.buffer());
                                break;
                            }
                            String errmsg = "SEEK_AND_WRITE failed : IOError";
                            _log.error(errmsg);
                            cntOut.writeFIN(12, 204, errmsg);
                            socketChannel.write(cntOut.buffer());
                            break;
                        }
                        String errmsg = "SEEK_AND_WRITE denied : IOError";
                        _log.error(errmsg);
                        cntOut.writeACK(12, 204, errmsg);
                        socketChannel.write(cntOut.buffer());
                        break;
                    }
                    case 4: {
                        if (this._io_ok) {
                            cntOut.writeACK(4);
                            socketChannel.write(cntOut.buffer());
                            try {
                                while (requestBlock.remaining() > 4) {
                                    this.scanCloseBlock(requestBlock, storage);
                                }
                            }
                            catch (Exception ee) {
                                _log.error("Problem in close block {}", (Object)ee.toString());
                            }
                        } else {
                            cntOut.writeACK(4, 204, "IOError");
                            socketChannel.write(cntOut.buffer());
                        }
                        notDone = false;
                        break;
                    }
                    case 9: {
                        try {
                            long size = fileChannel.position();
                            long location = fileChannel.size();
                            _log.debug("LOCATE : size={};position={}", (Object)size, (Object)location);
                            cntOut.writeACK(location, size);
                            socketChannel.write(cntOut.buffer());
                        }
                        catch (Exception e) {
                            cntOut.writeACK(9, -1, e.toString());
                            socketChannel.write(cntOut.buffer());
                        }
                        break;
                    }
                    case 13: {
                        try {
                            if (this._io_ok) {
                                cntOut.writeACK(13);
                                socketChannel.write(cntOut.buffer());
                                this.doTheReadv(fileChannel, cntOut, socketChannel, requestBlock);
                                if (this._io_ok) {
                                    cntOut.writeFIN(13);
                                    socketChannel.write(cntOut.buffer());
                                    break;
                                }
                                String errmsg = "FIN : READV failed (IO not ok)";
                                _log.error(errmsg);
                                cntOut.writeFIN(13, 204, errmsg);
                                socketChannel.write(cntOut.buffer());
                                break;
                            }
                            String errmsg = "ACK : READV denied (IO not ok)";
                            _log.error(errmsg);
                            cntOut.writeACK(13, 204, errmsg);
                            socketChannel.write(cntOut.buffer());
                        }
                        catch (Exception e) {
                            cntOut.writeACK(13, -1, e.toString());
                            socketChannel.write(cntOut.buffer());
                        }
                        break;
                    }
                    default: {
                        cntOut.writeACK(666, 9, "Invalid mover command : " + requestBlock);
                        socketChannel.write(cntOut.buffer());
                    }
                }
            }
            try {
                if (_logSocketIO.isDebugEnabled()) {
                    _logSocketIO.debug("Socket CLOSE remote = " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort() + " local = " + socketChannel.socket().getLocalAddress() + ":" + socketChannel.socket().getLocalPort());
                }
                socketChannel.close();
            }
            catch (Exception xe) {
                // empty catch block
            }
            dcapProtocolInfo.setBytesTransferred(this._bytesTransferred);
            this._transferTime = System.currentTimeMillis() - this._transferStarted;
            dcapProtocolInfo.setTransferTime(this._transferTime);
            _log.info("(Transfer finished : {} bytes in {} seconds) ", (Object)this._bytesTransferred, (Object)(this._transferTime / 1000L));
            long diskFileSize = fileChannel.size();
            try {
                this._spaceMonitorHandler.close(diskFileSize);
            }
            catch (IllegalStateException ise) {
                _log.error("Space monitor detected disk I/O problems : {}", (Object)ise.toString());
                ioException = ise;
                this._io_ok = false;
            }
            if (!this._io_ok) {
                throw new CacheException(204, "Disk I/O Error " + (ioException != null ? ioException.toString() : ""));
            }
            if (ioException instanceof EOFException) {
                throw ioException;
            }
            break block91;
            catch (RuntimeException e) {
                _log.error("Problem in command block : " + requestBlock, (Throwable)e);
                ioException = e;
                try {
                    if (_logSocketIO.isDebugEnabled()) {
                        _logSocketIO.debug("Socket CLOSE remote = " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort() + " local = " + socketChannel.socket().getLocalAddress() + ":" + socketChannel.socket().getLocalPort());
                    }
                    socketChannel.close();
                }
                catch (Exception xe) {
                    // empty catch block
                }
                dcapProtocolInfo.setBytesTransferred(this._bytesTransferred);
                this._transferTime = System.currentTimeMillis() - this._transferStarted;
                dcapProtocolInfo.setTransferTime(this._transferTime);
                _log.info("(Transfer finished : {} bytes in {} seconds) ", (Object)this._bytesTransferred, (Object)(this._transferTime / 1000L));
                diskFileSize = fileChannel.size();
                try {
                    this._spaceMonitorHandler.close(diskFileSize);
                }
                catch (IllegalStateException ise) {
                    _log.error("Space monitor detected disk I/O problems : {}", (Object)ise.toString());
                    ioException = ise;
                    this._io_ok = false;
                }
                if (!this._io_ok) {
                    throw new CacheException(204, "Disk I/O Error " + (ioException != null ? ioException.toString() : ""));
                }
                if (ioException instanceof EOFException) {
                    throw ioException;
                }
            }
            catch (Exception e) {
                _log.warn("Problem in command block : " + requestBlock, (Object)e.toString());
                ioException = e;
                {
                    catch (Throwable throwable) {
                        try {
                            if (_logSocketIO.isDebugEnabled()) {
                                _logSocketIO.debug("Socket CLOSE remote = " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort() + " local = " + socketChannel.socket().getLocalAddress() + ":" + socketChannel.socket().getLocalPort());
                            }
                            socketChannel.close();
                        }
                        catch (Exception xe) {
                            // empty catch block
                        }
                        dcapProtocolInfo.setBytesTransferred(this._bytesTransferred);
                        this._transferTime = System.currentTimeMillis() - this._transferStarted;
                        dcapProtocolInfo.setTransferTime(this._transferTime);
                        _log.info("(Transfer finished : {} bytes in {} seconds) ", (Object)this._bytesTransferred, (Object)(this._transferTime / 1000L));
                        long diskFileSize2 = fileChannel.size();
                        try {
                            this._spaceMonitorHandler.close(diskFileSize2);
                        }
                        catch (IllegalStateException ise) {
                            _log.error("Space monitor detected disk I/O problems : {}", (Object)ise.toString());
                            ioException = ise;
                            this._io_ok = false;
                        }
                        if (!this._io_ok) {
                            throw new CacheException(204, "Disk I/O Error " + (ioException != null ? ioException.toString() : ""));
                        }
                        if (ioException instanceof EOFException) {
                            throw ioException;
                        }
                        throw throwable;
                    }
                }
                try {
                    if (_logSocketIO.isDebugEnabled()) {
                        _logSocketIO.debug("Socket CLOSE remote = " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort() + " local = " + socketChannel.socket().getLocalAddress() + ":" + socketChannel.socket().getLocalPort());
                    }
                    socketChannel.close();
                }
                catch (Exception xe) {
                    // empty catch block
                }
                dcapProtocolInfo.setBytesTransferred(this._bytesTransferred);
                this._transferTime = System.currentTimeMillis() - this._transferStarted;
                dcapProtocolInfo.setTransferTime(this._transferTime);
                _log.info("(Transfer finished : {} bytes in {} seconds) ", (Object)this._bytesTransferred, (Object)(this._transferTime / 1000L));
                diskFileSize = fileChannel.size();
                try {
                    this._spaceMonitorHandler.close(diskFileSize);
                }
                catch (IllegalStateException ise) {
                    _log.error("Space monitor detected disk I/O problems : {}", (Object)ise.toString());
                    ioException = ise;
                    this._io_ok = false;
                }
                if (!this._io_ok) {
                    throw new CacheException(204, "Disk I/O Error " + (ioException != null ? ioException.toString() : ""));
                }
                if (ioException instanceof EOFException) {
                    throw ioException;
                }
            }
        }
    }

    private void doTheReadv(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel, RequestBlock requestBLock) throws Exception {
        cntOut.writeDATA_HEADER();
        socketChannel.write(cntOut.buffer());
        int blocks = requestBLock.nextInt();
        _log.info("READV: {} to read", (Object)blocks);
        int maxBuffer = this._bigBuffer.capacity() - 4;
        block2: for (int i = 0; i < blocks; ++i) {
            int count;
            long offset = requestBLock.nextLong();
            int len = count = requestBLock.nextInt();
            _log.info("READV: offset/len: {}/{}", (Object)offset, (Object)count);
            while (count > 0) {
                int rc;
                block5: {
                    int bytesToRead = maxBuffer > count ? count : maxBuffer;
                    try {
                        this._bigBuffer.clear().limit(bytesToRead + 4);
                        this._bigBuffer.position(4);
                        rc = fileChannel.read(this._bigBuffer, offset + (long)(len - count));
                        if (rc <= 0) {
                        }
                        break block5;
                    }
                    catch (IOException ee) {
                        this._io_ok = false;
                    }
                    continue block2;
                }
                this._bigBuffer.flip();
                this._bigBuffer.putInt(rc).rewind();
                _log.info("READV: sending: {} bytes", (Object)this._bigBuffer.limit());
                socketChannel.write(this._bigBuffer);
                count -= rc;
                this._bytesTransferred += (long)rc;
            }
        }
    }

    private void scanCloseBlock(RequestBlock requestBlock, StorageInfo storage) {
        int blockSize = requestBlock.nextInt();
        if (blockSize < 4) {
            _log.error("Not a valid block size in close");
            throw new IllegalArgumentException("Not a valid block size in close");
        }
        int blockMode = requestBlock.nextInt();
        if (blockMode != 1) {
            _log.error("Unknown block mode ({}) in close", (Object)blockMode);
            requestBlock.skip(blockSize - 4);
            return;
        }
        int crcType = requestBlock.nextInt();
        byte[] array = new byte[blockSize - 8];
        requestBlock.get(array);
        this._clientChecksum = new Checksum(ChecksumType.getChecksumType((int)crcType), array);
        storage.setKey("flag-c", this._clientChecksum.toString());
    }

    private void doTheSeek(RepositoryChannel fileChannel, int whence, long offset, boolean writeAllowed) throws Exception {
        try {
            long eofSize = fileChannel.size();
            long position = fileChannel.position();
            long newOffset = 0L;
            switch (whence) {
                case 0: {
                    _log.debug("SEEK {} SEEK_SET", (Object)offset);
                    if (offset == 0L) {
                        this._io_ok = true;
                    }
                    newOffset = offset;
                    break;
                }
                case 1: {
                    _log.debug("SEEK {} SEEK_CURRENT", (Object)offset);
                    newOffset = position + offset;
                    break;
                }
                case 2: {
                    _log.debug("SEEK {} SEEK_END", (Object)offset);
                    newOffset = eofSize + offset;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid seek mode : " + whence);
                }
            }
            if (newOffset > eofSize && !writeAllowed) {
                throw new IOException("Seek beyond EOF not allowed (write not allowed)");
            }
            this._spaceMonitorHandler.getSpace(newOffset);
            fileChannel.position(newOffset);
        }
        catch (Exception ee) {
            _log.error("Problem in seek : {}", (Object)ee.toString());
        }
    }

    private void doTheWrite(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel) throws Exception {
        int size = 0;
        int rc = 0;
        RequestBlock requestBlock = new RequestBlock();
        requestBlock.read(socketChannel);
        if (requestBlock.getCommandCode() != 8) {
            throw new IOException("Expecting : 8; got : " + requestBlock.getCommandCode());
        }
        while (!Thread.currentThread().isInterrupted()) {
            this._status = "WaitingForSize";
            this._bigBuffer.clear().limit(4);
            while (this._bigBuffer.hasRemaining()) {
                if (socketChannel.read(this._bigBuffer) >= 0) continue;
                throw new EOFException("EOF on input socket");
            }
            this._bigBuffer.rewind();
            int rest = this._bigBuffer.getInt();
            _log.debug("Next data block : {} bytes", (Object)rest);
            long position = fileChannel.position();
            this._spaceMonitorHandler.getSpace(position + (long)rest);
            long bytesAdded = 0L;
            if (rest == 0) continue;
            if (rest < 0) break;
            this._wasChanged = true;
            while (rest > 0) {
                size = this._bigBuffer.capacity() > rest ? rest : this._bigBuffer.capacity();
                this._status = "WaitingForInput";
                this._bigBuffer.clear().limit(size);
                rc = socketChannel.read(this._bigBuffer);
                if (rc <= 0) break;
                if (this._io_ok) {
                    this._status = "WaitingForWrite";
                    try {
                        this._bigBuffer.flip();
                        bytesAdded += (long)fileChannel.write(this._bigBuffer);
                        this.updateChecksum(this._bigBuffer);
                    }
                    catch (Exception ioe) {
                        _log.error("IOException in writing data to disk : {}", (Object)ioe.toString());
                        this._io_ok = false;
                    }
                }
                rest -= rc;
                this._bytesTransferred += (long)rc;
                if (this._ioError <= 0L || this._bytesTransferred <= this._ioError) continue;
                this._io_ok = false;
            }
            this._spaceMonitorHandler.newFilePosition(position + bytesAdded);
            _log.debug("Block Done");
        }
        this._status = "Done";
    }

    private void updateChecksum(ByteBuffer buffer) {
        if (this._digest != null) {
            buffer.rewind();
            this._digest.update(buffer);
        }
    }

    private void doTheRead(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel, long blockSize) throws Exception {
        cntOut.writeDATA_HEADER();
        socketChannel.write(cntOut.buffer());
        if (blockSize == 0L) {
            cntOut.writeEND_OF_BLOCK();
            socketChannel.write(cntOut.buffer());
            return;
        }
        long rest = blockSize;
        int size = 0;
        int rc = 0;
        int maxBuffer = this._bigBuffer.capacity() - 4;
        while (!Thread.currentThread().isInterrupted()) {
            block6: {
                size = (long)maxBuffer > rest ? (int)rest : maxBuffer;
                try {
                    this._bigBuffer.clear().limit(size + 4);
                    this._bigBuffer.position(4);
                    rc = fileChannel.read(this._bigBuffer);
                    if (rc <= 0) {
                    }
                    break block6;
                }
                catch (IOException ee) {
                    this._io_ok = false;
                }
                break;
            }
            this._bigBuffer.flip();
            this._bigBuffer.putInt(rc).rewind();
            socketChannel.write(this._bigBuffer);
            rest -= (long)rc;
            this._bytesTransferred += (long)rc;
            if (this._ioError > 0L && this._bytesTransferred > this._ioError) {
                this._io_ok = false;
                break;
            }
            if (rest > 0L) continue;
        }
        cntOut.writeDATA_TRAILER();
        socketChannel.write(cntOut.buffer());
    }

    public long getLastTransferred() {
        return this._lastTransferred;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public long getTransferTime() {
        return this._transferTime < 0L ? System.currentTimeMillis() - this._transferStarted : this._transferTime;
    }

    public boolean wasChanged() {
        return this._wasChanged;
    }

    public ChecksumFactory getChecksumFactory(ProtocolInfo protocolInfo) {
        return null;
    }

    public void setDigest(ChecksumFactory factory) {
        this._checksumFactory = factory;
        this._digest = factory.create();
    }

    public Checksum getClientChecksum() {
        return this._clientChecksum;
    }

    public Checksum getTransferChecksum() {
        return this._digest == null ? null : this._checksumFactory.create(this._digest.digest());
    }

    static {
        int port = 0;
        try {
            port = Integer.parseInt(System.getProperty("org.dcache.dcap.port"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        protocolConnectionPoolFactory = new ProtocolConnectionPoolFactory(port, (ChallengeReader)new DCapChallengeReader());
    }

    private class RequestBlock {
        private ByteBuffer _buffer = ByteBuffer.allocate(16384);
        private int _commandSize = 0;
        private int _commandCode = 0;

        private RequestBlock() {
        }

        private void read(SocketChannel channel) throws Exception {
            this._commandCode = 0;
            this._commandSize = 0;
            this._buffer.clear().limit(4);
            this.fillBuffer(channel);
            this._buffer.rewind();
            this._commandSize = this._buffer.getInt();
            if (this._commandSize < 4) {
                throw new CacheException(44, "Protocol Violation (cl<4)");
            }
            try {
                this._buffer.clear().limit(this._commandSize);
            }
            catch (IllegalArgumentException iae) {
                _log.error("Command size excided command block size : " + this._commandSize + "/" + this._buffer.capacity());
                throw iae;
            }
            this.fillBuffer(channel);
            this._buffer.rewind();
            this._commandCode = this._buffer.getInt();
        }

        private int remaining() {
            return this._buffer.remaining();
        }

        private int getCommandCode() {
            return this._commandCode;
        }

        private int nextInt() {
            return this._buffer.getInt();
        }

        private long nextLong() {
            return this._buffer.getLong();
        }

        private void fillBuffer(SocketChannel channel) throws Exception {
            while (this._buffer.hasRemaining()) {
                if (channel.read(this._buffer) >= 0) continue;
                throw new EOFException("EOF on input socket (fillBuffer)");
            }
        }

        private void skip(int skip) {
            this._buffer.position(this._buffer.position() + skip);
        }

        private void get(byte[] array) {
            this._buffer.get(array);
        }

        public String toString() {
            return "RequestBlock [Size=" + this._commandSize + " Code=" + this._commandCode + " Buffer=" + this._buffer;
        }
    }

    private class SpaceMonitorHandler {
        private final Allocator _allocator;
        private long _spaceAllocated = 0L;
        private long _allocationSpace = 0x3200000L;
        private long _spaceUsed = 0L;

        private SpaceMonitorHandler(Allocator allocator) {
            this._allocator = allocator;
        }

        private void setAllocationSpace(long allocSpace) {
            this._allocationSpace = allocSpace;
        }

        private void setInitialSpace(long space) {
            this._spaceAllocated = space;
            this._spaceUsed = space;
        }

        public String toString() {
            return "{a=" + this._spaceAllocated + ";u=" + this._spaceUsed + "}";
        }

        private void getSpace(long newEof) throws InterruptedException {
            if (this._allocator == null) {
                return;
            }
            while (newEof > this._spaceAllocated) {
                DCapProtocol_3_nio.this._status = "WaitingForSpace(" + this._allocationSpace + ")";
                _log.debug("Allocating new space : {}", (Object)this._allocationSpace);
                _logSpaceAllocation.debug("ALLOC: {} : {}", (Object)DCapProtocol_3_nio.this._pnfsId, (Object)this._allocationSpace);
                this._allocator.allocate(this._allocationSpace);
                this._spaceAllocated += this._allocationSpace;
                _log.debug("Allocated new space : {}", (Object)this._allocationSpace);
                DCapProtocol_3_nio.this._status = "";
            }
        }

        private void newFilePosition(long newPosition) {
            this._spaceUsed = Math.max(newPosition, this._spaceUsed);
        }

        private void close(long realFileSize) throws IllegalStateException, InterruptedException {
        }
    }
}

