/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DCapOutputByteBuffer {
    private final ByteBuffer _buffer;

    public DCapOutputByteBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public DCapOutputByteBuffer(int size) {
        this._buffer = ByteBuffer.allocate(size);
    }

    public ByteBuffer buffer() {
        return this._buffer;
    }

    public void writeACK(int command) throws IOException {
        this._buffer.clear();
        this._buffer.putInt(12).putInt(6).putInt(command).putInt(0);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeACK(long location) throws IOException {
        this._buffer.clear();
        this._buffer.putInt(20).putInt(6).putInt(3).putInt(0).putLong(location);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeACK(long location, long size) throws IOException {
        this._buffer.clear();
        this._buffer.putInt(28).putInt(6).putInt(9).putInt(0).putLong(location).putLong(size);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeACK(int command, int returnCode, String message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(message);
        dos.flush();
        dos.close();
        byte[] msgBytes = baos.toByteArray();
        int len = 12 + msgBytes.length;
        this._buffer.clear();
        this._buffer.putInt(len).putInt(6).putInt(command).putInt(returnCode).put(msgBytes, 0, msgBytes.length);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeFIN(int command) throws IOException {
        this._buffer.clear();
        this._buffer.putInt(12).putInt(7).putInt(command).putInt(0);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeFIN(int command, int returnCode, String message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(message);
        dos.flush();
        dos.close();
        byte[] msgBytes = baos.toByteArray();
        int len = 12 + msgBytes.length;
        this._buffer.clear();
        this._buffer.putInt(len).putInt(7).putInt(command).putInt(returnCode).put(msgBytes, 0, msgBytes.length);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeDATA_HEADER() throws IOException {
        this._buffer.clear();
        this._buffer.putInt(4).putInt(8);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeDATA_TRAILER() throws IOException {
        this._buffer.clear();
        this._buffer.putInt(-1);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeDATA_BLOCK(byte[] data, int offset, int size) throws IOException {
        this._buffer.clear();
        this._buffer.putInt(size).put(data, offset, size);
        this._buffer.limit(this._buffer.position()).position(0);
    }

    public void writeEND_OF_BLOCK() {
        this._buffer.clear();
        this._buffer.putInt(0).putInt(-1);
        this._buffer.limit(this._buffer.position()).position(0);
    }
}

