/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.DcapProtocolInterpreter;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.Base64;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CheckStagePermission;
import diskCacheV111.util.DCapUrl;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.SpreadAndWait;
import diskCacheV111.util.VspArgs;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.PnfsFlagMessage;
import diskCacheV111.vehicles.PnfsMessage;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolCheckFileCostMessage;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolMgrGetPoolMsg;
import diskCacheV111.vehicles.PoolMgrQueryPoolsMsg;
import diskCacheV111.vehicles.PoolMgrSelectPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import diskCacheV111.vehicles.PoolPassiveIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.KeepAliveListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.dcache.acl.ACLException;
import org.dcache.acl.enums.AccessMask;
import org.dcache.auth.CachingLoginStrategy;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Origin;
import org.dcache.auth.Subjects;
import org.dcache.auth.UnionLoginStrategy;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.services.login.RemoteLoginStrategy;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCapDoorInterpreterV3
implements KeepAliveListener,
DcapProtocolInterpreter {
    public static final Logger _log = LoggerFactory.getLogger(DCapDoorInterpreterV3.class);
    private final PrintWriter _out;
    private final CellEndpoint _cell;
    private final Args _args;
    private String _ourName = "server";
    private final ConcurrentMap<Integer, SessionHandler> _sessions = new ConcurrentHashMap<Integer, SessionHandler>();
    private String _poolManagerName = null;
    private String _pnfsManagerName = null;
    private CellStub _pinManagerStub;
    private CellPath _poolMgrPath = null;
    private String _pid = "<unknown>";
    private int _uid = -1;
    private int _gid = -1;
    private int _majorVersion = 0;
    private int _minorVersion = 0;
    private Date _startedTS = null;
    private Date _lastCommandTS = null;
    private boolean _authorizationRequired = false;
    private boolean _authorizationStrong = false;
    protected final CellPath _billingCellPath = new CellPath("billing");
    private final InetAddress _clientAddress;
    private final Subject _authenticatedSubject;
    private final LoginStrategy _loginStrategy;
    private final String _stageConfigurationFilePath;
    private final CheckStagePermission _checkStagePermission;
    private boolean _strictSize = false;
    private String _poolProxy = null;
    private Version _minClientVersion = null;
    private Version _maxClientVersion = null;
    private boolean _checkStrict = true;
    private long _poolRetry = 0L;
    private String _hsmManager = null;
    private boolean _truncateAllowed = false;
    private String _ioQueueName = null;
    private boolean _ioQueueAllowOverwrite = false;
    private boolean _isAccessLatencyOverwriteAllowed = false;
    private boolean _isRetentionPolicyOverwriteAllowed = false;
    public String hh_get_door_info = "[-binary]";
    public String hh_toclient = " <id> <subId> server <command ...>";
    public String hh_retry = "<sessionId> [-weak]";

    public DCapDoorInterpreterV3(CellEndpoint cell, PrintWriter pw, Subject subject, InetAddress clientAddress) throws ACLException, IOException {
        String truncate;
        this._out = pw;
        this._cell = cell;
        this._args = cell.getArgs();
        this._authenticatedSubject = new Subject(true, subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
        this._clientAddress = clientAddress;
        String auth = this._args.getOpt("authorization");
        this._authorizationStrong = auth != null && auth.equals("strong");
        this._authorizationRequired = auth != null && (auth.equals("strong") || auth.equals("required"));
        _log.debug("Authorization required:  {}", (Object)this._authorizationRequired);
        _log.debug("Authorization strong: {}", (Object)this._authorizationStrong);
        this._loginStrategy = this.createLoginStrategy();
        this._pnfsManagerName = this._args.getOpt("pnfsManager");
        this._poolManagerName = this._args.getOpt("poolManager");
        this._poolProxy = this._args.getOpt("poolProxy");
        if (this._poolProxy != null) {
            _log.debug("Pool Proxy set to {}", (Object)this._poolProxy);
        }
        this._truncateAllowed = (truncate = this._args.getOpt("truncate")) != null && truncate.equals("true");
        this._isAccessLatencyOverwriteAllowed = this._args.hasOption("allow-access-policy-overwrite");
        _log.debug("Allowes to overwrite AccessLatency: {}", (Object)this._isAccessLatencyOverwriteAllowed);
        this._isRetentionPolicyOverwriteAllowed = this._args.hasOption("allow-retention-policy-overwrite");
        _log.debug("Allowed to overwrite RetentionPolicy: {}", (Object)this._isRetentionPolicyOverwriteAllowed);
        this._poolMgrPath = new CellPath(this._poolManagerName);
        this._pinManagerStub = new CellStub(cell, new CellPath(this._args.getOpt("pinManager")));
        this._checkStrict = this._args.hasOption("check") && this._args.getOpt("check").equals("strict");
        this._strictSize = this._args.hasOption("strict-size");
        this._hsmManager = this._args.getOpt("hsm");
        this._startedTS = new Date();
        String restriction = (String)this._cell.getDomainContext().get("dCapDoor-clientVersion");
        this.installVersionRestrictions(restriction == null ? this._args.getOpt("clientVersion") : restriction);
        String poolRetryValue = (String)this._cell.getDomainContext().get("dCapDoor-poolRetry");
        poolRetryValue = poolRetryValue == null ? (String)this._cell.getDomainContext().get("poolRetry") : poolRetryValue;
        String string = poolRetryValue = poolRetryValue == null ? this._args.getOpt("poolRetry") : poolRetryValue;
        if (poolRetryValue != null) {
            try {
                this._poolRetry = Long.parseLong(poolRetryValue) * 1000L;
            }
            catch (NumberFormatException e) {
                _log.error("Problem in setting PoolRetry Value: {}", (Throwable)e);
            }
        }
        _log.debug("PoolRetry timer set to {} seconds", (Object)(this._poolRetry / 1000L));
        this._ioQueueName = this._args.getOpt("io-queue");
        this._ioQueueName = this._ioQueueName == null || this._ioQueueName.length() == 0 ? null : this._ioQueueName;
        _log.debug("IoQueueName = {}", (Object)(this._ioQueueName == null ? "<undefined>" : this._ioQueueName));
        String tmp = this._args.getOpt("io-queue-overwrite");
        this._ioQueueAllowOverwrite = tmp != null && tmp.equals("allowed");
        _log.debug("IoQueueName : overwrite : {}", (Object)(this._ioQueueAllowOverwrite ? "allowed" : "denied"));
        String check = (String)this._cell.getDomainContext().get("dCapDoor-check");
        if (check != null) {
            this._checkStrict = check.equals("strict");
        }
        if (this._args.hasOption("readOnly")) {
            _log.debug("Door is configured as read-only");
        } else {
            _log.debug("Door is configured as read/write");
        }
        this._stageConfigurationFilePath = this._args.getOpt("stageConfigurationFilePath");
        this._checkStagePermission = new CheckStagePermission(this._stageConfigurationFilePath);
        _log.debug("Check : {}", (Object)(this._checkStrict ? "Strict" : "Fuzzy"));
    }

    private LoginStrategy createLoginStrategy() {
        UnionLoginStrategy union = new UnionLoginStrategy();
        if (this._authorizationStrong || this._authorizationRequired) {
            RemoteLoginStrategy gplazma = new RemoteLoginStrategy(new CellStub(this._cell, new CellPath("gPlazma"), 30000L));
            union.setLoginStrategies(Collections.singletonList(gplazma));
        }
        if (!this._authorizationStrong) {
            union.setAnonymousAccess(UnionLoginStrategy.AccessLevel.FULL);
        }
        return new CachingLoginStrategy((LoginStrategy)union);
    }

    private LoginReply login(String user) throws CacheException {
        Subject subject;
        if (user != null) {
            subject = new Subject();
            subject.getPublicCredentials().addAll(this._authenticatedSubject.getPublicCredentials());
            subject.getPrivateCredentials().addAll(this._authenticatedSubject.getPrivateCredentials());
            subject.getPrincipals().addAll(this._authenticatedSubject.getPrincipals());
            subject.getPrincipals().add((Principal)new LoginNamePrincipal(user));
        } else {
            subject = this._authenticatedSubject;
        }
        LoginReply login = this._loginStrategy.login(subject);
        Origin origin = Subjects.isNobody((Subject)login.getSubject()) ? new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_WEAK, this._clientAddress) : new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_STRONG, this._clientAddress);
        login.getSubject().getPrincipals().add((Principal)origin);
        _log.info("Login completed for {}", (Object)login);
        return login;
    }

    private void installVersionRestrictions(String versionString) {
        if (versionString == null) {
            _log.debug("Client Version not restricted");
            return;
        }
        _log.debug("Client Version Restricted to : {}", (Object)versionString);
        try {
            StringTokenizer st = new StringTokenizer(versionString, ":");
            this._minClientVersion = new Version(st.nextToken());
            this._maxClientVersion = st.countTokens() > 0 ? new Version(st.nextToken()) : null;
        }
        catch (Exception e) {
            _log.error("Client Version : syntax error (limits ignored) : {} : {}", (Object)versionString, (Object)e.toString());
            this._maxClientVersion = null;
            this._minClientVersion = null;
        }
    }

    public synchronized void println(String str) {
        _log.debug("(DCapDoorInterpreterV3) toclient(println) : {}", (Object)str);
        this._out.println(str);
        this._out.flush();
    }

    public synchronized void print(String str) {
        _log.debug("(DCapDoorInterpreterV3) toclient(print) : {}", (Object)str);
        this._out.print(str);
        this._out.flush();
    }

    public void keepAlive() {
        for (SessionHandler sh : this._sessions.values()) {
            try {
                sh.keepAlive();
            }
            catch (Throwable t) {
                _log.error("Keep Alive problem in {}: {}", (Object)sh, (Object)t);
            }
        }
    }

    private void start(SessionHandler session) throws CommandException {
        session.start();
    }

    public String com_hello(int sessionId, int commandId, VspArgs args) throws CommandException {
        String gid;
        String uid;
        String pid;
        this._lastCommandTS = new Date();
        if (args.argc() < 2) {
            throw new CommandExitException("Command Syntax Exception", 2);
        }
        Version version = null;
        try {
            this._majorVersion = Integer.parseInt(args.argv(2));
            this._minorVersion = Integer.parseInt(args.argv(3));
        }
        catch (NumberFormatException e) {
            this._minorVersion = 0;
            this._majorVersion = 0;
            _log.error("Syntax error in client version number : {}", (Object)e.toString());
        }
        version = new Version(this._majorVersion, this._minorVersion);
        _log.debug("Client Version : {}", (Object)version);
        if (this._minClientVersion != null && version.compareTo(this._minClientVersion) < 0 || this._maxClientVersion != null && version.compareTo(this._maxClientVersion) > 0) {
            String error = "Client version rejected : " + version;
            _log.error(error);
            throw new CommandExitException(error, 1);
        }
        String yourName = args.getName();
        if (yourName.equals("server")) {
            this._ourName = "client";
        }
        if ((pid = args.getOpt("pid")) != null) {
            this._pid = pid;
        }
        if ((uid = args.getOpt("uid")) != null) {
            try {
                this._uid = Integer.parseInt(uid);
            }
            catch (NumberFormatException e) {
                _log.warn("Client specified invalid UID: {}", (Object)uid);
            }
        }
        if ((gid = args.getOpt("gid")) != null) {
            try {
                this._gid = Integer.parseInt(gid);
            }
            catch (NumberFormatException e) {
                _log.warn("Client specified invalid GID: {}", (Object)gid);
            }
        }
        return "0 0 " + this._ourName + " welcome " + this._majorVersion + " " + this._minorVersion;
    }

    public String com_byebye(int sessionId, int commandId, VspArgs args) throws CommandException {
        this._lastCommandTS = new Date();
        throw new CommandExitException("byeBye", commandId);
    }

    public synchronized String com_open(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        this._lastCommandTS = new Date();
        if (args.argc() < 4) {
            throw new CommandException(3, "Not enough arguments for put");
        }
        this.start(new IoHandler(sessionId, commandId, args));
        return null;
    }

    public synchronized String com_stage(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for stage");
        }
        this.start(new PrestageHandler(sessionId, commandId, args));
        return null;
    }

    public synchronized String com_lstat(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.get_stat(sessionId, commandId, args, false);
    }

    public synchronized String com_stat(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.get_stat(sessionId, commandId, args, true);
    }

    public synchronized String com_unlink(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_unlink(sessionId, commandId, args, true);
    }

    public synchronized String com_rename(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_rename(sessionId, commandId, args);
    }

    public synchronized String com_rmdir(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_rmdir(sessionId, commandId, args, true);
    }

    public synchronized String com_mkdir(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_mkdir(sessionId, commandId, args, true);
    }

    public synchronized String com_chmod(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_chmod(sessionId, commandId, args, true);
    }

    public synchronized String com_chown(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_chown(sessionId, commandId, args, true);
    }

    public synchronized String com_chgrp(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_chgrp(sessionId, commandId, args, true);
    }

    public synchronized String com_opendir(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
        return this.do_opendir(sessionId, commandId, args);
    }

    private synchronized String do_unlink(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for unlink");
        }
        this.start(new UnlinkHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_rename(int sessionId, int commandId, VspArgs args) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for unlink");
        }
        this.start(new RenameHandler(sessionId, commandId, args));
        return null;
    }

    private synchronized String do_rmdir(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for rmdir");
        }
        this.start(new RmDirHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_mkdir(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for unlink");
        }
        this.start(new MkDirHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_chown(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for chown");
        }
        this.start(new ChownHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_chgrp(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for chgrp");
        }
        this.start(new ChgrpHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_chmod(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for chmod");
        }
        this.start(new ChmodHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    private synchronized String do_opendir(int sessionId, int commandId, VspArgs args) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for opendir");
        }
        this.start(new OpenDirHandler(sessionId, commandId, args));
        return null;
    }

    private synchronized String get_stat(int sessionId, int commandId, VspArgs args, boolean resolvePath) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for stat");
        }
        this.start(new StatHandler(sessionId, commandId, args, resolvePath));
        return null;
    }

    public synchronized String com_ping(int sessionId, int commandId, VspArgs args) {
        this.println(String.valueOf(sessionId) + " " + commandId + " server pong");
        return null;
    }

    public synchronized String com_check(int sessionId, int commandId, VspArgs args) throws CommandException, CacheException {
        this._lastCommandTS = new Date();
        if (args.argc() < 1) {
            throw new CommandException(3, "Not enough arguments for check");
        }
        this.start(new CheckFileHandler(sessionId, commandId, args));
        return null;
    }

    public String com_status(int sessionId, int commandId, VspArgs args) throws CommandException {
        this._lastCommandTS = new Date();
        SessionHandler handler = (SessionHandler)this._sessions.get(sessionId);
        if (handler == null) {
            throw new CommandException(5, "Session ID " + sessionId + " not found.");
        }
        return "" + sessionId + " " + commandId + " " + args.getName() + " ok " + " 0 " + "\"" + handler + "\"";
    }

    public Object ac_get_door_info(Args args) {
        IoDoorInfo info = new IoDoorInfo(this._cell.getCellInfo().getCellName(), this._cell.getCellInfo().getDomainName());
        info.setProtocol("dcap", "3");
        info.setOwner(String.valueOf(this._uid));
        info.setProcess(this._pid);
        ArrayList<IoDoorEntry> list = new ArrayList<IoDoorEntry>(this._sessions.size());
        for (SessionHandler session : this._sessions.values()) {
            if (!(session instanceof IoHandler)) continue;
            list.add(((IoHandler)session).getIoDoorEntry());
        }
        info.setIoDoorEntries(list.toArray(new IoDoorEntry[list.size()]));
        if (args.hasOption("binary")) {
            return info;
        }
        return info.toString();
    }

    public String ac_toclient_$_3_99(Args args) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.argc(); ++i) {
            sb.append(args.argv(i)).append(" ");
        }
        String str = sb.toString();
        _log.debug("toclient (commander) : {}", (Object)str);
        this.println(str);
        return "";
    }

    public String ac_retry_$_1(Args args) throws Exception {
        int sessionId = Integer.parseInt(args.argv(0));
        SessionHandler session = (SessionHandler)this._sessions.get(sessionId);
        if (session == null) {
            throw new CommandException(5, "No such session ID " + sessionId);
        }
        if (!(session instanceof PnfsSessionHandler)) {
            throw new CommandException(6, "Not a PnfsSessionHandler " + sessionId + " but " + session.getClass().getName());
        }
        ((PnfsSessionHandler)session).again(!args.hasOption("weak"));
        return "";
    }

    @Override
    public String execute(VspArgs args) throws CommandExitException {
        DcapCommand dcapCommand;
        int sessionId = args.getSessionId();
        int commandId = args.getSubSessionId();
        try {
            dcapCommand = DcapCommand.get(args.getCommand());
        }
        catch (IllegalArgumentException e) {
            return this.protocolViolation(sessionId, commandId, args.getName(), 669, "Invalid command '" + args.getCommand() + "'");
        }
        try {
            switch (dcapCommand) {
                case HELLO: {
                    return this.com_hello(sessionId, commandId, args);
                }
                case BYEBYE: {
                    return this.com_byebye(sessionId, commandId, args);
                }
                case OPEN: {
                    return this.com_open(sessionId, commandId, args);
                }
                case CHECK: {
                    return this.com_check(sessionId, commandId, args);
                }
                case CHGRP: {
                    return this.com_chgrp(sessionId, commandId, args);
                }
                case CHOWN: {
                    return this.com_chown(sessionId, commandId, args);
                }
                case CHMOD: {
                    return this.com_chmod(sessionId, commandId, args);
                }
                case LSTAT: {
                    return this.com_lstat(sessionId, commandId, args);
                }
                case MKDIR: {
                    return this.com_mkdir(sessionId, commandId, args);
                }
                case OPENDIR: {
                    return this.com_opendir(sessionId, commandId, args);
                }
                case PING: {
                    return this.com_ping(sessionId, commandId, args);
                }
                case RENAME: {
                    return this.com_rename(sessionId, commandId, args);
                }
                case RMDIR: {
                    return this.com_rmdir(sessionId, commandId, args);
                }
                case STAGE: {
                    return this.com_stage(sessionId, commandId, args);
                }
                case STAT: {
                    return this.com_stat(sessionId, commandId, args);
                }
                case STATUS: {
                    return this.com_status(sessionId, commandId, args);
                }
                case UNLINK: {
                    return this.com_unlink(sessionId, commandId, args);
                }
            }
            throw new UnsupportedOperationException("command not supported: " + (Object)((Object)dcapCommand));
        }
        catch (CommandExitException e) {
            throw e;
        }
        catch (CommandException e) {
            return this.commandFailed(sessionId, commandId, args.getName(), e.getErrorCode(), e.getErrorMessage());
        }
        catch (CacheException e) {
            return this.commandFailed(sessionId, commandId, args.getName(), e.getRc(), e.getMessage());
        }
        catch (RuntimeException e) {
            _log.error(e.toString(), (Throwable)e);
            return this.commandFailed(sessionId, commandId, args.getName(), 44, e.getMessage());
        }
    }

    private String commandFailed(int sessionId, int commandId, String name, int errorCode, String errorMessage) {
        String problem = String.format("%d %d %s failed %d \"internalError : %s\"", sessionId, commandId, name, errorCode, errorMessage);
        _log.debug(problem);
        return problem;
    }

    private String protocolViolation(int sessionId, int commandId, String name, int errorCode, String errorMessage) {
        String problem = String.format("%d %d %s failed %d \"protocolViolation : %s\"", sessionId, commandId, name, errorCode, errorMessage);
        _log.debug(problem);
        return problem;
    }

    @Override
    public void close() {
        for (SessionHandler sh : this._sessions.values()) {
            try {
                sh.removeUs();
            }
            catch (RuntimeException e) {
                _log.error("failed to removed session: " + sh, (Throwable)e);
            }
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println(" ----- DCapDoorInterpreterV3 ----------");
        pw.println("      User = " + Subjects.getDisplayName((Subject)this._authenticatedSubject));
        pw.println("  Version  = " + this._majorVersion + "/" + this._minorVersion);
        pw.println("  VLimits  = " + (this._minClientVersion == null ? "*" : this._minClientVersion.toString()) + ":" + (this._maxClientVersion == null ? "*" : this._maxClientVersion.toString()));
        pw.println("   Started = " + this._startedTS);
        pw.println("   Last at = " + this._lastCommandTS);
        for (Map.Entry session : this._sessions.entrySet()) {
            pw.println(((Integer)session.getKey()).toString() + " -> " + ((SessionHandler)session.getValue()).toString());
        }
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Object object = msg.getMessageObject();
        if (!(object instanceof Message)) {
            _log.warn("Unexpected message class {} source = {}", object.getClass(), (Object)msg.getSourceAddress());
            return;
        }
        Message reply = (Message)object;
        SessionHandler handler = (SessionHandler)this._sessions.get((int)reply.getId());
        if (handler == null) {
            _log.info("Reply ({}) for obsolete session: {}", reply.getClass(), (Object)reply.getId());
            return;
        }
        if (reply instanceof DoorTransferFinishedMessage) {
            ((IoHandler)handler).doorTransferArrived((DoorTransferFinishedMessage)reply);
        } else if (reply instanceof PoolMgrGetPoolMsg) {
            ((IoHandler)handler).poolMgrSelectPoolArrived((PoolMgrSelectPoolMsg)reply);
        } else if (reply instanceof PnfsGetFileAttributes) {
            ((PnfsSessionHandler)handler).pnfsGetFileAttributesArrived((PnfsGetFileAttributes)reply);
        } else if (reply instanceof PoolIoFileMessage) {
            ((IoHandler)handler).poolIoFileArrived((PoolIoFileMessage)reply);
        } else if (reply instanceof PoolPassiveIoFileMessage) {
            ((IoHandler)handler).poolPassiveIoFileMessage((PoolPassiveIoFileMessage)reply);
        } else {
            _log.warn("Unexpected message class {} source = {}", object.getClass(), (Object)msg.getSourceAddress());
        }
    }

    private void postToBilling(DoorRequestInfoMessage info) {
        try {
            this._cell.sendMessage(new CellMessage(this._billingCellPath, (Object)info));
        }
        catch (NoRouteToCellException ee) {
            _log.info("Billing is not available.");
        }
    }

    protected class OpenDirHandler
    extends PnfsSessionHandler {
        private DCapProtocolInfo _protocolInfo;
        private String _pool;
        private String[] _hosts;

        private OpenDirHandler(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, true);
            this._protocolInfo = null;
            this._pool = "dirLookupPool";
            this._hosts = null;
            int port = Integer.parseInt(this._vargs.argv(2));
            StringTokenizer st = new StringTokenizer(this._vargs.argv(1), ",");
            this._hosts = new String[st.countTokens()];
            for (int i = 0; i < this._hosts.length; ++i) {
                this._hosts[i] = st.nextToken();
            }
            this._protocolInfo = new DCapProtocolInfo("DCap", 3, 0, this._hosts, port);
            this._protocolInfo.setSessionId(this._sessionId);
            String pool = args.getOpt("lookupPool");
            if (pool != null) {
                this._pool = pool;
            }
        }

        @Override
        protected void askForFileAttributes() throws IllegalArgumentException, NoRouteToCellException {
            this.setTimer(60000L);
            try {
                PnfsId pnfsId = new PnfsId(this._vargs.argv(0));
                this._message = new PnfsGetFileAttributes(pnfsId, this._attributes);
            }
            catch (IllegalArgumentException e) {
                DCapUrl url = new DCapUrl(this._vargs.argv(0));
                String fileName = url.getFilePart();
                this._message = new PnfsGetFileAttributes(fileName, this._attributes);
                this._path = fileName;
            }
            _log.debug("Requesting file attributes for {}", (Object)this._message);
            this._message.setAccessMask(EnumSet.of(AccessMask.LIST_DIRECTORY));
            this._message.setId((long)this._sessionId);
            this._message.setReplyRequired(true);
            if (this._path == null) {
                this._path = this._vargs.getOpt("path");
            }
            if (this._path != null) {
                this._info.setPath(this._path);
            }
            this._pnfs.send((PnfsMessage)this._message);
            this.setStatus("WaitingForPnfs");
        }

        @Override
        public void fileAttributesAvailable() {
            String path = this._message.getPnfsPath();
            if (this._fileAttributes.getFileType() != FileType.DIR) {
                this.sendReply("fileAttributesAvailable", 22, path + " is not a directory", "ENOTDIR");
                this.removeUs();
                return;
            }
            PoolIoFileMessage poolIoFileMessage = new PoolIoFileMessage(this._pool, this._fileAttributes.getPnfsId(), (ProtocolInfo)this._protocolInfo);
            poolIoFileMessage.setId((long)this._sessionId);
            if (DCapDoorInterpreterV3.this._ioQueueName != null) {
                poolIoFileMessage.setIoQueueName(DCapDoorInterpreterV3.this._ioQueueName);
            }
            if (DCapDoorInterpreterV3.this._ioQueueAllowOverwrite && this._ioHandlerQueue != null && this._ioHandlerQueue.length() > 0) {
                poolIoFileMessage.setIoQueueName(this._ioHandlerQueue);
            }
            try {
                DCapDoorInterpreterV3.this._cell.sendMessage(new CellMessage(new CellPath(this._pool), (Object)poolIoFileMessage));
            }
            catch (Exception ie) {
                this.sendReply("poolMgrGetPoolArrived", 2, ie.toString());
                this.removeUs();
                return;
            }
        }

        public void poolIoFileArrived(PoolIoFileMessage reply) {
            _log.debug("poolIoFileArrived : {}", (Object)reply);
            if (reply.getReturnCode() != 0) {
                this.sendReply("poolIoFileArrived", (Message)reply);
                this.removeUs();
                return;
            }
            this.setStatus("WaitingForDoorTransferOk");
        }

        public synchronized void doorTransferArrived(DoorTransferFinishedMessage reply) {
            if (reply.getReturnCode() == 0) {
                this.sendReply("doorTransferArrived", 0, "");
            } else {
                this.sendReply("doorTransferArrived", (Message)reply);
            }
            this.removeUs();
            this.setStatus("<done>");
        }

        @Override
        public String toString() {
            return "od [" + this._pool + "] " + super.toString();
        }
    }

    protected class IoHandler
    extends PnfsSessionHandler {
        private String _ioMode;
        private DCapProtocolInfo _protocolInfo;
        private String _pool;
        private Integer _moverId;
        private String[] _hosts;
        private boolean _isHsmRequest;
        private boolean _overwrite;
        private String _checksumString;
        private boolean _truncate;
        private boolean _isNew;
        private String _truncFile;
        private boolean _poolRequestDone;
        private String _permission;
        private boolean _passive;
        private String _accessLatency;
        private String _retentionPolicy;
        private boolean _isUrl;
        private PoolMgrSelectReadPoolMsg.Context _readPoolSelectionContext;

        private IoHandler(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
            super(sessionId, commandId, args, false, true);
            this._ioMode = null;
            this._protocolInfo = null;
            this._pool = "<unknown>";
            this._moverId = null;
            this._hosts = null;
            this._isHsmRequest = false;
            this._overwrite = false;
            this._checksumString = null;
            this._truncate = false;
            this._isNew = false;
            this._truncFile = null;
            this._poolRequestDone = false;
            this._permission = null;
            this._passive = false;
            this._accessLatency = null;
            this._retentionPolicy = null;
            this._ioMode = this._vargs.argv(1);
            int port = Integer.parseInt(this._vargs.argv(3));
            StringTokenizer st = new StringTokenizer(this._vargs.argv(2), ",");
            this._passive = args.hasOption("passive");
            if (this._passive) {
                this._hosts = new String[]{DCapDoorInterpreterV3.this._clientAddress.getHostAddress()};
            } else {
                this._hosts = new String[st.countTokens()];
                for (int i = 0; i < this._hosts.length; ++i) {
                    this._hosts[i] = st.nextToken();
                }
            }
            this._protocolInfo = new DCapProtocolInfo("DCap", 3, 0, this._hosts, port);
            this._protocolInfo.setSessionId(this._sessionId);
            this._isHsmRequest = args.hasOption("hsm");
            if (this._isHsmRequest) {
                _log.debug("Hsm Feature Requested");
                if (DCapDoorInterpreterV3.this._hsmManager == null) {
                    throw new CacheException(105, "Hsm Support Not enabled");
                }
            }
            this._overwrite = args.hasOption("overwrite");
            DCapDoorInterpreterV3.this._strictSize = args.hasOption("strict-size");
            this._checksumString = args.getOpt("checksum");
            this._truncFile = args.getOpt("truncate");
            this._truncate = this._truncFile != null && DCapDoorInterpreterV3.this._truncateAllowed;
            this._protocolInfo.isPassive(this._passive);
            this._accessLatency = args.getOpt("access-latency");
            this._retentionPolicy = args.getOpt("retention-policy");
            this._protocolInfo.door(new CellPath(DCapDoorInterpreterV3.this._cell.getCellInfo().getCellName(), DCapDoorInterpreterV3.this._cell.getCellInfo().getDomainName()));
            this._attributes.addAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes());
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
        }

        @Override
        protected void askForFileAttributes() throws IllegalArgumentException, NoRouteToCellException {
            this.setTimer(60000L);
            try {
                PnfsId pnfsId = new PnfsId(this._vargs.argv(0));
                this._message = new PnfsGetFileAttributes(pnfsId, this._attributes);
            }
            catch (IllegalArgumentException e) {
                DCapUrl url = new DCapUrl(this._vargs.argv(0));
                String fileName = url.getFilePart();
                this._message = new PnfsGetFileAttributes(fileName, this._attributes);
                this._isUrl = true;
                this._path = fileName;
            }
            _log.debug("Requesting file attributes for {}", (Object)this._message);
            if (this._vargs.argv(1).equals("r")) {
                this._message.setAccessMask(EnumSet.of(AccessMask.READ_DATA));
            }
            this._message.setId((long)this._sessionId);
            this._message.setReplyRequired(true);
            if (!this._isUrl && !DCapDoorInterpreterV3.this._authorizationRequired) {
                this._pnfs = new PnfsHandler(this._pnfs, null);
            }
            if (this._path == null) {
                this._path = this._vargs.getOpt("path");
            }
            if (this._path != null) {
                this._info.setPath(this._path);
            }
            this._pnfs.send((PnfsMessage)this._message);
            this.setStatus("WaitingForPnfs");
        }

        public IoDoorEntry getIoDoorEntry() {
            PnfsId pnfsid = this._fileAttributes != null ? this._fileAttributes.getPnfsId() : null;
            return new IoDoorEntry((long)this._sessionId, pnfsid, this._pool, this._status, this._statusSince, this._hosts[0]);
        }

        @Override
        public void again(boolean strong) throws IllegalArgumentException, NoRouteToCellException {
            if (strong) {
                this._poolRequestDone = false;
            }
            super.again(strong);
        }

        @Override
        public boolean fileAttributesNotAvailable() throws CacheException {
            if (this._isHsmRequest) {
                throw new CacheException(107, "Hsm only supports existing files");
            }
            if (!this._isUrl) {
                this.sendReply("fileAttributesNotAvailable", (Message)this._message);
                return false;
            }
            _log.debug("storageInfoNotAvailable : is url (mode={})", (Object)this._ioMode);
            if (this._ioMode.equals("r")) {
                throw new CacheException(2, "No such file or directory");
            }
            String path = this._message.getPnfsPath();
            String parent = new File(path).getParent();
            _log.debug("Creating file. path=_getStorageInfo.getPnfsPath()  -> path = {}", (Object)path);
            _log.debug("Creating file. parent = new File(path).getParent()  -> parent = {}", (Object)parent);
            _log.info("Creating file {}", (Object)path);
            PnfsCreateEntryMessage pnfsEntry = this._pnfs.createPnfsEntry(this._message.getPnfsPath(), this.getUid(), this.getGid(), this.getMode(-1));
            _log.debug("storageInfoNotAvailable : created pnfsid: {} path: {}", (Object)pnfsEntry.getPnfsId(), (Object)pnfsEntry.getPnfsPath());
            this._message = pnfsEntry;
            this._isNew = true;
            return true;
        }

        @Override
        public void fileAttributesAvailable() {
            _log.debug("{} storageInfoAvailable after {} ", (Object)this._fileAttributes.getPnfsId(), (Object)(System.currentTimeMillis() - this._started));
            PoolMgrSelectReadPoolMsg getPoolMessage = null;
            if (this._fileAttributes.getFileType() != FileType.REGULAR) {
                this.sendReply("fileAttributesAvailable", 1, "Not a File");
                this.removeUs();
                return;
            }
            if (this._fileAttributes.getStorageInfo().isCreatedOnly() || this._overwrite || this._truncate || this._isHsmRequest && this._ioMode.indexOf(119) >= 0) {
                if (this._isHsmRequest && this._fileAttributes.getStorageInfo().isStored()) {
                    this.sendReply("fileAttributesAvailable", 1, "HsmRequest : file already stored");
                    this.removeUs();
                    return;
                }
                if (this._ioMode.indexOf(119) < 0) {
                    this.sendReply("fileAttributesAvailable", 1, "File doesn't exist (can't be readOnly)");
                    this.removeUs();
                    return;
                }
                this._protocolInfo.setAllowWrite(true);
                if (this._overwrite) {
                    this._fileAttributes.getStorageInfo().setKey("overwrite", "true");
                    _log.debug("Overwriting requested");
                }
                if (this._truncate && !this._isNew) {
                    try {
                        if (this._isUrl) {
                            String path = this._message.getPnfsPath();
                            _log.debug("truncating path {}", (Object)path);
                            this._pnfs.deletePnfsEntry(path);
                            this._message = this._pnfs.createPnfsEntry(path, this.getUid(), this.getGid(), this.getMode(-1));
                            this._fileAttributes = this._message.getFileAttributes();
                        } else {
                            this._message = this._pnfs.getStorageInfoByPnfsId(this._fileAttributes.getPnfsId());
                            this._fileAttributes = this._message.getFileAttributes();
                        }
                    }
                    catch (CacheException ce) {
                        _log.error(ce.toString());
                        this.sendReply("fileAttributesAvailable", 1, "Failed to truncate file");
                        this.removeUs();
                        return;
                    }
                }
                if (!this._isUrl && this._path != null) {
                    this._fileAttributes.getStorageInfo().setKey("path", this._path);
                }
                if (this._checksumString != null) {
                    this._fileAttributes.getStorageInfo().setKey("checksum", this._checksumString);
                    _log.debug("Checksum from client {}", (Object)this._checksumString);
                    this.storeChecksumInPnfs(this._fileAttributes.getPnfsId(), this._checksumString);
                }
                if (DCapDoorInterpreterV3.this._isAccessLatencyOverwriteAllowed && this._accessLatency != null) {
                    try {
                        AccessLatency accessLatency = AccessLatency.getAccessLatency((String)this._accessLatency);
                        this._fileAttributes.getStorageInfo().setAccessLatency(accessLatency);
                        this._fileAttributes.getStorageInfo().isSetAccessLatency(true);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (DCapDoorInterpreterV3.this._isRetentionPolicyOverwriteAllowed && this._retentionPolicy != null) {
                    try {
                        RetentionPolicy retentionPolicy = RetentionPolicy.getRetentionPolicy((String)this._retentionPolicy);
                        this._fileAttributes.getStorageInfo().setRetentionPolicy(retentionPolicy);
                        this._fileAttributes.getStorageInfo().isSetRetentionPolicy(true);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                getPoolMessage = new PoolMgrSelectWritePoolMsg(this._fileAttributes, (ProtocolInfo)this._protocolInfo, 0L);
                getPoolMessage.setIoQueueName(DCapDoorInterpreterV3.this._ioQueueName);
                if (this._path != null) {
                    getPoolMessage.setPnfsPath(this._path);
                }
            } else {
                EnumSet allowedStates;
                if (this._ioMode.indexOf(119) > -1) {
                    this.sendReply("fileAttributesAvailable", 1, "File is readOnly");
                    this.removeUs();
                    return;
                }
                this._protocolInfo.setAllowWrite(false);
                try {
                    allowedStates = DCapDoorInterpreterV3.this._checkStagePermission.canPerformStaging(this._subject, this._fileAttributes.getStorageInfo()) ? RequestContainerV5.allStates : RequestContainerV5.allStatesExceptStage;
                }
                catch (IOException e) {
                    allowedStates = RequestContainerV5.allStatesExceptStage;
                    _log.error("Error while reading data from StageConfiguration.conf file : {}", (Object)e.getMessage());
                }
                getPoolMessage = new PoolMgrSelectReadPoolMsg(this._fileAttributes, (ProtocolInfo)this._protocolInfo, 0L, this._readPoolSelectionContext, allowedStates);
                getPoolMessage.setIoQueueName(DCapDoorInterpreterV3.this._ioQueueName);
            }
            if (this._verbose) {
                this.sendComment("opened");
            }
            getPoolMessage.setSubject(this._subject);
            getPoolMessage.setId((long)this._sessionId);
            try {
                DCapDoorInterpreterV3.this._cell.sendMessage(new CellMessage(new CellPath(this._isHsmRequest ? DCapDoorInterpreterV3.this._hsmManager : DCapDoorInterpreterV3.this._poolManagerName), (Object)getPoolMessage));
            }
            catch (Exception ie) {
                this.sendReply("fileAttributesAvailable", 2, ie.toString());
                this.removeUs();
                return;
            }
            this.setStatus("WaitingForGetPool");
            this.setTimer(DCapDoorInterpreterV3.this._poolRetry);
        }

        private void storeChecksumInPnfs(PnfsId pnfsId, String checksumString) {
            try {
                PnfsFlagMessage flag = new PnfsFlagMessage(pnfsId, "c", PnfsFlagMessage.FlagOperation.SET);
                flag.setReplyRequired(false);
                flag.setValue(checksumString);
                this._pnfs.send((PnfsMessage)flag);
            }
            catch (Exception eee) {
                _log.error("Failed to send crc to PnfsManager : {}", (Object)eee.toString());
            }
        }

        public void poolMgrSelectPoolArrived(PoolMgrSelectPoolMsg reply) {
            this.setTimer(0L);
            _log.debug("poolMgrGetPoolArrived : {}", (Object)reply);
            _log.debug("{} poolMgrSelectPoolArrived after {}", (Object)this._fileAttributes.getPnfsId(), (Object)(System.currentTimeMillis() - this._started));
            if (reply.getReturnCode() != 0) {
                if (reply.getReturnCode() == 10021 || DCapDoorInterpreterV3.this._poolRetry == 0L) {
                    try {
                        this.again(true);
                    }
                    catch (NoRouteToCellException e) {
                        _log.error("No route to {}", (Object)e.getDestinationPath());
                        this.sendReply("poolMgrGetPoolArrived", (Message)reply);
                        this.removeUs();
                    }
                } else {
                    this.setTimer(DCapDoorInterpreterV3.this._poolRetry);
                }
                return;
            }
            String pool = null;
            pool = reply.getPoolName();
            if (pool == null) {
                this.sendReply("poolMgrGetPoolArrived", 33, "No pools available");
                this.removeUs();
                return;
            }
            this._fileAttributes.setStorageInfo(reply.getStorageInfo());
            this._pool = pool;
            PoolAcceptFileMessage poolMessage = null;
            if (reply instanceof PoolMgrSelectReadPoolMsg) {
                this._readPoolSelectionContext = ((PoolMgrSelectReadPoolMsg)reply).getContext();
                poolMessage = new PoolDeliverFileMessage(pool, this._fileAttributes.getPnfsId(), (ProtocolInfo)this._protocolInfo, this._fileAttributes.getStorageInfo());
            } else if (reply instanceof PoolMgrSelectWritePoolMsg) {
                poolMessage = new PoolAcceptFileMessage(pool, this._fileAttributes.getPnfsId(), (ProtocolInfo)this._protocolInfo, this._fileAttributes.getStorageInfo());
            } else {
                this.sendReply("poolMgrGetPoolArrived", 7, "Illegal Message arrived : " + reply.getClass().getName());
                this.removeUs();
                return;
            }
            poolMessage.setId((long)this._sessionId);
            poolMessage.setInitiator(this._info.getTransaction());
            if (DCapDoorInterpreterV3.this._ioQueueName != null) {
                poolMessage.setIoQueueName(DCapDoorInterpreterV3.this._ioQueueName);
            }
            if (DCapDoorInterpreterV3.this._ioQueueAllowOverwrite && this._ioHandlerQueue != null && this._ioHandlerQueue.length() > 0) {
                poolMessage.setIoQueueName(this._ioHandlerQueue);
            }
            if (this._poolRequestDone) {
                _log.debug("Ignoring double message");
                return;
            }
            try {
                CellPath toPool = null;
                if (DCapDoorInterpreterV3.this._poolProxy == null) {
                    toPool = new CellPath(pool);
                } else {
                    toPool = new CellPath(DCapDoorInterpreterV3.this._poolProxy);
                    toPool.add(pool);
                }
                DCapDoorInterpreterV3.this._cell.sendMessage(new CellMessage(toPool, (Object)poolMessage));
                this._poolRequestDone = true;
            }
            catch (Exception ie) {
                this.sendReply("poolMgrGetPoolArrived", 2, ie.toString());
                this.removeUs();
                return;
            }
            this.setStatus("WaitingForOpenFile");
        }

        public void poolIoFileArrived(PoolIoFileMessage reply) {
            _log.debug("poolIoFileArrived : {}", (Object)reply);
            if (reply.getReturnCode() != 0) {
                if (reply.getReturnCode() == 10007) {
                    try {
                        this.again(true);
                        return;
                    }
                    catch (NoRouteToCellException e) {
                        _log.error("No route to {}", (Object)e.getDestinationPath());
                    }
                }
                this.sendReply("poolIoFileArrived", (Message)reply);
                this.removeUs();
                return;
            }
            this._moverId = reply.getMoverId();
            this.setStatus("WaitingForDoorTransferOk");
        }

        public void poolPassiveIoFileMessage(PoolPassiveIoFileMessage reply) {
            InetSocketAddress poolSocketAddress = reply.socketAddress();
            StringBuffer sb = new StringBuffer();
            sb.append(this._sessionId).append(" ").append(this._commandId).append(" ").append(this._vargs.getName()).append(" connect ").append(poolSocketAddress.getHostName()).append(" ").append(poolSocketAddress.getPort()).append(" ").append(Base64.byteArrayToBase64((byte[])reply.challange()));
            DCapDoorInterpreterV3.this.println(sb.toString());
            this.setStatus("WaitingForDoorTransferOk");
        }

        public synchronized void doorTransferArrived(DoorTransferFinishedMessage reply) {
            if (reply.getReturnCode() == 0) {
                long filesize = reply.getStorageInfo().getFileSize();
                _log.info("doorTransferArrived : fs={};strict={};m={}", new Object[]{filesize, DCapDoorInterpreterV3.this._strictSize, this._ioMode});
                if (DCapDoorInterpreterV3.this._strictSize && filesize > 0L && this._ioMode.indexOf("w") > -1) {
                    for (int count = 0; count < 10; ++count) {
                        try {
                            long fs = this._pnfs.getStorageInfoByPnfsId(this._fileAttributes.getPnfsId()).getStorageInfo().getFileSize();
                            _log.info("doorTransferArrived : Size of {}: {}", (Object)this._fileAttributes.getPnfsId(), (Object)fs);
                            if (fs > 0L) {
                                break;
                            }
                        }
                        catch (Exception ee) {
                            _log.error("Problem getting storage info (check) for {}: {}", (Object)this._fileAttributes.getPnfsId(), (Object)ee);
                        }
                        try {
                            Thread.sleep(10000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
                this.sendReply("doorTransferArrived", 0, "");
            } else {
                this.sendReply("doorTransferArrived", (Message)reply);
            }
            this._moverId = null;
            this.removeUs();
            this.setStatus("<done>");
        }

        @Override
        public String toString() {
            return "io [" + this._pool + "] " + super.toString();
        }

        @Override
        public void removeUs() {
            if (this._moverId != null) {
                PoolMoverKillMessage message = new PoolMoverKillMessage(this._pool, this._moverId.intValue());
                message.setReplyRequired(false);
                try {
                    DCapDoorInterpreterV3.this._cell.sendMessage(new CellMessage(new CellPath(this._pool), (Object)message));
                }
                catch (NoRouteToCellException e) {
                    _log.error("pool {} is unreachable", (Object)this._pool);
                }
            }
            super.removeUs();
        }
    }

    protected class CheckFileHandler
    extends PnfsSessionHandler {
        private final String _destination;
        private final String _protocolName;
        private List<String> _assumedLocations;

        private CheckFileHandler(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
            super(sessionId, commandId, args, false, true);
            this._info.setMessageType("check");
            this._destination = args.getOpt("location");
            String protocolName = args.getOpt("protocol");
            this._protocolName = protocolName == null ? "DCap/3" : protocolName;
        }

        @Override
        protected void doStart() throws CacheException {
            try {
                PnfsId pnfsId = new PnfsId(this._vargs.argv(0));
                this._assumedLocations = this._pnfs.getCacheLocations(pnfsId);
            }
            catch (IllegalArgumentException e) {
                DCapUrl url = new DCapUrl(this._vargs.argv(0));
                String fileName = url.getFilePart();
                this._assumedLocations = this._pnfs.getCacheLocationsByPath(fileName);
            }
            if (this._assumedLocations.isEmpty()) {
                throw new CacheException(4, "File is not cached");
            }
            super.doStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                PoolMgrQueryPoolsMsg query = new PoolMgrQueryPoolsMsg(PoolSelectionUnit.DirectionType.READ, this._protocolName, this._destination, this._fileAttributes.getStorageInfo());
                CellMessage checkMessage = new CellMessage(DCapDoorInterpreterV3.this._poolMgrPath, (Object)query);
                this.setStatus("Waiting for reply from PoolManager");
                checkMessage = DCapDoorInterpreterV3.this._cell.sendAndWait(checkMessage, 20000L);
                query = (PoolMgrQueryPoolsMsg)checkMessage.getMessageObject();
                if (query.getReturnCode() != 0) {
                    throw new CacheException(query.getReturnCode(), query.getErrorObject() == null ? "?" : query.getErrorObject().toString());
                }
                HashSet<String> assumedHash = new HashSet<String>(this._assumedLocations);
                List[] lists = query.getPools();
                ArrayList<String> result = new ArrayList<String>();
                for (int i = 0; i < lists.length; ++i) {
                    for (String pool : lists[i]) {
                        if (!assumedHash.contains(pool)) continue;
                        result.add(pool);
                    }
                }
                if (result.size() == 0) {
                    throw new CacheException(4, "File not cached");
                }
                if (DCapDoorInterpreterV3.this._checkStrict) {
                    SpreadAndWait controller = new SpreadAndWait(DCapDoorInterpreterV3.this._cell, 10000L);
                    for (String pool : result) {
                        _log.debug("Sending query to pool {}", (Object)pool);
                        PoolCheckFileCostMessage request = new PoolCheckFileCostMessage(pool, this._fileAttributes.getPnfsId(), 0L);
                        controller.send(new CellMessage(new CellPath(pool), (Object)request));
                    }
                    controller.waitForReplies();
                    int numberOfReplies = controller.getReplyCount();
                    _log.debug("Number of valied replies: {}", (Object)numberOfReplies);
                    if (numberOfReplies == 0) {
                        throw new CacheException(4, "File not cached");
                    }
                    Iterator iterate = controller.getReplies();
                    int found = 0;
                    while (iterate.hasNext()) {
                        CellMessage msg = (CellMessage)iterate.next();
                        Object obj = msg.getMessageObject();
                        if (!(obj instanceof PoolCheckFileCostMessage)) {
                            _log.error("Unexpected reply from PoolCheckFileCostMessage: {}", (Object)obj.getClass().getName());
                            continue;
                        }
                        PoolCheckFileCostMessage reply = (PoolCheckFileCostMessage)obj;
                        if (reply.getHave()) {
                            _log.debug("pool {}: ok", (Object)reply.getPoolName());
                            ++found;
                            continue;
                        }
                        _log.debug("pool {}: File not found", (Object)reply.getPoolName());
                    }
                    if (found == 0) {
                        throw new CacheException(4, "File not cached");
                    }
                }
                this.sendReply("storageInfoAvailable", 0, "");
            }
            catch (CacheException cee) {
                _log.debug(cee.toString());
                this.sendReply("storageInfoAvailable", cee.getRc(), cee.getMessage());
            }
            catch (Exception ee) {
                _log.error(ee.toString());
                this.sendReply("storageInfoAvailable", 104, ee.getMessage());
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "ck " + super.toString();
        }
    }

    protected class MkDirHandler
    extends PnfsSessionHandler {
        private MkDirHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'mkdir': Permission denied");
            }
        }

        @Override
        public boolean fileAttributesNotAvailable() throws CacheException {
            String path = this._message.getPnfsPath();
            this._pnfs.createPnfsDirectory(path, this.getUid(), this.getGid(), this.getMode(-1));
            this.sendReply("fileAttributesNotAvailable", 0, "");
            return false;
        }

        @Override
        public void fileAttributesAvailable() {
            this.sendReply("fileAttributesAvailable", 20, "Directory exists", "EEXIST");
            this.removeUs();
        }

        @Override
        public String toString() {
            return "mk " + super.toString();
        }
    }

    protected class RmDirHandler
    extends PnfsSessionHandler {
        private RmDirHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'rmdir': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                this._pnfs.deletePnfsEntry(this._message.getPnfsPath(), EnumSet.of(FileType.DIR));
                this.sendReply("fileAttributesAvailable", 0, "");
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 23, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "uk " + super.toString();
        }
    }

    protected class RenameHandler
    extends PnfsSessionHandler {
        private String _newName;

        private RenameHandler(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, false);
            this._newName = null;
            this._newName = args.argv(1);
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'rename': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                this._pnfs.renameEntry(this._fileAttributes.getPnfsId(), this._newName);
                this.sendReply("fileAttributesAvailable", 0, "");
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 19, e.getMessage(), "EACCES");
            }
            catch (Exception e) {
                this.sendReply("fileAttributesAvailable", 23, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "rn " + super.toString();
        }
    }

    protected class ChgrpHandler
    extends PnfsSessionHandler {
        private int _group;

        private ChgrpHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
            this._group = -1;
            this._group = Integer.parseInt(args.getOpt("group"));
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'chgrp': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            FileMetaData meta = new FileMetaData(this._fileAttributes);
            try {
                if (this._group >= 0) {
                    meta.setGid(this._group);
                }
                this._pnfs.pnfsSetFileMetaData(this._fileAttributes.getPnfsId(), meta);
                this.sendReply("fileAttributesAvailable", 0, "");
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 19, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "uk " + super.toString();
        }
    }

    protected class ChownHandler
    extends PnfsSessionHandler {
        private int _owner;
        private int _group;

        private ChownHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
            this._owner = -1;
            this._group = -1;
            String[] owner_group = args.getOpt("owner").split("[:]");
            this._owner = Integer.parseInt(owner_group[0]);
            if (owner_group.length == 2) {
                this._group = Integer.parseInt(owner_group[1]);
            }
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'chown': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            FileMetaData meta = new FileMetaData(this._fileAttributes);
            try {
                if (this._owner >= 0) {
                    meta.setUid(this._owner);
                }
                if (this._group >= 0) {
                    meta.setGid(this._group);
                }
                this._pnfs.pnfsSetFileMetaData(this._fileAttributes.getPnfsId(), meta);
                this.sendReply("fileAttributesAvailable", 0, "");
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 19, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "uk " + super.toString();
        }
    }

    protected class ChmodHandler
    extends PnfsSessionHandler {
        private int _permission;

        private ChmodHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
            this._permission = 0;
            this._permission = Integer.decode(args.getOpt("mode"));
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'chmod': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                FileMetaData meta = new FileMetaData(this._fileAttributes);
                meta.setMode(this._permission);
                this._pnfs.pnfsSetFileMetaData(this._fileAttributes.getPnfsId(), meta);
                this.sendReply("fileAttributesAvailable", 0, "");
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 19, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "uk " + super.toString();
        }
    }

    protected class UnlinkHandler
    extends PnfsSessionHandler {
        private UnlinkHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            if (this._readOnly) {
                throw new CacheException(2, "Cannot execute 'unlink': Permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                String path = this._message.getPnfsPath();
                if (this._fileAttributes.getFileType() != FileType.DIR) {
                    this._pnfs.deletePnfsEntry(path);
                    this.sendReply("fileAttributesAvailable", 0, "");
                    this.sendRemoveInfoToBilling(path);
                } else {
                    this.sendReply("fileAttributesAvailable", 17, "Path is a Directory", "EISDIR");
                }
            }
            catch (CacheException e) {
                this.sendReply("fileAttributesAvailable", 19, e.getMessage(), "EACCES");
            }
            finally {
                this.removeUs();
            }
        }

        private void sendRemoveInfoToBilling(String path) {
            CellInfo cellInfo = DCapDoorInterpreterV3.this._cell.getCellInfo();
            DoorRequestInfoMessage infoRemove = new DoorRequestInfoMessage(cellInfo.getCellName() + "@" + cellInfo.getDomainName(), "remove");
            infoRemove.setSubject(this._subject);
            infoRemove.setPath(path);
            DCapDoorInterpreterV3.this.postToBilling(infoRemove);
        }

        @Override
        public String toString() {
            return "uk " + super.toString();
        }
    }

    protected class StatHandler
    extends PnfsSessionHandler {
        private StatHandler(int sessionId, int commandId, VspArgs args, boolean followLinks) throws CacheException, CommandException {
            super(sessionId, commandId, args, true, followLinks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                FileMetaData meta = new FileMetaData(this._fileAttributes);
                StringBuilder sb = new StringBuilder();
                sb.append(this._sessionId).append(" ").append(this._commandId).append(" ").append(this._vargs.getName()).append(" stat ");
                sb.append("-st_size=").append(meta.getFileSize()).append(" ");
                sb.append("-st_uid=").append(meta.getUid()).append(" ");
                sb.append("-st_gid=").append(meta.getGid()).append(" ");
                sb.append("-st_atime=").append(meta.getLastAccessedTime() / 1000L).append(" ");
                sb.append("-st_mtime=").append(meta.getLastModifiedTime() / 1000L).append(" ");
                sb.append("-st_ctime=").append(meta.getCreationTime() / 1000L).append(" ");
                FileMetaData.Permissions user = meta.getUserPermissions();
                FileMetaData.Permissions group = meta.getGroupPermissions();
                FileMetaData.Permissions world = meta.getWorldPermissions();
                sb.append("-st_mode=").append(meta.isRegularFile() ? "-" : (meta.isDirectory() ? "d" : (meta.isSymbolicLink() ? "l" : "x"))).append(user.canRead() ? "r" : "-").append(user.canWrite() ? "w" : "-").append(user.canExecute() ? "x" : "-").append(group.canRead() ? "r" : "-").append(group.canWrite() ? "w" : "-").append(group.canExecute() ? "x" : "-").append(world.canRead() ? "r" : "-").append(world.canWrite() ? "w" : "-").append(world.canExecute() ? "x" : "-").append(" ");
                sb.append("-st_ino=").append(this._fileAttributes.getPnfsId().toString().hashCode() & 0xFFFFFFF);
                DCapDoorInterpreterV3.this.println(sb.toString());
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "st " + super.toString();
        }
    }

    protected class PrestageHandler
    extends PnfsSessionHandler {
        private final String _destination;

        private PrestageHandler(int sessionId, int commandId, VspArgs args) throws CacheException, CommandException {
            super(sessionId, commandId, args, false, true);
            this._destination = args.getOpt("location");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileAttributesAvailable() {
            try {
                if (this._fileAttributes.getFileType() != FileType.REGULAR) {
                    this.sendReply("storageInfoAvailable", 10014, "path is not a regular file", "EINVAL");
                    return;
                }
                DCapProtocolInfo protocolInfo = new DCapProtocolInfo("DCap", 3, 0, this._destination, 0);
                PinManagerPinMessage message = new PinManagerPinMessage(this._fileAttributes, (ProtocolInfo)protocolInfo, null, 0L);
                DCapDoorInterpreterV3.this._pinManagerStub.send((Serializable)message);
                this.sendReply("storageInfoAvailable", 0, "");
            }
            catch (NoRouteToCellException e) {
                this.sendReply("storageInfoAvailable", 2, "Staging service is offline");
            }
            finally {
                this.removeUs();
            }
        }

        @Override
        public String toString() {
            return "st " + super.toString();
        }
    }

    protected abstract class PnfsSessionHandler
    extends SessionHandler {
        protected String _path;
        protected FileAttributes _fileAttributes;
        private long _timer;
        private final Object _timerLock;
        private long _timeout;
        protected Set<FileAttribute> _attributes;
        protected PnfsGetFileAttributes _message;
        protected PnfsHandler _pnfs;

        protected PnfsSessionHandler(int sessionId, int commandId, VspArgs args, boolean metaDataOnly, boolean resolvePath) throws CacheException, CommandException {
            String tmp;
            super(sessionId, commandId, args);
            this._path = null;
            this._timer = 0L;
            this._timerLock = new Object();
            this._timeout = 0L;
            this._attributes = FileMetaData.getKnownFileAttributes();
            this._attributes.add(FileAttribute.PNFSID);
            this._attributes.add(FileAttribute.TYPE);
            if (!metaDataOnly) {
                this._attributes.add(FileAttribute.STORAGEINFO);
            }
            if ((tmp = args.getOpt("timeout")) != null) {
                try {
                    long timeout = Long.parseLong(tmp);
                    if (timeout > 0L) {
                        _log.info("PnfsSessionHandler: user timeout set to {}", (Object)timeout);
                        this._timeout = System.currentTimeMillis() + timeout * 1000L;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void doLogin() throws CacheException {
            super.doLogin();
            this._pnfs = new PnfsHandler(DCapDoorInterpreterV3.this._cell, new CellPath(DCapDoorInterpreterV3.this._pnfsManagerName));
            this._pnfs.setSubject(this._subject);
        }

        @Override
        protected void doStart() throws CacheException {
            try {
                this.askForFileAttributes();
            }
            catch (NoRouteToCellException e) {
                throw new CacheException(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keepAlive() {
            Object object = this._timerLock;
            synchronized (object) {
                if (this._timeout > 0L && this._timeout < System.currentTimeMillis()) {
                    _log.warn("User timeout triggered");
                    this.sendReply("keepAlive", 112, "User timeout canceled session");
                    this.removeUs();
                    return;
                }
                if (this._timer > 0L && this._timer < System.currentTimeMillis()) {
                    this._timer = 0L;
                    _log.warn("Restarting session {}", (Object)this._sessionId);
                    try {
                        this.again(true);
                    }
                    catch (Exception e) {
                        this.sendReply("keepAlive", 111, e.getMessage());
                        this.removeUs();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setTimer(long timeout) {
            Object object = this._timerLock;
            synchronized (object) {
                this._timer = timeout == 0L ? 0L : System.currentTimeMillis() + timeout;
            }
        }

        public void again(boolean strong) throws IllegalArgumentException, NoRouteToCellException {
            this.askForFileAttributes();
        }

        protected void askForFileAttributes() throws IllegalArgumentException, NoRouteToCellException {
            this.setTimer(60000L);
            String fileIdentifier = this._vargs.argv(0);
            if (PnfsId.isValid((String)fileIdentifier)) {
                PnfsId pnfsId = new PnfsId(fileIdentifier);
                this._message = new PnfsGetFileAttributes(pnfsId, this._attributes);
            } else {
                DCapUrl url = new DCapUrl(fileIdentifier);
                String fileName = url.getFilePart();
                this._message = new PnfsGetFileAttributes(fileName, this._attributes);
                this._path = fileName;
            }
            _log.debug("Requesting file attributes for {}", (Object)this._message);
            this._message.setId((long)this._sessionId);
            this._message.setReplyRequired(true);
            if (this._path == null) {
                this._path = this._vargs.getOpt("path");
            }
            if (this._path != null) {
                this._info.setPath(this._path);
            }
            this._pnfs.send((PnfsMessage)this._message);
            this.setStatus("WaitingForPnfs");
        }

        public void pnfsGetFileAttributesArrived(PnfsGetFileAttributes reply) {
            this.setTimer(0L);
            this._message = reply;
            _log.debug("pnfsGetFileAttributesArrived: {}", (Object)this._message);
            if (this._message.getReturnCode() != 0) {
                try {
                    if (!this.fileAttributesNotAvailable()) {
                        this.removeUs();
                        return;
                    }
                }
                catch (CacheException e) {
                    this.sendReply("pnfsGetFileAttributesArrived", e.getRc(), e.getMessage());
                    this.removeUs();
                    return;
                }
            }
            this._fileAttributes = this._message.getFileAttributes();
            this._info.setPnfsId(this._fileAttributes.getPnfsId());
            if (this._fileAttributes.isDefined(FileAttribute.STORAGEINFO)) {
                StorageInfo storageInfo = this._fileAttributes.getStorageInfo();
                for (int i = 0; i < this._vargs.optc(); ++i) {
                    String key;
                    String value = this._vargs.getOpt(key = this._vargs.optv(i));
                    storageInfo.setKey(key, value == null ? "" : value);
                }
            }
            this.fileAttributesAvailable();
        }

        protected abstract void fileAttributesAvailable();

        protected boolean fileAttributesNotAvailable() throws CacheException {
            this.sendReply("fileAttributesNotAvailable", (Message)this._message);
            return false;
        }

        @Override
        public String toString() {
            return "[" + (this._fileAttributes == null ? "null" : this._fileAttributes.getPnfsId()) + "]" + " {timer=" + (this._timer == 0L ? "off" : "" + (this._timer - System.currentTimeMillis())) + "} " + super.toString();
        }
    }

    protected class SessionHandler {
        protected VspArgs _vargs = null;
        protected int _sessionId = 0;
        protected int _commandId = 0;
        protected boolean _verbose = false;
        protected long _started = System.currentTimeMillis();
        protected DoorRequestInfoMessage _info = null;
        protected String _status = "<init>";
        protected long _statusSince = System.currentTimeMillis();
        protected String _ioHandlerQueue = null;
        private final long _timestamp = System.currentTimeMillis();
        protected Subject _subject;
        protected Origin _origin;
        protected boolean _readOnly;

        protected SessionHandler(int sessionId, int commandId, VspArgs args) throws CommandException {
            this._sessionId = sessionId;
            this._commandId = commandId;
            this._vargs = args;
            this._info = new DoorRequestInfoMessage(DCapDoorInterpreterV3.this._cell.getCellInfo().getCellName() + "@" + DCapDoorInterpreterV3.this._cell.getCellInfo().getDomainName());
            this._ioHandlerQueue = args.getOpt("io-queue");
            this._ioHandlerQueue = this._ioHandlerQueue == null || this._ioHandlerQueue.length() == 0 ? null : this._ioHandlerQueue;
        }

        protected void doLogin() throws CacheException {
            LoginReply login = DCapDoorInterpreterV3.this.login(this._vargs.getOpt("role"));
            this._subject = login.getSubject();
            this._origin = Subjects.getOrigin((Subject)this._subject);
            this._readOnly = DCapDoorInterpreterV3.this._args.hasOption("readOnly");
            for (LoginAttribute attribute : login.getLoginAttributes()) {
                if (!(attribute instanceof ReadOnly)) continue;
                this._readOnly |= ((ReadOnly)attribute).isReadOnly();
            }
            this._info.setSubject(this._subject);
        }

        protected void doStart() throws CacheException, CommandException {
        }

        public final void start() throws CommandException {
            boolean isStarted = false;
            this.addUs();
            try {
                this.doLogin();
                this.doStart();
                isStarted = true;
            }
            catch (CacheException e) {
                throw new CommandException(e.getRc(), e.getMessage());
            }
            finally {
                if (!isStarted) {
                    this.removeUs();
                }
            }
        }

        protected void sendComment(String comment) {
            String reply = "" + this._sessionId + " 1 " + this._vargs.getName() + " " + comment;
            DCapDoorInterpreterV3.this.println(reply);
            _log.debug(reply);
        }

        public void keepAlive() {
            _log.debug("Keep alived called for : {}", (Object)this);
        }

        protected void sendReply(String tag, int rc, String msg) {
            this.sendReply(tag, rc, msg, "");
        }

        protected void sendReply(String tag, int rc, String msg, String posixErr) {
            String problem;
            this._info.setTransactionDuration(System.currentTimeMillis() - this._timestamp);
            if (rc == 0) {
                problem = String.format("%d %d %s ok", this._sessionId, this._commandId, this._vargs.getName());
            } else {
                problem = String.format("%d %d %s failed %d \"%s\" %s", this._sessionId, this._commandId, this._vargs.getName(), rc, msg, posixErr);
                this._info.setResult(rc, msg);
            }
            _log.debug("{}: {}", (Object)tag, (Object)problem);
            DCapDoorInterpreterV3.this.println(problem);
            DCapDoorInterpreterV3.this.postToBilling(this._info);
        }

        protected void sendReply(String tag, Message msg) {
            this.sendReply(tag, msg.getReturnCode(), msg.getErrorObject().toString());
        }

        protected void addUs() throws CommandException {
            if (DCapDoorInterpreterV3.this._sessions.putIfAbsent(this._sessionId, this) != null) {
                throw new CommandException(5, "Duplicated session id");
            }
        }

        protected void removeUs() {
            DCapDoorInterpreterV3.this._sessions.remove(this._sessionId);
        }

        protected void setStatus(String status) {
            this._status = status;
            this._statusSince = System.currentTimeMillis();
        }

        public String toString() {
            return "[" + this._sessionId + "][" + this.getUid() + "][" + DCapDoorInterpreterV3.this._pid + "] " + this._status + "(" + (System.currentTimeMillis() - this._statusSince) / 1000L + ")";
        }

        protected int getUid() {
            if (!Subjects.isNobody((Subject)this._subject)) {
                return (int)Subjects.getUid((Subject)this._subject);
            }
            String s = this._vargs.getOpt("uid");
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    _log.warn("Failed to parse UID: {}", (Object)s);
                }
            }
            return DCapDoorInterpreterV3.this._uid;
        }

        protected int getGid() {
            if (!Subjects.isNobody((Subject)this._subject)) {
                return (int)Subjects.getPrimaryGid((Subject)this._subject);
            }
            String s = this._vargs.getOpt("gid");
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    _log.warn("Failed to parse GID: {}", (Object)s);
                }
            }
            return DCapDoorInterpreterV3.this._gid;
        }

        protected int getMode(int mode) {
            String s = this._vargs.getOpt("mode");
            if (s != null) {
                try {
                    mode = Integer.decode(s);
                }
                catch (NumberFormatException e) {
                    _log.warn("Failed to parse mode: {}", (Object)s);
                }
            }
            return mode;
        }
    }

    private static class Version
    implements Comparable<Version> {
        private final int _major;
        private final int _minor;

        private Version(String versionString) {
            StringTokenizer st = new StringTokenizer(versionString, ".");
            this._major = Integer.parseInt(st.nextToken());
            this._minor = Integer.parseInt(st.nextToken());
        }

        @Override
        public int compareTo(Version other) {
            return this._major < other._major ? -1 : (this._major > other._major ? 1 : (this._minor < other._minor ? -1 : (this._minor > other._minor ? 1 : 0)));
        }

        public String toString() {
            return "" + this._major + "." + this._minor;
        }

        private Version(int major, int minor) {
            this._major = major;
            this._minor = minor;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Version)) {
                return false;
            }
            return ((Version)obj)._major == this._major && ((Version)obj)._minor == this._minor;
        }

        public int hashCode() {
            return this._minor ^ this._major;
        }
    }

    private static enum DcapCommand {
        HELLO("hello"),
        BYEBYE("byebye"),
        OPEN("open"),
        CHECK("check"),
        CHGRP("chgrp"),
        CHOWN("chown"),
        CHMOD("chmod"),
        LSTAT("lstat"),
        MKDIR("mkdir"),
        OPENDIR("opendir"),
        PING("ping"),
        RENAME("rename"),
        RMDIR("rmdir"),
        STAGE("stage"),
        STAT("stat"),
        STATUS("status"),
        UNLINK("unlink");

        private static final long serialVersionUID = 8393273905860276227L;
        private final String _value;
        private static final Map<String, DcapCommand> _commands;

        private DcapCommand(String value) {
            this._value = value;
        }

        String getCommand() {
            return this._value;
        }

        static DcapCommand get(String s) {
            DcapCommand command = _commands.get(s);
            if (command == null) {
                throw new IllegalArgumentException("Unsupported command: " + s);
            }
            return command;
        }

        static {
            _commands = new HashMap<String, DcapCommand>();
            for (DcapCommand command : DcapCommand.values()) {
                _commands.put(command.getCommand(), command);
            }
        }
    }
}

