/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.DCapDoorInterpreterV3;
import diskCacheV111.doors.DcapProtocolInterpreter;
import diskCacheV111.util.Version;
import diskCacheV111.util.VspArgs;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellVersion;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.KeepAliveListener;
import dmg.util.StreamEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCapDoor
extends CellAdapter
implements Runnable,
KeepAliveListener {
    private static final Logger _log = LoggerFactory.getLogger(DCapDoor.class);
    private StreamEngine _engine;
    private BufferedReader _in;
    private PrintWriter _out;
    private String _host;
    private Subject _subject;
    private Thread _workerThread;
    private Thread _anyThread;
    private int _commandCounter = 0;
    private String _lastCommand = "<init>";
    private Reader _reader = null;
    private CellNucleus _nucleus = this.getNucleus();
    private boolean _dcapLock = true;
    private final DcapProtocolInterpreter _interpreter;
    private static final int __connectionLostEvent = 1;
    private static final int __weWereKilledEvent = 2;
    private static final int __abortCacheFinishedEvent = 3;
    private static final int __NormalOperation = 1;
    private static final int __AbortCacheProtOnBye = 2;
    private static final int __WeAreFinished = 3;
    private static final int __AbortCacheProtOnKill = 4;
    private boolean _connectionLost = false;
    private boolean _abortCacheFinished = false;
    private int _state = 1;

    public DCapDoor(String name, StreamEngine engine, Args args) throws Exception {
        super(name, DCapDoor.class.getName(), args, false);
        try {
            this._engine = engine;
            this._reader = engine.getReader();
            this._in = new BufferedReader(this._reader);
            this._out = new PrintWriter(engine.getWriter());
            this._subject = engine.getSubject();
            this._host = engine.getInetAddress().toString();
            this._interpreter = new DCapDoorInterpreterV3((CellEndpoint)this, this._out, this._subject, engine.getInetAddress());
            this.addCommandListener(this._interpreter);
        }
        catch (Exception ee) {
            this.start();
            this.kill();
            throw ee;
        }
        this._workerThread = this._nucleus.newThread((Runnable)this, "worker");
        this._workerThread.start();
        this.start();
    }

    public static CellVersion getStaticCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 1.17 $");
    }

    public CellVersion getCellVersion() {
        return DCapDoor.getStaticCellVersion();
    }

    public void keepAlive() {
        if (this._interpreter instanceof KeepAliveListener) {
            ((KeepAliveListener)this._interpreter).keepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this._workerThread) {
            block19: {
                _log.info("Checking DCap lock");
                try {
                    String lock;
                    while ((lock = (String)this._nucleus.getDomainContext().get("dcapLock")) != null) {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                }
                catch (InterruptedException iee) {
                    _log.info("Interrupted the 'dcap' lock");
                    _log.info("ComThread : Client communication Thread finished");
                    this._stateChanged(1);
                    return;
                }
                _log.info("DCapLock released");
                this._dcapLock = false;
                try {
                    while (true) {
                        VspArgs args;
                        if ((this._lastCommand = this._in.readLine()) == null) {
                            break block19;
                        }
                        if (this._lastCommand.length() == 0) continue;
                        ++this._commandCounter;
                        _log.info("Executing command: " + this._lastCommand);
                        try {
                            args = new VspArgs(this._lastCommand);
                        }
                        catch (IllegalArgumentException e) {
                            this.println("protocol violation: " + e.getMessage());
                            _log.warn("protocol violation [" + e.getMessage() + "]from " + this._engine.getInetAddress());
                            break block19;
                        }
                        if (this.execute(args) > 0) break;
                    }
                    this.println("0 0 server byebye");
                    _log.info("ComThread : protocol ended");
                }
                catch (IOException e) {
                    _log.warn("Got IO exception " + e.toString() + " from: " + this._engine.getInetAddress());
                }
                catch (Exception e) {
                    _log.warn("ComThread : got " + e, (Throwable)e);
                }
                finally {
                    this._out.close();
                }
            }
            _log.info("ComThread : Client communication Thread finished");
            this._stateChanged(1);
        } else if (Thread.currentThread() == this._anyThread) {
            try {
                _log.info("AnyThread : started");
                Thread.sleep(3600000L);
                _log.info("AnyThread : woke up");
            }
            catch (InterruptedException ie) {
                _log.info("AnyThread : was interrupted");
            }
            _log.info("AnyThread : finished");
        }
    }

    private void abortCacheProtocol() {
        _log.info("abortCacheProtocol : starting");
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException ie) {
            _log.info("abortCacheProtocol : interrupted ");
        }
        _log.info("abortCacheProtocol : finished");
    }

    private synchronized void _stateChanged(int event) {
        _log.info("_stateChanged : state = " + this._state + " ; event = " + event);
        switch (this._state) {
            case 1: {
                switch (event) {
                    case 1: {
                        this._state = 2;
                        this._nucleus.newThread(new Runnable(){

                            @Override
                            public void run() {
                                _log.info("Starting abortCacheProtocol");
                                DCapDoor.this.abortCacheProtocol();
                                DCapDoor.this._stateChanged(3);
                                _log.info("Finished abortCacheProtocol");
                            }
                        }, "finishCacheProtocol").start();
                        break;
                    }
                    case 2: {
                        this.println("0 0 server shutdown");
                        this._out.close();
                        this._state = 4;
                        this._nucleus.newThread(new Runnable(){

                            @Override
                            public void run() {
                                _log.info("Starting abortCacheProtocol");
                                DCapDoor.this.abortCacheProtocol();
                                _log.info("Finished abortCacheProtocol");
                                DCapDoor.this._stateChanged(3);
                            }
                        }, "finishCacheProtocol").start();
                    }
                }
                break;
            }
            case 2: {
                switch (event) {
                    case 3: {
                        this._state = 3;
                        this.kill();
                    }
                }
                break;
            }
            case 4: {
                switch (event) {
                    case 3: {
                        this._abortCacheFinished = true;
                        if (!this._connectionLost) break;
                        this._state = 3;
                        break;
                    }
                    case 1: {
                        this._connectionLost = true;
                        if (!this._abortCacheFinished) break;
                        this._state = 3;
                    }
                }
                break;
            }
            case 3: {
                switch (event) {
                    case 2: {
                        _log.info("Done");
                    }
                }
            }
        }
        _log.info("_stateChanged :  new state = " + this._state);
        this.notifyAll();
    }

    private synchronized void waitForFinish(long timeout) throws InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        while (this._state != 3) {
            long rest = end - System.currentTimeMillis();
            _log.info("waitForFinish : waiting for " + rest + " seconds");
            if (rest <= 0L) break;
            this.wait(rest);
        }
    }

    public void cleanUp() {
        _log.info("CleanUp : starting");
        this._stateChanged(2);
        try {
            _log.info("CleanUp : waiting for final gate");
            this.waitForFinish(2000L);
        }
        catch (InterruptedException ie) {
            _log.info("CleanUp : PANIC : interrupted (system left in an undefined state)");
        }
        if (this._state != 3) {
            _log.info("CleanUp : PANIC : timeout (system left in an undefined state)");
        }
        _log.info("CleanUp : finished");
        this._interpreter.close();
        this._out.close();
        try {
            if (!this._engine.getSocket().isClosed()) {
                _log.info("Close socket");
                this._engine.getSocket().close();
            }
        }
        catch (IOException e) {
            _log.warn("DcapDoor: got I/O exception closing socket:" + e.getMessage());
        }
    }

    private synchronized void println(String str) {
        _log.info("toclient(println) : " + str);
        this._out.println(str);
        this._out.flush();
    }

    private int execute(VspArgs args) throws Exception {
        try {
            String answer = this._interpreter.execute(args);
            if (answer != null) {
                _log.info("Our answer : " + answer);
                this.println(answer);
            }
        }
        catch (CommandExitException e) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Subjects.getDisplayName((Subject)this._subject) + "@" + this._host + (this._dcapLock ? " (LOCKED)" : "");
    }

    public void getInfo(PrintWriter pw) {
        pw.println("            DCapDoor" + (this._dcapLock ? " (LOCKED)" : ""));
        pw.println("         User  : " + Subjects.getDisplayName((Subject)this._subject));
        pw.println("         Host  : " + this._host);
        pw.println(" Last Command  : " + this._lastCommand);
        pw.println(" Command Count : " + this._commandCounter);
        this._interpreter.getInfo(pw);
    }

    public void messageArrived(CellMessage msg) {
        this._interpreter.messageArrived(msg);
    }
}

