/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.store;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import org.dcache.chimera.FsInode;

public class InodeStorageInformation {
    private final FsInode _inode;
    private final String _hsmName;
    private final String _storageGroup;
    private final String _storageSubGroup;
    private final AccessLatency _accessLatency;
    private final RetentionPolicy _retentionPolicy;

    public InodeStorageInformation(FsInode inode, String hsm, String sGroup, String ssGroup) {
        this(inode, hsm, sGroup, ssGroup, AccessLatency.NEARLINE, RetentionPolicy.CUSTODIAL);
    }

    public InodeStorageInformation(FsInode inode, String hsm, String sGroup, String ssGroup, AccessLatency al, RetentionPolicy rp) {
        if (inode == null) {
            throw new IllegalArgumentException("inode is null");
        }
        if (hsm == null) {
            throw new IllegalArgumentException("HSM is not defined");
        }
        if (sGroup == null) {
            throw new IllegalArgumentException("Storage Group is not defined");
        }
        if (ssGroup == null) {
            throw new IllegalArgumentException("Storage Sub Group is not defined");
        }
        this._inode = inode;
        this._hsmName = hsm;
        this._storageGroup = sGroup;
        this._storageSubGroup = ssGroup;
        this._accessLatency = al;
        this._retentionPolicy = rp;
    }

    public FsInode inode() {
        return this._inode;
    }

    public AccessLatency accessLatency() {
        return this._accessLatency;
    }

    public String hsmName() {
        return this._hsmName;
    }

    public RetentionPolicy retentionPolicy() {
        return this._retentionPolicy;
    }

    public String storageGroup() {
        return this._storageGroup;
    }

    public String storageSubGroup() {
        return this._storageSubGroup;
    }
}

