/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.posix;

import java.util.Arrays;
import org.dcache.chimera.posix.User;

public class UnixUser
implements User {
    private final int _uid;
    private final int _gid;
    private final int[] _gids;
    private final String _remoteHost;

    public UnixUser(int uid) {
        this(uid, -1);
    }

    public UnixUser(int uid, int gid) {
        this(uid, gid, new int[0]);
    }

    public UnixUser(int uid, int gid, int[] gids) {
        this(uid, gid, gids, null);
    }

    public UnixUser(int uid, int gid, int[] gids, String remoteHost) {
        this._uid = uid;
        this._gid = gid;
        this._gids = gids == null ? new int[]{} : (int[])gids.clone();
        this._remoteHost = remoteHost;
    }

    public int getUID() {
        return this._uid;
    }

    public int getGID() {
        return this._gid;
    }

    public int[] getGIDS() {
        return (int[])this._gids.clone();
    }

    public String getHost() {
        return this._remoteHost;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uid = ").append(this._uid).append("; ");
        sb.append("Gid = ").append(this._gid).append("; ");
        if (this._gids.length != 0) {
            sb.append("Gids = " + Arrays.toString(this._gids));
        }
        sb.append("Remote Host = ").append(this._remoteHost).append(";");
        return sb.toString();
    }

    @Override
    public String principal() {
        return Integer.toString(this._uid);
    }

    @Override
    public String[] groups() {
        int ngroup = this._gids == null ? 1 : 1 + this._gids.length;
        String[] groups = new String[ngroup];
        groups[0] = Integer.toString(this._gid);
        for (int i = 1; i < ngroup; ++i) {
            groups[i] = Integer.toString(this._gids[i - 1]);
        }
        return groups;
    }

    @Override
    public String role() {
        return this.principal();
    }

    @Override
    public String locations() {
        return this.getHost();
    }
}

