/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_TAGS
extends FsInode {
    public FsInode_TAGS(FileSystemProvider fs, String id) {
        super(fs, id, FsInodeType.TAGS);
    }

    @Override
    public boolean exists() {
        return super.exists();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        int rc = 0;
        String[] list = null;
        try {
            list = this._fs.tags(this);
            for (int i = 0; i < list.length; ++i) {
                sb.append(".(tag)(").append(list[i]).append(")\n");
            }
            rc = sb.length();
            if (pos > (long)rc) {
                return 0;
            }
            byte[] tmp = sb.toString().getBytes();
            int copyLen = Math.min(len, tmp.length - (int)pos);
            System.arraycopy(tmp, 0, data, 0, copyLen);
            rc = copyLen;
        }
        catch (Exception e) {
            e.printStackTrace();
            rc = -1;
        }
        return rc;
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        long size = 0L;
        Stat stat = super.stat();
        stat.setNlink(1);
        stat.setMode(33060);
        try {
            String[] list = this._fs.tags(this);
            for (int i = 0; i < list.length; ++i) {
                size += (long)(9 + list[i].length());
            }
            stat.setSize(size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stat;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }
}

