/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import org.dcache.util.StringMarkup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlPathWrapper {
    private static final Logger _log = LoggerFactory.getLogger(UrlPathWrapper.class);
    private static final String SCHEME_FILE = "file";
    private static final int SCHEME_FILE_LENGTH = "file".length();
    private static final UrlPathWrapper EMPTY_PATH = new UrlPathWrapper("", "");
    private final String _path;
    private final String _encoded;

    public static UrlPathWrapper forEmptyPath() {
        return EMPTY_PATH;
    }

    public static UrlPathWrapper[] forPaths(String[] pathElements) {
        UrlPathWrapper[] encoded = new UrlPathWrapper[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            encoded[i] = UrlPathWrapper.forPath(pathElements[i]);
        }
        return encoded;
    }

    public static UrlPathWrapper forPath(String path) {
        return new UrlPathWrapper(path, StringMarkup.percentEncode((String)path));
    }

    private UrlPathWrapper(String path, String encoded) {
        _log.debug("building string-pair '{}' and '{}'", (Object)path, (Object)encoded);
        this._path = path;
        this._encoded = encoded;
    }

    public String toString() {
        return this._path;
    }

    public String getUnencoded() {
        return this._path;
    }

    public String getEncoded() {
        return this._encoded;
    }
}

