/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ServletRequest;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Origin;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.webdav.EmptyResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private final Logger _log = LoggerFactory.getLogger(SecurityFilter.class);
    private static final String X509_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private String _realm;
    private boolean _isReadOnly;
    private boolean _isBasicAuthenticationEnabled;
    private LoginStrategy _loginStrategy;

    public void process(final FilterChain filterChain, final Request request, final Response response) {
        HttpManager manager = filterChain.getHttpManager();
        Subject subject = new Subject();
        if (!this.isAllowedMethod(request.getMethod())) {
            manager.getResponseHandler().respondMethodNotAllowed((Resource)new EmptyResource(request), response, request);
            return;
        }
        try {
            HttpServletRequest servletRequest = ServletRequest.getRequest();
            this.addX509ChainToSubject(servletRequest, subject);
            this.addOriginToSubject(servletRequest, subject);
            this.addPasswordCredentialToSubject(request, subject);
            LoginReply login = this._loginStrategy.login(subject);
            subject = login.getSubject();
            if (!this.isAuthorizedMethod(request.getMethod(), login)) {
                throw new PermissionDeniedCacheException("Permission denied");
            }
            this.addOriginToSubject(servletRequest, subject);
            Auth auth = request.getAuthorization();
            if (auth != null) {
                auth.setTag((Object)subject);
            }
            Subject.doAs(subject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    filterChain.process(request, response);
                    return null;
                }
            });
        }
        catch (PermissionDeniedCacheException e) {
            this._log.warn("Login failed for " + subject);
            manager.getResponseHandler().respondUnauthorised((Resource)new EmptyResource(request), response, request);
        }
        catch (CacheException e) {
            this._log.error("Internal server error: " + (Object)((Object)e));
            manager.getResponseHandler().respondServerError(request, response, e.getMessage());
        }
    }

    private void addX509ChainToSubject(HttpServletRequest request, Subject subject) {
        Object object = request.getAttribute(X509_CERTIFICATE_ATTRIBUTE);
        if (object instanceof X509Certificate[]) {
            X509Certificate[] chain = (X509Certificate[])object;
            subject.getPublicCredentials().add(chain);
        }
    }

    private void addOriginToSubject(HttpServletRequest request, Subject subject) {
        String address = request.getRemoteAddr();
        try {
            Origin origin = new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_STRONG, InetAddress.getByName(address));
            subject.getPrincipals().add((Principal)origin);
        }
        catch (UnknownHostException e) {
            this._log.warn("Failed to resolve " + address + ": " + e.getMessage());
        }
    }

    private void addPasswordCredentialToSubject(Request request, Subject subject) {
        Auth auth = request.getAuthorization();
        if (auth != null && auth.getScheme().equals((Object)Auth.Scheme.BASIC) && this._isBasicAuthenticationEnabled) {
            PasswordCredential credential = new PasswordCredential(auth.getUser(), auth.getPassword());
            subject.getPrivateCredentials().add(credential);
        }
    }

    private boolean isAllowedMethod(Request.Method method) {
        return !this._isReadOnly || this.isReadMethod(method);
    }

    private boolean isAuthorizedMethod(Request.Method method, LoginReply login) {
        return !this.isUserReadOnly(login) || this.isReadMethod(method);
    }

    private boolean isUserReadOnly(LoginReply login) {
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (!(attribute instanceof ReadOnly)) continue;
            return ((ReadOnly)attribute).isReadOnly();
        }
        return false;
    }

    private boolean isReadMethod(Request.Method method) {
        switch (method) {
            case GET: 
            case HEAD: 
            case OPTIONS: 
            case PROPFIND: {
                return true;
            }
        }
        return false;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public void setEnableBasicAuthentication(boolean isEnabled) {
        this._isBasicAuthenticationEnabled = isEnabled;
    }

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }
}

