/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import org.dcache.webdav.EmptyResource;
import org.dcache.webdav.ForbiddenException;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.WebDavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcacheStandardFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DcacheStandardFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FilterChain chain, Request request, Response response) {
        HttpManager manager = chain.getHttpManager();
        Http11ResponseHandler responseHandler = manager.getResponseHandler();
        try {
            Request.Method method = request.getMethod();
            Handler handler = manager.getMethodHandler(method);
            if (handler == null) {
                responseHandler.respondMethodNotImplemented((Resource)new EmptyResource(request), response, request);
                return;
            }
            try {
                handler.process(manager, request, response);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof WebDavException) {
                    throw (WebDavException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw e;
            }
        }
        catch (BadRequestException e) {
            responseHandler.respondBadRequest(e.getResource(), response, request);
        }
        catch (ConflictException e) {
            responseHandler.respondConflict(e.getResource(), response, request, e.getMessage());
        }
        catch (NotAuthorizedException e) {
            responseHandler.respondUnauthorised(e.getResource(), response, request);
        }
        catch (UnauthorizedException e) {
            responseHandler.respondUnauthorised(e.getResource(), response, request);
        }
        catch (ForbiddenException e) {
            responseHandler.respondForbidden(e.getResource(), response, request);
        }
        catch (NotFoundException e) {
            responseHandler.respondNotFound(response, request);
        }
        catch (WebDavException e) {
            log.warn("Internal server error: " + e);
            responseHandler.respondServerError(request, response, e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Internal server error", (Throwable)e);
            responseHandler.respondServerError(request, response, e.getMessage());
        }
        finally {
            response.close();
        }
    }
}

