/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.http11.DefaultHttp11ResponseHandler;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.values.ValueWriters;
import com.bradmcevoy.http.webdav.DefaultWebDavResponseHandler;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.PropFindXmlGenerator;
import com.bradmcevoy.http.webdav.ResourceTypeHelper;
import com.bradmcevoy.http.webdav.WebDavResourceTypeHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.dcache.webdav.UrlPathWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcacheResponseHandler
extends DefaultWebDavResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(DcacheResponseHandler.class);
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final ImmutableMap<Response.Status, String> ERRORS = ImmutableMap.builder().put((Object)Response.Status.SC_INTERNAL_SERVER_ERROR, (Object)"INTERNAL SERVER ERROR").put((Object)Response.Status.SC_FORBIDDEN, (Object)"PERMISSION DENIED").put((Object)Response.Status.SC_BAD_REQUEST, (Object)"BAD REQUEST").put((Object)Response.Status.SC_NOT_IMPLEMENTED, (Object)"NOT IMPLEMENTED").put((Object)Response.Status.SC_CONFLICT, (Object)"CONFLICT").put((Object)Response.Status.SC_UNAUTHORIZED, (Object)"UNAUTHORIZED").put((Object)Response.Status.SC_METHOD_NOT_ALLOWED, (Object)"METHOD NOT ALLOWED").put((Object)Response.Status.SC_NOT_FOUND, (Object)"FILE NOT FOUND").build();
    private final AuthenticationService _authenticationService;
    private String _staticContentPath;
    private StringTemplateGroup _templateGroup;

    public DcacheResponseHandler(AuthenticationService authenticationService) {
        super((com.bradmcevoy.http.http11.Http11ResponseHandler)new Http11ResponseHandler(authenticationService), (ResourceTypeHelper)new WebDavResourceTypeHelper(), new PropFindXmlGenerator(new ValueWriters()));
        this._authenticationService = authenticationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateResource(org.springframework.core.io.Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            this._templateGroup = new StringTemplateGroup((Reader)new InputStreamReader(in), DefaultTemplateLexer.class);
        }
        finally {
            in.close();
        }
    }

    public String getStaticContentPath() {
        return this._staticContentPath;
    }

    public void setStaticContentPath(String path) {
        this._staticContentPath = path;
    }

    public void respondNotFound(Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_NOT_FOUND);
    }

    public void respondUnauthorised(Resource resource, Response response, Request request) {
        List challenges = this._authenticationService.getChallenges(resource, request);
        response.setAuthenticateHeader(challenges);
        this.errorResponse(request, response, Response.Status.SC_UNAUTHORIZED);
    }

    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_NOT_IMPLEMENTED);
    }

    public void respondMethodNotAllowed(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_METHOD_NOT_ALLOWED);
    }

    public void respondServerError(Request request, Response response, String reason) {
        this.errorResponse(request, response, Response.Status.SC_INTERNAL_SERVER_ERROR);
    }

    public void respondConflict(Resource resource, Response response, Request request, String reason) {
        this.errorResponse(request, response, Response.Status.SC_CONFLICT);
    }

    public void respondForbidden(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_FORBIDDEN);
    }

    private void errorResponse(Request request, Response response, Response.Status status) {
        try {
            String decodedPath = URI.create(request.getAbsoluteUrl()).getPath();
            String error = this.generateErrorPage(decodedPath, status);
            response.setStatus(status);
            response.setContentTypeHeader("text/html");
            OutputStream out = response.getOutputStream();
            out.write(error.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    public String generateErrorPage(String path, Response.Status status) {
        String[] base = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)path), String.class);
        StringTemplate template = this._templateGroup.getInstanceOf("errorpage");
        template.setAttribute("path", (Object)UrlPathWrapper.forPaths(base));
        template.setAttribute("base", (Object)UrlPathWrapper.forEmptyPath());
        template.setAttribute("static", (Object)this._staticContentPath);
        template.setAttribute("errorcode", (Object)status.toString());
        template.setAttribute("errormessage", this.ERRORS.get((Object)status));
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            template.setAttribute("subject", (Object)subject.getPrincipals().toString());
        }
        return template.toString();
    }

    public void respondPropFind(List<PropFindResponse> propFindResponses, Response response, Request request, Resource r) {
        for (PropFindResponse propFindResponse : propFindResponses) {
            Map errors = propFindResponse.getErrorProperties();
            List unknownProperties = (List)errors.get(Response.Status.SC_NOT_FOUND);
            if (unknownProperties == null) {
                unknownProperties = Lists.newArrayList();
                errors.put(Response.Status.SC_NOT_FOUND, unknownProperties);
            }
            Iterator iterator = propFindResponse.getKnownProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((ValueAndType)entry.getValue()).getValue() != null) continue;
                unknownProperties.add(new PropFindResponse.NameAndError((QName)entry.getKey(), null));
                iterator.remove();
            }
        }
        super.respondPropFind(propFindResponses, response, request, r);
    }

    protected static class Http11ResponseHandler
    extends DefaultHttp11ResponseHandler {
        public Http11ResponseHandler(AuthenticationService authenticationService) {
            super(authenticationService);
        }

        public void respondHead(Resource resource, Response response, Request request) {
            this.setRespondContentCommonHeaders(response, resource, request.getAuthorization());
            if (resource instanceof GetableResource) {
                String acc;
                String ct;
                GetableResource gr = (GetableResource)resource;
                Long contentLength = gr.getContentLength();
                if (contentLength != null) {
                    response.setContentLengthHeader(contentLength);
                }
                if ((ct = gr.getContentType(acc = request.getAcceptHeader())) != null) {
                    response.setContentTypeHeader(ct);
                }
            }
        }
    }
}

