/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ranges;
import com.google.common.collect.SetMultimap;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.GFtpProtocolInfo;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.dcache.auth.Origin;
import org.dcache.auth.SubjectWrapper;
import org.dcache.auth.Subjects;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.PingMoversTask;
import org.dcache.util.RedirectedTransfer;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicies;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.ListDirectoryHandler;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheDirectoryResource;
import org.dcache.webdav.DcacheFileResource;
import org.dcache.webdav.DcacheResource;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.UrlPathWrapper;
import org.dcache.webdav.WebDavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcacheResourceFactory
extends AbstractCellComponent
implements ResourceFactory,
CellMessageReceiver,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(DcacheResourceFactory.class);
    private static final Set<FileAttribute> REQUIRED_ATTRIBUTES = EnumSet.of(FileAttribute.TYPE, new FileAttribute[]{FileAttribute.PNFSID, FileAttribute.CREATION_TIME, FileAttribute.MODIFICATION_TIME, FileAttribute.SIZE, FileAttribute.MODE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP});
    private static final String PROTOCOL_INFO_NAME = "Http";
    private static final int PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int PROTOCOL_INFO_MINOR_VERSION = 1;
    private static final int PROTOCOL_INFO_UNKNOWN_PORT = 0;
    private static final String RELAY_PROTOCOL_INFO_NAME = "GFtp";
    private static final int RELAY_PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int RELAY_PROTOCOL_INFO_MINOR_VERSION = 0;
    private static final int RELAY_PROTOCOL_INFO_STREAMS = 1;
    private static final int RELAY_PROTOCOL_INFO_BUFFERSIZE = 0;
    private static final int RELAY_PROTOCOL_INFO_OFFSET = 0;
    private static final int RELAY_PROTOCOL_INFO_SIZE = 0;
    private static final long PING_DELAY = 300000L;
    private final SetMultimap<PnfsId, HttpTransfer> _redirects = Multimaps.synchronizedSetMultimap((SetMultimap)LinkedHashMultimap.create());
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final Map<Long, Transfer> _transfers = new ConcurrentHashMap<Long, Transfer>();
    private ListDirectoryHandler _list;
    private ScheduledExecutorService _executor;
    private int _moverTimeout = 180000;
    private long _killTimeout = 1500L;
    private long _transferConfirmationTimeout = 60000L;
    private int _bufferSize = 65536;
    private CellStub _poolStub;
    private CellStub _poolManagerStub;
    private CellStub _billingStub;
    private PnfsHandler _pnfs;
    private String _ioQueue;
    private String _cellName;
    private String _domainName;
    private FsPath _rootPath = new FsPath();
    private List<FsPath> _allowedPaths = Collections.singletonList(new FsPath());
    private InetAddress _internalAddress;
    private String _path;
    private boolean _doRedirectOnRead = true;
    private boolean _isOverwriteAllowed = false;
    private boolean _isAnonymousListingAllowed;
    private String _staticContentPath;
    private StringTemplateGroup _listingGroup;
    private TransferRetryPolicy _retryPolicy = TransferRetryPolicies.tryOncePolicy((long)this._moverTimeout);
    public static final String hh_get_children = "[-binary]";
    public static final String hh_get_door_info = "[-binary]";

    public DcacheResourceFactory() throws UnknownHostException {
        this._internalAddress = InetAddress.getLocalHost();
    }

    public long getKillTimeout() {
        return this._killTimeout;
    }

    public void setKillTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this._killTimeout = timeout;
    }

    public int getMoverTimeout() {
        return this._moverTimeout;
    }

    public void setMoverTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this._moverTimeout = timeout;
        this._retryPolicy = TransferRetryPolicies.tryOncePolicy((long)this._moverTimeout);
    }

    public long getTransferConfirmationTimeout() {
        return this._transferConfirmationTimeout;
    }

    public void setTransferConfirmationTimeout(long timeout) {
        this._transferConfirmationTimeout = timeout;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public String getRootPath() {
        return this._rootPath.toString();
    }

    public void setRootPath(String path) {
        this._rootPath = new FsPath(path);
    }

    public void setAllowedPaths(String s) {
        ArrayList<FsPath> list = new ArrayList<FsPath>();
        for (String path : s.split(":")) {
            list.add(new FsPath(path));
        }
        this._allowedPaths = list;
    }

    public String getAllowedPaths() {
        StringBuilder s = new StringBuilder();
        for (FsPath path : this._allowedPaths) {
            if (s.length() > 0) {
                s.append(':');
            }
            s.append(path);
        }
        return s.toString();
    }

    public String getIoQueue() {
        return this._ioQueue == null ? "" : this._ioQueue;
    }

    public void setIoQueue(String ioQueue) {
        this._ioQueue = ioQueue != null && !ioQueue.isEmpty() ? ioQueue : null;
    }

    public void setRedirectOnReadEnabled(boolean redirect) {
        this._doRedirectOnRead = redirect;
    }

    public boolean isRedirectOnReadEnabled() {
        return this._doRedirectOnRead;
    }

    public void setOverwriteAllowed(boolean allowed) {
        this._isOverwriteAllowed = allowed;
    }

    public boolean isOverwriteAllowed() {
        return this._isOverwriteAllowed;
    }

    public void setAnonymousListing(boolean isAllowed) {
        this._isAnonymousListingAllowed = isAllowed;
    }

    public boolean isAnonymousListing() {
        return this._isAnonymousListingAllowed;
    }

    public void setPnfsStub(CellStub stub) {
        this._pnfs = new PnfsHandler(stub);
    }

    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    public void setBillingStub(CellStub stub) {
        this._billingStub = stub;
    }

    public void setListHandler(ListDirectoryHandler list) {
        this._list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateResource(org.springframework.core.io.Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            this._listingGroup = new StringTemplateGroup((Reader)new InputStreamReader(in), DefaultTemplateLexer.class);
        }
        finally {
            in.close();
        }
    }

    public String getStaticContentPath() {
        return this._staticContentPath;
    }

    public void setStaticContentPath(String path) {
        this._staticContentPath = path;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
        this._executor.scheduleAtFixedRate((Runnable)new PingMoversTask(this._transfers.values()), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    public void setInternalAddress(String host) throws UnknownHostException {
        if (host != null && !host.isEmpty()) {
            InetAddress address = InetAddress.getByName(host);
            if (address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Wildcard address is not allowed: " + host);
            }
            this._internalAddress = address;
        } else {
            this._internalAddress = InetAddress.getLocalHost();
        }
    }

    public String getInternalAddress() {
        return this._internalAddress.getHostAddress();
    }

    public void init() {
        this._cellName = this.getCellName();
        this._domainName = this.getCellDomainName();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("Root path    : " + this.getRootPath());
        pw.println("Allowed paths: " + this.getAllowedPaths());
        pw.println("IO queue     : " + this.getIoQueue());
    }

    public Resource getResource(String host, String path) {
        if (_log.isDebugEnabled()) {
            _log.debug("Resolving " + HttpManager.request().getAbsoluteUrl());
        }
        return this.getResource(this.getFullPath(path));
    }

    public DcacheResource getResource(FsPath path) {
        if (!this.isAllowedPath(path)) {
            return null;
        }
        try {
            PnfsHandler pnfs = new PnfsHandler(this._pnfs, this.getSubject());
            FileAttributes attributes = pnfs.getFileAttributes(path.toString(), REQUIRED_ATTRIBUTES);
            return this.getResource(path, attributes);
        }
        catch (FileNotFoundCacheException e) {
            return null;
        }
        catch (PermissionDeniedCacheException e) {
            throw new UnauthorizedException(e.getMessage(), e, null);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, null);
        }
    }

    private DcacheResource getResource(FsPath path, FileAttributes attributes) {
        if (attributes.getFileType() == FileType.DIR) {
            return new DcacheDirectoryResource(this, path, attributes);
        }
        return new DcacheFileResource(this, path, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DcacheResource createFile(FsPath path, InputStream inputStream, Long length) throws CacheException, InterruptedException, IOException {
        Subject subject = this.getSubject();
        WriteTransfer transfer = new WriteTransfer(this._pnfs, subject, path);
        this._transfers.put(transfer.getSessionId(), (Transfer)transfer);
        try {
            boolean success = false;
            transfer.createNameSpaceEntry();
            try {
                PnfsId pnfsid = transfer.getPnfsId();
                transfer.setLength(length);
                transfer.openServerChannel();
                try {
                    transfer.selectPoolAndStartMover(this._ioQueue, this._retryPolicy);
                    transfer.relayData(inputStream);
                }
                finally {
                    transfer.killMover(this._killTimeout);
                    transfer.closeServerChannel();
                }
                transfer.notifyBilling(0, "");
                success = true;
            }
            finally {
                if (!success) {
                    transfer.deleteNameSpaceEntry();
                }
            }
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (IOException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            this._transfers.remove(transfer.getSessionId());
        }
        return this.getResource(path);
    }

    public void readFile(FsPath path, PnfsId pnfsid, OutputStream outputStream, Range range) throws CacheException, InterruptedException, IOException {
        ReadTransfer transfer = this.beginRead(path, pnfsid);
        try {
            transfer.relayData(outputStream, range);
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (IOException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            this._transfers.remove(transfer.getSessionId());
        }
    }

    public List<DcacheResource> list(final FsPath path) throws InterruptedException, CacheException {
        if (!this._isAnonymousListingAllowed && Subjects.isNobody((Subject)this.getSubject())) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        final ArrayList<DcacheResource> result = new ArrayList<DcacheResource>();
        DirectoryListPrinter printer = new DirectoryListPrinter(){

            public Set<FileAttribute> getRequiredAttributes() {
                return REQUIRED_ATTRIBUTES;
            }

            public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
                result.add(DcacheResourceFactory.this.getResource(new FsPath(path, entry.getName()), entry.getFileAttributes()));
            }
        };
        this._list.printDirectory(this.getSubject(), printer, path, null, Ranges.all());
        return result;
    }

    public void list(FsPath path, Writer out) throws InterruptedException, CacheException, IOException, URISyntaxException {
        if (!this._isAnonymousListingAllowed && Subjects.isNobody((Subject)this.getSubject())) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        Request request = HttpManager.request();
        String requestPath = new URI(request.getAbsoluteUrl()).getPath();
        String[] base = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)requestPath), String.class);
        final StringTemplate t = this._listingGroup.getInstanceOf("page");
        t.setAttribute("path", (Object)UrlPathWrapper.forPaths(base));
        t.setAttribute("static", (Object)this._staticContentPath);
        t.setAttribute("subject", (Object)new SubjectWrapper(this.getSubject()));
        t.setAttribute("base", (Object)UrlPathWrapper.forEmptyPath());
        DirectoryListPrinter printer = new DirectoryListPrinter(){

            public Set<FileAttribute> getRequiredAttributes() {
                return EnumSet.of(FileAttribute.MODIFICATION_TIME, FileAttribute.TYPE, FileAttribute.SIZE);
            }

            public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
                FileAttributes attr = entry.getFileAttributes();
                Date mtime = new Date(attr.getModificationTime());
                UrlPathWrapper name = UrlPathWrapper.forPath(entry.getName());
                t.setAttribute("files.{name,isDirectory,mtime,size}", (Object)name, (Object)(attr.getFileType() == FileType.DIR ? 1 : 0), (Object)mtime, (Object)attr.getSize());
            }
        };
        this._list.printDirectory(this.getSubject(), printer, path, null, Ranges.all());
        t.write((StringTemplateWriter)new AutoIndentWriter(out));
        out.flush();
    }

    public void deleteFile(PnfsId pnfsid, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, this.getSubject());
        pnfs.deletePnfsEntry(pnfsid, path.toString(), EnumSet.of(FileType.REGULAR, FileType.LINK));
        this.sendRemoveInfoToBilling(path);
    }

    private void sendRemoveInfoToBilling(FsPath path) {
        try {
            String cell = this.getCellName() + "@" + this.getCellDomainName();
            DoorRequestInfoMessage infoRemove = new DoorRequestInfoMessage(cell, "remove");
            Subject subject = this.getSubject();
            infoRemove.setSubject(subject);
            infoRemove.setPath(path.toString());
            infoRemove.setClient(Subjects.getOrigin((Subject)subject).getAddress().getHostAddress());
            this._billingStub.send((Serializable)infoRemove);
        }
        catch (NoRouteToCellException e) {
            _log.error("Cannot send remove message to billing: {}", (Object)e.getMessage());
        }
    }

    public void deleteDirectory(PnfsId pnfsid, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, this.getSubject());
        pnfs.deletePnfsEntry(pnfsid, path.toString(), EnumSet.of(FileType.DIR));
    }

    public DcacheDirectoryResource makeDirectory(FileAttributes parent, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, this.getSubject());
        PnfsCreateEntryMessage reply = pnfs.createPnfsDirectory(path.toString());
        FileAttributes attributes = pnfs.getFileAttributes(reply.getPnfsId(), REQUIRED_ATTRIBUTES);
        return new DcacheDirectoryResource(this, path, attributes);
    }

    public void move(PnfsId pnfsId, FsPath newPath) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, this.getSubject());
        pnfs.renameEntry(pnfsId, newPath.toString());
    }

    public String getReadUrl(FsPath path, PnfsId pnfsid) throws CacheException, InterruptedException {
        return (String)this.beginRead(path, pnfsid).getRedirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadTransfer beginRead(FsPath path, PnfsId pnfsid) throws CacheException, InterruptedException {
        Subject subject = this.getSubject();
        String uri = null;
        ReadTransfer transfer = new ReadTransfer(this._pnfs, subject, path, pnfsid);
        this._transfers.put(transfer.getSessionId(), (Transfer)transfer);
        try {
            transfer.readNameSpaceEntry();
            try {
                this._redirects.put((Object)pnfsid, (Object)transfer);
                transfer.selectPoolAndStartMover(this._ioQueue, this._retryPolicy);
                transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Waiting for URI");
                uri = (String)transfer.waitForRedirect(this._moverTimeout);
                if (uri == null) {
                    throw new TimeoutCacheException("Server is busy (internal timeout)");
                }
            }
            finally {
                this._redirects.remove((Object)pnfsid, (Object)transfer);
                transfer.setStatus(null);
            }
            transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Waiting for completion");
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            if (uri == null) {
                this._transfers.remove(transfer.getSessionId());
            }
        }
        return transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage envelope, HttpDoorUrlInfoMessage message) {
        PnfsId pnfsId = new PnfsId(message.getPnfsId());
        String pool = envelope.getSourceAddress().getCellName();
        SetMultimap<PnfsId, HttpTransfer> setMultimap = this._redirects;
        synchronized (setMultimap) {
            Iterator i = this._redirects.get((Object)pnfsId).iterator();
            while (i.hasNext()) {
                HttpTransfer transfer = (HttpTransfer)((Object)i.next());
                if (!pool.equals(transfer.getPool())) continue;
                i.remove();
                transfer.redirect(message.getUrl());
                return;
            }
        }
    }

    public void messageArrived(DoorTransferFinishedMessage message) {
        Transfer transfer = this._transfers.get(message.getId());
        if (transfer != null) {
            transfer.finished(message);
        }
    }

    private FsPath getFullPath(String path) {
        return new FsPath(new FsPath[]{this._rootPath, new FsPath(path)});
    }

    private boolean isAllowedPath(FsPath path) {
        for (FsPath allowedPath : this._allowedPaths) {
            if (!path.startsWith(allowedPath)) continue;
            return true;
        }
        return false;
    }

    private Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] list = new String[]{this._cellName};
            return new LoginManagerChildrenInfo(this._cellName, this._domainName, list);
        }
        return this._cellName;
    }

    public Object ac_get_door_info(Args args) {
        ArrayList<IoDoorEntry> transfers = new ArrayList<IoDoorEntry>();
        for (Transfer transfer : this._transfers.values()) {
            transfers.add(transfer.getIoDoorEntry());
        }
        IoDoorInfo doorInfo = new IoDoorInfo(this._cellName, this._domainName);
        doorInfo.setProtocol("HTTP", "1.1");
        doorInfo.setOwner("");
        doorInfo.setProcess("");
        doorInfo.setIoDoorEntries(transfers.toArray(new IoDoorEntry[0]));
        return args.hasOption("binary") ? doorInfo : doorInfo.toString();
    }

    private void initializeTransfer(HttpTransfer transfer, Subject subject) {
        transfer.setCellName(this._cellName);
        transfer.setDomainName(this._domainName);
        transfer.setPoolManagerStub(this._poolManagerStub);
        transfer.setPoolStub(this._poolStub);
        transfer.setBillingStub(this._billingStub);
        transfer.setClientAddress(new InetSocketAddress(Subjects.getOrigin((Subject)subject).getAddress(), 0));
        transfer.setOverwriteAllowed(this._isOverwriteAllowed);
    }

    private class WriteTransfer
    extends HttpTransfer {
        private ServerSocketChannel _serverChannel;

        public WriteTransfer(PnfsHandler pnfs, Subject subject, FsPath path) {
            super(pnfs, subject, path);
        }

        public synchronized void openServerChannel() throws IOException {
            this._serverChannel = ServerSocketChannel.open();
            try {
                this._serverChannel.socket().setSoTimeout(DcacheResourceFactory.this._moverTimeout);
                this._serverChannel.socket().bind(new InetSocketAddress(DcacheResourceFactory.this._internalAddress, 0));
            }
            catch (IOException e) {
                this._serverChannel.close();
                this._serverChannel = null;
                throw e;
            }
        }

        public synchronized void closeServerChannel() throws IOException {
            if (this._serverChannel != null) {
                this._serverChannel.close();
                this._serverChannel = null;
            }
        }

        public synchronized ServerSocketChannel getServerChannel() {
            return this._serverChannel;
        }

        @Override
        protected ProtocolInfo getProtocolInfoForPool() {
            ServerSocket socket = this.getServerChannel().socket();
            String address = socket.getInetAddress().getHostAddress();
            int port = socket.getLocalPort();
            return new GFtpProtocolInfo(DcacheResourceFactory.RELAY_PROTOCOL_INFO_NAME, 1, 0, address, port, 1, 1, 1, 0, 0L, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void relayData(InputStream inputStream) throws IOException, CacheException, InterruptedException {
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Waiting for data connection");
            try {
                ServerSocketChannel serverChannel = this.getServerChannel();
                if (serverChannel == null) {
                    throw new AsynchronousCloseException();
                }
                SocketChannel channel = this.getServerChannel().accept();
                try {
                    int read;
                    this.closeServerChannel();
                    this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Receiving data");
                    byte[] buffer = new byte[DcacheResourceFactory.this._bufferSize];
                    while ((read = inputStream.read(buffer)) > -1) {
                        ByteBuffer outputBuffer = ByteBuffer.wrap(buffer, 0, read);
                        while (outputBuffer.remaining() > 0) {
                            channel.write(outputBuffer);
                        }
                    }
                }
                finally {
                    channel.close();
                }
                if (!this.waitForMover(DcacheResourceFactory.this._transferConfirmationTimeout)) {
                    throw new CacheException("Missing transfer confirmation from pool");
                }
            }
            catch (AsynchronousCloseException e) {
                this.waitForMover(0L);
                throw new IllegalStateException("Server channel is not open");
            }
            catch (SocketTimeoutException e) {
                throw new TimeoutCacheException("Server is busy (internal timeout)");
            }
            finally {
                this.setStatus(null);
            }
        }

        public synchronized void finished(CacheException error) {
            super.finished(error);
            if (this._serverChannel != null) {
                try {
                    this._serverChannel.close();
                }
                catch (IOException e) {
                    _log.error("Failed to close pool connection: " + e.getMessage());
                }
            }
        }

        public void setLength(Long length) {
            if (length != null) {
                super.setLength(length.longValue());
            }
        }
    }

    private class ReadTransfer
    extends HttpTransfer {
        public ReadTransfer(PnfsHandler pnfs, Subject subject, FsPath path, PnfsId pnfsid) {
            super(pnfs, subject, path);
            this.setPnfsId(pnfsid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void relayData(OutputStream outputStream, Range range) throws IOException, CacheException, InterruptedException {
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Opening data connection");
            try {
                URL url = new URL((String)this.getRedirect());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestProperty("Connection", "Close");
                    if (range != null) {
                        connection.addRequestProperty("Range", String.format("bytes=%d-%d", range.getStart(), range.getFinish()));
                    }
                    connection.connect();
                    InputStream inputStream = connection.getInputStream();
                    try {
                        int read;
                        this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Sending data");
                        byte[] buffer = new byte[DcacheResourceFactory.this._bufferSize];
                        while ((read = inputStream.read(buffer)) > -1) {
                            outputStream.write(buffer, 0, read);
                        }
                        outputStream.flush();
                    }
                    finally {
                        inputStream.close();
                    }
                }
                finally {
                    connection.disconnect();
                }
                if (!this.waitForMover(DcacheResourceFactory.this._transferConfirmationTimeout)) {
                    throw new CacheException("Missing transfer confirmation from pool");
                }
            }
            catch (SocketTimeoutException e) {
                throw new TimeoutCacheException("Server is busy (internal timeout)");
            }
            finally {
                this.setStatus(null);
            }
        }

        public synchronized void finished(CacheException error) {
            super.finished(error);
            DcacheResourceFactory.this._transfers.remove(this.getSessionId());
            if (error == null) {
                this.notifyBilling(0, "");
            } else {
                this.notifyBilling(error.getRc(), error.getMessage());
            }
        }
    }

    private class HttpTransfer
    extends RedirectedTransfer<String> {
        public HttpTransfer(PnfsHandler pnfs, Subject subject, FsPath path) {
            super(pnfs, subject, path);
            DcacheResourceFactory.this.initializeTransfer(this, subject);
        }

        protected ProtocolInfo createProtocolInfo() {
            Origin origin = Subjects.getOrigin((Subject)this._subject);
            HttpProtocolInfo protocolInfo = new HttpProtocolInfo(DcacheResourceFactory.PROTOCOL_INFO_NAME, 1, 1, this.getClientAddress(), DcacheResourceFactory.this._cellName, DcacheResourceFactory.this._domainName, this._path.toString());
            protocolInfo.setSessionId((int)this.getSessionId());
            return protocolInfo;
        }

        protected ProtocolInfo getProtocolInfoForPoolManager() {
            return this.createProtocolInfo();
        }

        protected ProtocolInfo getProtocolInfoForPool() {
            return this.createProtocolInfo();
        }
    }
}

