/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Map;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheResource;
import org.dcache.webdav.DcacheResourceFactory;
import org.dcache.webdav.ForbiddenException;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.WebDavException;

public class DcacheFileResource
extends DcacheResource
implements GetableResource,
DeletableResource {
    private static final FileNameMap MIME_TYPE_MAP = URLConnection.getFileNameMap();

    public DcacheFileResource(DcacheResourceFactory factory, FsPath path, FileAttributes attributes) {
        super(factory, path, attributes);
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        try {
            this._factory.readFile(new FsPath(this._path), this._attributes.getPnfsId(), out, range);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (FileNotFoundCacheException e) {
            throw new ForbiddenException(e.getMessage(), e, this);
        }
        catch (NotInTrashCacheException e) {
            throw new ForbiddenException(e.getMessage(), e, this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (InterruptedException e) {
            throw new WebDavException("Transfer was interrupted", e, this);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return MIME_TYPE_MAP.getContentTypeFor(this._path.toString());
    }

    public Long getContentLength() {
        return this._attributes.getSize();
    }

    @Override
    public String checkRedirect(Request request) {
        try {
            switch (request.getMethod()) {
                case GET: {
                    if (this._factory.isRedirectOnReadEnabled()) {
                        return this._factory.getReadUrl(this._path, this._attributes.getPnfsId());
                    }
                    return null;
                }
            }
            return null;
        }
        catch (PermissionDeniedCacheException e) {
            throw new UnauthorizedException(e.getMessage(), e, this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (InterruptedException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        try {
            this._factory.deleteFile(this._attributes.getPnfsId(), this._path);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }
}

