/*
 * Decompiled with CFR 0.152.
 */
package org.pcells.services.connection;

import dmg.cells.applets.login.DomainObjectFrame;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pcells.services.connection.DomainConnection;
import org.pcells.services.connection.DomainConnectionListener;
import org.pcells.services.connection.DomainEventListener;

public class DomainConnectionAdapter
implements DomainConnection {
    private Map<DomainObjectFrame, DomainConnectionListener> _packetHash = new HashMap<DomainObjectFrame, DomainConnectionListener>();
    private final Object _ioLock = new Object();
    private int _ioCounter = 100;
    private List<DomainEventListener> _listener = new ArrayList<DomainEventListener>();
    private boolean _connected = false;
    private InputStream _inputStream = null;
    private OutputStream _outputStream = null;
    private Reader _reader = null;
    private Writer _writer = null;
    private ObjectOutputStream _objOut = null;
    private ObjectInputStream _objIn = null;

    @Override
    public String getAuthenticatedUser() {
        return "Unknown";
    }

    public void setIoStreams(InputStream in, OutputStream out) {
        this.setIoStreams(in, out, null, null);
    }

    public void setIoStreams(InputStream in, OutputStream out, Reader reader, Writer writer) {
        this._inputStream = in;
        this._outputStream = out;
        this._reader = reader;
        this._writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() throws Exception {
        this.runConnection();
        this.informListenersOpened();
        try {
            this.runReceiver();
        }
        finally {
            this.informListenersClosed();
        }
    }

    public void close() throws IOException {
        this._objOut.close();
    }

    private void runConnection() throws IOException {
        MyFilter inputstream = new MyFilter(this._inputStream);
        BufferedReader reader = new BufferedReader(this._reader == null ? new InputStreamReader(inputstream) : this._reader, 1);
        PrintWriter writer = new PrintWriter(this._writer == null ? new OutputStreamWriter(this._outputStream) : this._writer);
        writer.println("$BINARY$");
        writer.flush();
        String check = null;
        while (!(check = reader.readLine()).equals("$BINARY$")) {
        }
        this._objOut = new ObjectOutputStream(this._outputStream);
        this._objIn = new ObjectInputStream(inputstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReceiver() throws Exception {
        Object obj = null;
        DomainObjectFrame frame = null;
        DomainConnectionListener listener = null;
        while ((obj = this._objIn.readObject()) != null) {
            if (!(obj instanceof DomainObjectFrame)) continue;
            Object object = this._ioLock;
            synchronized (object) {
                frame = (DomainObjectFrame)obj;
                listener = this._packetHash.remove(frame);
                if (listener == null) {
                    System.err.println("Message without receiver : " + frame);
                    continue;
                }
            }
            try {
                listener.domainAnswerArrived(frame.getPayload(), frame.getSubId());
            }
            catch (Exception eee) {
                System.out.println("Problem in domainAnswerArrived : " + eee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendObject(Object obj, DomainConnectionListener listener, int id) throws IOException {
        Object object = this._ioLock;
        synchronized (object) {
            if (!this._connected) {
                throw new IOException("Not connected");
            }
            DomainObjectFrame frame = new DomainObjectFrame(obj, ++this._ioCounter, id);
            this._objOut.writeObject(frame);
            this._objOut.reset();
            this._packetHash.put(frame, listener);
            return this._ioCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendObject(String destination, Object obj, DomainConnectionListener listener, int id) throws IOException {
        Object object = this._ioLock;
        synchronized (object) {
            if (!this._connected) {
                throw new IOException("Not connected");
            }
            DomainObjectFrame frame = new DomainObjectFrame(destination, obj, ++this._ioCounter, id);
            this._objOut.writeObject(frame);
            this._objOut.reset();
            this._packetHash.put(frame, listener);
            return this._ioCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDomainEventListener(DomainEventListener listener) {
        Object object = this._ioLock;
        synchronized (object) {
            this._listener.add(listener);
            if (this._connected) {
                try {
                    listener.connectionOpened(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDomainEventListener(DomainEventListener listener) {
        Object object = this._ioLock;
        synchronized (object) {
            this._listener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListenersOpened() {
        ArrayList<DomainEventListener> array = new ArrayList<DomainEventListener>(this._listener);
        Object object = this._ioLock;
        synchronized (object) {
            this._connected = true;
            for (DomainEventListener listener : array) {
                try {
                    listener.connectionOpened(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListenersClosed() {
        ArrayList<DomainEventListener> array = new ArrayList<DomainEventListener>(this._listener);
        Object object = this._ioLock;
        synchronized (object) {
            this._connected = false;
            for (DomainEventListener listener : array) {
                try {
                    listener.connectionClosed(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static class MyFilter
    extends FilterInputStream {
        public MyFilter(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int r = super.read();
            return r;
        }

        @Override
        public int read(byte[] data, int offset, int len) throws IOException {
            int r = super.read(data, offset, 1);
            return r;
        }

        @Override
        public int read(byte[] data) throws IOException {
            byte[] x = new byte[1];
            int r = super.read(x);
            data[0] = x[0];
            return r;
        }
    }
}

