/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import dmg.util.logback.LoggerName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FilterThresholds {
    private final FilterThresholds _parent;
    private final Set<String> _filters = new HashSet<String>();
    private final Map<LoggerName, Map<String, Level>> _rules = new HashMap<LoggerName, Map<String, Level>>();
    private final Map<LoggerName, Map<String, Level>> _effectiveMaps = new HashMap<LoggerName, Map<String, Level>>();
    private final Map<LoggerName, Level> _effectiveLevels = new HashMap<LoggerName, Level>();
    private static final Comparator<Level> LEVEL_ORDER = new Comparator<Level>(){

        @Override
        public int compare(Level o1, Level o2) {
            if (!o1.isGreaterOrEqual(o2)) {
                return -1;
            }
            if (!o2.isGreaterOrEqual(o1)) {
                return 1;
            }
            return 0;
        }
    };

    public FilterThresholds() {
        this(null);
    }

    public FilterThresholds(FilterThresholds parent) {
        this._parent = parent;
    }

    public synchronized void addFilter(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Null value not allowed");
        }
        this._filters.add(filter);
    }

    public synchronized Collection<String> getFilters() {
        if (this._parent == null) {
            return new ArrayList<String>(this._filters);
        }
        Collection<String> filters = this._parent.getFilters();
        filters.addAll(this._filters);
        return filters;
    }

    public synchronized boolean hasFilter(String filter) {
        return this._filters.contains(filter) || this._parent != null && this._parent.hasFilter(filter);
    }

    public synchronized Level get(LoggerName logger, String filter) {
        return this.getMap(logger).get(filter);
    }

    public synchronized void setThreshold(LoggerName logger, String filter, Level level) {
        if (logger == null || filter == null || level == null) {
            throw new IllegalArgumentException("Null value not allowed");
        }
        if (!this.hasFilter(filter)) {
            throw new IllegalArgumentException("Filter does not exist");
        }
        Map<String, Level> map = this._rules.get(logger);
        if (map == null) {
            map = new HashMap<String, Level>();
            this._rules.put(logger, map);
        }
        map.put(filter, level);
        this.clearCache();
    }

    public synchronized void remove(LoggerName logger, String filter) {
        Map<String, Level> map = this._rules.get(logger);
        if (map != null) {
            map.remove(filter);
            if (map.isEmpty()) {
                this._rules.remove(logger);
            }
            this.clearCache();
        }
    }

    public synchronized void clear() {
        this._rules.clear();
        this.clearCache();
    }

    private synchronized void clearCache() {
        this._effectiveLevels.clear();
        this._effectiveMaps.clear();
    }

    private synchronized Map<String, Level> getMap(LoggerName logger) {
        Map<String, Level> map = this._rules.get(logger);
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public synchronized Map<String, Level> getInheritedMap(LoggerName logger) {
        if (this._parent == null) {
            return new HashMap<String, Level>(this.getMap(logger));
        }
        Map<String, Level> map = this._parent.getInheritedMap(logger);
        map.putAll(this.getMap(logger));
        return map;
    }

    private synchronized Map<String, Level> getEffectiveMap(LoggerName logger) {
        Map<String, Level> map = this._effectiveMaps.get(logger);
        if (map == null) {
            LoggerName parent = logger.getParent();
            if (parent == null) {
                map = this.getInheritedMap(logger);
            } else {
                map = new HashMap<String, Level>(this.getEffectiveMap(parent));
                map.putAll(this.getInheritedMap(logger));
            }
            this._effectiveMaps.put(logger, map);
        }
        return map;
    }

    public synchronized Level getThreshold(LoggerName logger, String filter) {
        return this.getEffectiveMap(logger).get(filter);
    }

    public synchronized Level getThreshold(LoggerName logger) {
        if (this._effectiveLevels.containsKey(logger)) {
            return this._effectiveLevels.get(logger);
        }
        Map<String, Level> map = this.getEffectiveMap(logger);
        Level level = map.isEmpty() ? null : Collections.min(map.values(), LEVEL_ORDER);
        this._effectiveLevels.put(logger, level);
        return level;
    }
}

