/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.logback.FilterThresholds;
import dmg.util.logback.LoggerName;
import java.util.Map;

public class CellThresholdFilterCompanion
extends Filter<ILoggingEvent> {
    private final String _name;

    public CellThresholdFilterCompanion(String name) {
        this._name = name;
    }

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        Map mdc = event.getMdc();
        String cell = mdc == null ? null : (String)mdc.get("cells.cell");
        CellNucleus nucleus = CellNucleus.getLogTargetForCell(cell);
        if (nucleus == null) {
            return FilterReply.NEUTRAL;
        }
        FilterThresholds thresholds = nucleus.getLoggingThresholds();
        if (thresholds == null) {
            return FilterReply.NEUTRAL;
        }
        Level threshold = thresholds.getThreshold(LoggerName.getInstance(event.getLoggerName()), this._name);
        if (threshold == null) {
            return FilterReply.NEUTRAL;
        }
        if (event.getLevel().isGreaterOrEqual(threshold)) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }
}

