/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.graphics;

import dmg.util.graphics.TreeNodeable;
import java.io.File;

public class FileTreeNode
implements TreeNodeable {
    private boolean _folded = true;
    private boolean _selected = false;
    private File _base = null;
    private FileTreeNode _sub = null;
    private FileTreeNode _next = null;

    public FileTreeNode(File f) {
        this._base = f;
    }

    @Override
    public String getName() {
        return this._base.getName();
    }

    @Override
    public TreeNodeable getNext() {
        return this._next;
    }

    @Override
    public TreeNodeable getSub() {
        if (this._sub != null) {
            return this._sub;
        }
        if (!this._base.isDirectory()) {
            return null;
        }
        String[] list = this._base.list();
        if (list == null || list.length == 0) {
            return null;
        }
        FileTreeNode[] nodes = new FileTreeNode[list.length];
        nodes[0] = new FileTreeNode(new File(this._base, list[0]));
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i] = new FileTreeNode(new File(this._base, list[i]));
            nodes[i - 1].setNextNode(nodes[i]);
        }
        this._sub = nodes[0];
        return this._sub;
    }

    public void setNextNode(FileTreeNode node) {
        this._next = node;
    }

    @Override
    public boolean isContainerNode() {
        return this._base.isDirectory();
    }

    @Override
    public boolean isFolded() {
        return this._folded;
    }

    @Override
    public void switchFold() {
        if (this._folded) {
            this._folded = false;
            this._sub = null;
        } else {
            this._folded = true;
        }
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    @Override
    public void setSelected(boolean sel) {
        this._selected = sel;
    }
}

