/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.edb;

import dmg.util.edb.JdbmBasic;
import dmg.util.edb.JdbmBucket;
import dmg.util.edb.JdbmBucketElement;
import dmg.util.edb.JdbmFileHeader;
import dmg.util.edb.JdbmSerializable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInput;

public class JdbmObjectInputStream
extends DataInputStream
implements ObjectInput {
    public JdbmObjectInputStream(DataInputStream in) {
        super(in);
    }

    public void readLongArray(long[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        short code = this.readShort();
        JdbmSerializable obj = null;
        switch (code) {
            case 16: {
                obj = new JdbmBasic();
                obj.readObject(this);
                break;
            }
            case 23: {
                obj = new JdbmFileHeader();
                obj.readObject(this);
                break;
            }
            case 17: {
                obj = new JdbmBucketElement();
                obj.readObject(this);
                break;
            }
            case 18: {
                obj = new JdbmBucket();
                obj.readObject(this);
                break;
            }
            default: {
                throw new ClassNotFoundException("Class not found : " + code);
            }
        }
        return obj;
    }
}

