/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.db;

import dmg.util.db.DbGLock;
import dmg.util.db.DbLockException;
import dmg.util.db.DbLockable;
import dmg.util.db.DbRecordable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DbFileRecord
extends DbGLock
implements DbRecordable {
    private DbLockable _superLock = null;
    private File _dataSource = null;
    private Hashtable _table = new Hashtable();
    private boolean _exists = true;
    private boolean _dataValid = false;

    public DbFileRecord(File source, boolean create) throws IOException {
        this(null, source, create);
    }

    public DbFileRecord(DbLockable superLock, File source, boolean create) throws IOException {
        super(superLock);
        this._superLock = superLock;
        this._dataSource = source;
        if (create && this._dataSource.exists()) {
            throw new IllegalArgumentException("DataSource already exists(2)");
        }
        if (!create && !this._dataSource.exists()) {
            throw new IllegalArgumentException("DataSource not found");
        }
        if (create) {
            FileOutputStream out = new FileOutputStream(this._dataSource);
            out.close();
        }
    }

    @Override
    public synchronized void open(int mode) throws DbLockException, InterruptedException {
        if (!this._exists) {
            throw new DbLockException("Object removed");
        }
        super.open(mode);
    }

    @Override
    public synchronized void setAttribute(String name, String attribute) {
        this._table.put(name, attribute);
    }

    @Override
    public synchronized void setAttribute(String name, String[] attribute) {
        this._table.put(name, attribute);
    }

    @Override
    public synchronized Object getAttribute(String name) {
        return this._table.get(name);
    }

    @Override
    public synchronized void remove() {
        this._exists = false;
        this._dataSource.delete();
    }

    @Override
    public synchronized Enumeration getAttributes() {
        return this._table.keys();
    }

    public synchronized void read() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this._dataSource));
        try {
            boolean state = false;
            String line = null;
            String name = null;
            String value = null;
            Vector<String> vec = null;
            StringTokenizer st = null;
            while ((line = reader.readLine()) != null) {
                if (!state) {
                    st = new StringTokenizer(line, "=");
                    if (st.countTokens() < 2) continue;
                    name = st.nextToken();
                    value = st.nextToken();
                    if (value.equals("***LIST***")) {
                        state = true;
                        vec = new Vector<String>();
                        continue;
                    }
                    this._table.put(name, value);
                    continue;
                }
                if (!state) continue;
                if (line.equals("***LIST***")) {
                    Object[] a = new String[vec.size()];
                    vec.copyInto(a);
                    this._table.put(name, a);
                    state = false;
                    continue;
                }
                vec.addElement(line);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ee) {}
        }
    }

    public synchronized void write() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(this._dataSource));
        Enumeration e = this._table.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object o = this._table.get(name);
            if (o == null) continue;
            if (o instanceof String[]) {
                pw.println(name + "=***LIST***");
                String[] str = (String[])o;
                for (int i = 0; i < str.length; ++i) {
                    pw.println(str[i]);
                }
                pw.println("***LIST***");
                continue;
            }
            if (!(o instanceof String)) continue;
            pw.println(name + "=" + o);
        }
        pw.close();
    }

    @Override
    public void readLockGranted() {
        System.out.println("readLockGranted " + this._dataSource);
        if (!this._dataValid) {
            try {
                this.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dataValid = true;
        }
    }

    @Override
    public void writeLockGranted() {
        System.out.println("writeLockGranted " + this._dataSource);
        if (!this._dataValid) {
            try {
                this.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dataValid = true;
        }
    }

    @Override
    public void readLockReleased() {
        System.out.println("readLockReleased " + this._dataSource);
    }

    @Override
    public void writeLockReleased() {
        System.out.println("writeLockReleased " + this._dataSource);
        try {
            this.write();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("... read/write <filename>");
            System.exit(4);
        }
        if (args[0].equals("read")) {
            DbFileRecord rec = new DbFileRecord(new File(args[1]), false);
            for (int l = 0; l < 2; ++l) {
                long start = System.currentTimeMillis();
                rec.open(2);
                long opened = System.currentTimeMillis();
                Enumeration e = rec.getAttributes();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Object o = rec.getAttribute(name);
                    if (o != null && !(o instanceof String[]) && !(o instanceof String)) continue;
                }
                long fetched = System.currentTimeMillis();
                rec.close();
                long finished = System.currentTimeMillis();
                System.out.println("Open  : " + (opened - start));
                System.out.println("Read  : " + (fetched - opened));
                System.out.println("Close : " + (finished - fetched));
            }
        } else if (!args[0].equals("test") && args[0].equals("write")) {
            DbFileRecord rec = new DbFileRecord(new File(args[1]), true);
            rec.open(2);
            rec.setAttribute("storageGroup", "dst-98");
            String[] bfids = new String[2000];
            String str = null;
            StringBuffer sb = null;
            for (int i = 0; i < bfids.length; ++i) {
                sb = new StringBuffer();
                str = "" + i;
                sb.append("U");
                for (int j = 5; j >= str.length(); --j) {
                    sb.append('0');
                }
                sb.append(str);
                bfids[i] = sb.toString();
            }
            rec.setAttribute("bfids", bfids);
            rec.close();
        }
    }
}

