/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.cdb;

import dmg.util.cdb.CdbLockException;
import dmg.util.cdb.CdbLockListener;
import dmg.util.cdb.CdbLockable;
import java.util.Hashtable;
import java.util.Vector;

public class CdbGLock
implements CdbLockListener,
CdbLockable {
    private static final int NOTHING_CHANGED = 0;
    private static final int WRITE_TO_READ = 1;
    private static final int NOTHING_LEFT = 2;
    private Vector _list = new Vector(8);
    private Hashtable _hash = new Hashtable();
    private CdbLockListener _listener = null;
    private CdbLockable _creator = null;

    public CdbGLock(CdbLockListener listener) {
        this._listener = listener;
    }

    public CdbGLock() {
        this._listener = this;
    }

    public CdbGLock(CdbLockable creator) {
        this._listener = this;
        this._creator = creator;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._list.size(); ++i) {
            sb.append(this._list.elementAt(i).toString());
        }
        return sb.toString();
    }

    @Override
    public synchronized void close(int flags) throws CdbLockException {
        Thread ourThread = Thread.currentThread();
        LockEntry entry = (LockEntry)this._hash.get(ourThread);
        if (entry == null) {
            throw new CdbLockException("mutex not owned");
        }
        boolean wasWriteLocked = entry.isWriteLocked();
        switch (entry.degrade()) {
            case 1: {
                if ((flags & 8) > 0) {
                    this.writeLockReleased();
                    break;
                }
                this.writeLockAborted();
                break;
            }
            case 2: {
                this._list.removeElement(entry);
                this._hash.remove(ourThread);
                if (wasWriteLocked) {
                    if ((flags & 8) > 0) {
                        this.writeLockReleased();
                        break;
                    }
                    this.writeLockAborted();
                    break;
                }
                this.readLockReleased();
            }
        }
        this.notifyAll();
        if (this._creator != null) {
            this._creator.close(8);
        }
    }

    @Override
    public synchronized void open(int flags) throws CdbLockException, InterruptedException {
        Thread ourThread;
        LockEntry entry;
        if (this._creator != null) {
            this._creator.open(1);
        }
        if ((entry = (LockEntry)this._hash.get(ourThread = Thread.currentThread())) != null) {
            if ((flags & 2) > 0 && !entry.isWriteLocked()) {
                entry.upgrade();
                this._list.removeElement(entry);
                this._list.addElement(entry);
                this.notifyAll();
                while (this._list.elementAt(0) != entry) {
                    this.wait();
                }
                this.writeLockGranted();
                return;
            }
            entry.increment();
            return;
        }
        entry = new LockEntry(ourThread, (flags & 2) > 0);
        this._list.addElement(entry);
        if ((flags & 2) > 0) {
            if ((flags & 4) > 0 && this._list.elementAt(0) != entry) {
                this._list.removeElementAt(this._list.size() - 1);
                throw new CdbLockException("Lock not granted");
            }
            while (this._list.elementAt(0) != entry) {
                this.wait();
            }
            this.writeLockGranted();
        } else {
            int i;
            if ((flags & 4) > 0) {
                i = 0;
                for (i = 0; i < this._list.size() && !((LockEntry)this._list.elementAt(i)).isWriteLocked() && this._list.elementAt(i) != entry; ++i) {
                }
                if (i == this._list.size()) {
                    throw new CdbLockException("Panic : 1");
                }
                if (this._list.elementAt(i) != entry) {
                    this._list.removeElementAt(this._list.size() - 1);
                    throw new CdbLockException("Lock not granted");
                }
            }
            while (true) {
                i = 0;
                for (i = 0; i < this._list.size() && !((LockEntry)this._list.elementAt(i)).isWriteLocked() && this._list.elementAt(i) != entry; ++i) {
                }
                if (i == this._list.size()) {
                    throw new CdbLockException("Panic : 2");
                }
                if (this._list.elementAt(i) == entry) break;
                this.wait();
            }
            this.readLockGranted();
        }
        this._hash.put(ourThread, entry);
    }

    @Override
    public void readLockGranted() {
    }

    @Override
    public void writeLockGranted() {
    }

    @Override
    public void readLockReleased() {
    }

    @Override
    public void writeLockReleased() {
    }

    @Override
    public void writeLockAborted() {
    }

    public static void main(String[] args) throws Exception {
        CdbGLock lock = new CdbGLock();
        for (int i = 0; i < 3; ++i) {
            long start = System.currentTimeMillis();
            lock.open(2);
            long opened = System.currentTimeMillis();
            lock.close(8);
            long finished = System.currentTimeMillis();
            System.out.println("Open   : " + (opened - start));
            System.out.println("Close  : " + (finished - opened));
        }
    }

    private class LockEntry {
        private Thread _thread = null;
        private int _position = -1;
        private LockEntryDesc[] _desc = new LockEntryDesc[2];

        private LockEntry(Thread thread, boolean writeLock) {
            this._thread = thread;
            this._desc[0] = new LockEntryDesc(writeLock);
            this._position = 0;
        }

        public Thread getThread() {
            return this._thread;
        }

        public boolean isWriteLocked() {
            return this._desc[this._position]._isWriteLock;
        }

        public void increment() {
            this._desc[this._position]._counter++;
        }

        public int getCounter() {
            return this._desc[this._position]._counter;
        }

        public void upgrade() throws CdbLockException {
            if (this._position > 0) {
                throw new CdbLockException("PANIC close=(_position==1)");
            }
            this._desc[++this._position] = new LockEntryDesc(true);
        }

        public int degrade() throws CdbLockException {
            if (this._position < 0) {
                throw new CdbLockException("PANIC close=(_position<0)");
            }
            if (this._desc[this._position]._counter <= 0) {
                throw new CdbLockException("PANIC close=(_counter<=0)");
            }
            this._desc[this._position]._counter--;
            if (this._desc[this._position]._counter <= 0) {
                --this._position;
                return this._position < 0 ? 2 : 1;
            }
            return 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" +Thread : " + this._thread + "\n");
            if (this._position < 0) {
                sb.append("Not assigned ???\n");
            } else {
                for (int i = 0; i < 2; ++i) {
                    if (this._desc[i] == null) {
                        sb.append("  Desc[" + i + "]=null\n");
                        continue;
                    }
                    sb.append(this._position == i ? "*" : " ");
                    sb.append(" Desc[" + i + "]=" + this._desc[i].toString() + "\n");
                }
            }
            return sb.toString();
        }

        private class LockEntryDesc {
            private boolean _isWriteLock = false;
            private int _counter = 0;

            private LockEntryDesc(boolean writeLock) {
                this._isWriteLock = writeLock;
                this._counter = 1;
            }

            public String toString() {
                return "WriteLock=" + this._isWriteLock + ";Counter=" + this._counter;
            }
        }
    }
}

