/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.cdb;

import dmg.util.cdb.CdbContainable;
import dmg.util.cdb.CdbElementHandle;
import dmg.util.cdb.CdbElementable;
import dmg.util.cdb.CdbException;
import dmg.util.cdb.CdbGLock;
import dmg.util.cdb.CdbLockException;
import dmg.util.cdb.CdbLockable;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class CdbDirectoryContainer
extends CdbGLock
implements CdbContainable,
CdbElementable {
    private Class _elementClass = null;
    private Class _handlerClass = null;
    private File _containerDirectory = null;
    private Constructor _handlerConstructor = null;
    private Constructor _elementConstructor = null;
    private Method _elementRemoveMethod = null;
    private boolean _sticky = false;
    private boolean _exists = true;
    private static final Class[] __elementConstructorArguments = new Class[]{CdbLockable.class, File.class, Boolean.TYPE};
    private static final Class[] __handlerConstructorArguments = new Class[]{String.class, CdbContainable.class, CdbElementable.class};
    private final Hashtable _table = new Hashtable();

    public CdbDirectoryContainer(CdbLockable superLock, Class elementClass, Class handlerClass, File directory, boolean create) throws CdbException {
        this._elementClass = elementClass;
        this._handlerClass = handlerClass;
        this._containerDirectory = directory;
        if (create) {
            if (this._containerDirectory.exists()) {
                throw new IllegalArgumentException("DataSource already exists");
            }
            if (!this._containerDirectory.mkdir()) {
                throw new IllegalArgumentException("Failed to create : " + this._containerDirectory);
            }
        } else if (!this._containerDirectory.isDirectory()) {
            throw new IllegalArgumentException("DataSource does not exist");
        }
        try {
            this._elementConstructor = elementClass.getConstructor(__elementConstructorArguments);
        }
        catch (NoSuchMethodException nsme) {
            throw new CdbException("No matching container constructor found for : " + elementClass.getName());
        }
        try {
            this._elementRemoveMethod = this._elementClass.getMethod("remove", new Class[0]);
        }
        catch (NoSuchMethodException nsmei) {
            throw new CdbException("No matching remove method found");
        }
        try {
            this._handlerConstructor = this._handlerClass.getConstructor(__handlerConstructorArguments);
        }
        catch (NoSuchMethodException nsme) {
            throw new CdbException("No matching handler constructor found");
        }
    }

    public void setSticky(boolean sticky) {
        this._sticky = sticky;
    }

    public CdbElementHandle createElement(String name) throws CdbException, InterruptedException {
        CdbElementHandle handle = null;
        this.open(2);
        File file = new File(this._containerDirectory, name);
        if (file.exists()) {
            this.close(16);
            throw new CdbException("Record already exists " + file);
        }
        try {
            handle = this.createMirrorEntry(name, true);
        }
        catch (CdbException edbe) {
            this.close(16);
            throw edbe;
        }
        this.close(8);
        return handle;
    }

    public CdbElementHandle getElementByName(String name) throws CdbException, InterruptedException {
        ElementEntry entry = null;
        Object element = null;
        CdbElementHandle handle = null;
        this.open(1);
        entry = (ElementEntry)this._table.get(name);
        if (entry != null) {
            entry.incrementRefCounter();
            this.close(8);
            return this.newHandlerInstance(name, this, entry.getLockable());
        }
        File file = new File(this._containerDirectory, name);
        if (!file.exists()) {
            this.close(16);
            throw new CdbException("Record does not exists " + file);
        }
        try {
            handle = this.createMirrorEntry(name, false);
        }
        catch (CdbException edbe) {
            this.close(16);
            throw edbe;
        }
        this.close(8);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CdbElementHandle createMirrorEntry(String name, boolean create) throws CdbException, InterruptedException {
        CdbElementHandle handle = null;
        CdbLockable element = null;
        try {
            if (this._elementConstructor != null) {
                Object[] args = new Object[]{this, new File(this._containerDirectory, name), create};
                element = (CdbLockable)this._elementConstructor.newInstance(args);
            }
        }
        catch (InvocationTargetException ite) {
            throw new CdbException("Invocation Failed : " + ite.getTargetException());
        }
        catch (Exception e) {
            throw new CdbException("Problem : " + e);
        }
        handle = this.newHandlerInstance(name, this, element);
        Hashtable hashtable = this._table;
        synchronized (hashtable) {
            this._table.put(name, new ElementEntry(element));
        }
        return handle;
    }

    private CdbElementHandle newHandlerInstance(String name, CdbContainable container, CdbLockable element) throws CdbException {
        CdbElementHandle handle = null;
        try {
            Object[] args = new Object[]{name, container, element};
            handle = (CdbElementHandle)this._handlerConstructor.newInstance(args);
        }
        catch (InvocationTargetException ite) {
            throw new CdbException("Invocation Failed : " + ite.getTargetException());
        }
        catch (Exception e) {
            throw new CdbException("Problem : " + e);
        }
        return handle;
    }

    public void removeElement(String name) throws CdbException, InterruptedException {
        this.open(2);
        CdbElementHandle handle = this.getElementByName(name);
        try {
            handle.open(2);
            try {
                ElementEntry entry = (ElementEntry)this._table.get(name);
                CdbLockable element = entry.getLockable();
                this._elementRemoveMethod.invoke((Object)element, new Object[0]);
            }
            catch (InvocationTargetException ive) {
                handle.close(16);
                Throwable t = ive.getTargetException();
                if (t instanceof CdbException) {
                    throw (CdbException)t;
                }
                throw new CdbException("Problem in remove method : " + t);
            }
            catch (Exception ee) {
                handle.close(16);
                throw new CdbException("Problem in remove method : " + ee);
            }
            handle.close(8);
        }
        catch (CdbException edbe) {
            this.close(16);
            throw edbe;
        }
        catch (InterruptedException ie) {
            this.close(16);
            throw ie;
        }
        this.close(8);
    }

    @Override
    public synchronized void unlinkElement(String name) {
        ElementEntry entry = (ElementEntry)this._table.get(name);
        if (entry == null) {
            return;
        }
        entry.decrementRefCounter();
        if (!this._sticky && entry.getRefCounter() <= 0) {
            this._table.remove(name);
        }
    }

    public String[] getElementNames() {
        return this._containerDirectory.list();
    }

    @Override
    public synchronized void open(int mode) throws CdbLockException, InterruptedException {
        if (!this._exists) {
            throw new CdbLockException("Object removed");
        }
        super.open(mode);
    }

    @Override
    public void remove() throws CdbException {
        this._exists = false;
        if (!this._containerDirectory.delete()) {
            throw new CdbException("Couldn't remove : " + this._containerDirectory);
        }
    }

    @Override
    public void readLockGranted() {
    }

    @Override
    public void writeLockGranted() {
    }

    @Override
    public void readLockReleased() {
    }

    @Override
    public void writeLockReleased() {
    }

    @Override
    public void writeLockAborted() {
    }

    private class ElementEntry {
        private CdbLockable _lockable = null;
        private int _refCounter = 0;

        private ElementEntry(CdbLockable lockable) {
            this._lockable = lockable;
            this._refCounter = 1;
        }

        private CdbLockable getLockable() {
            return this._lockable;
        }

        private synchronized void incrementRefCounter() {
            ++this._refCounter;
        }

        private synchronized void decrementRefCounter() {
            --this._refCounter;
        }

        private int getRefCounter() {
            return this._refCounter;
        }
    }
}

