/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.StateEngine;
import dmg.util.StateThread;
import java.net.Socket;

public class StateThreadTest
implements StateEngine {
    private String _hostname;
    private int _port;
    private Socket _socket;
    private Exception _exception;
    private StateThread _engine;
    private static String[] _sn = new String[]{"<init>", "<go_connecting>", "<connecting>", "<connection_ready>", "<connection_failed>", "<connection_timeout>", "<finished>"};
    private static final int TS_GO_CONNECTING = 1;
    private static final int TS_CONNECTING = 2;
    private static final int TS_CONNECTION_READY = 3;
    private static final int TS_CONNECTION_FAILED = 4;
    private static final int TS_CONNECTION_TIMEOUT = 5;
    private static final int TS_FINISHED = 6;

    public StateThreadTest(String host, int port) {
        this._hostname = host;
        this._port = port;
        this._engine = new StateThread(this);
        this._engine.start();
    }

    @Override
    public int runState(int state) {
        System.out.println("Changing to state " + _sn[state] + " Thread " + Thread.currentThread());
        switch (state) {
            case 0: {
                this._engine.setState(1);
                break;
            }
            case 1: {
                System.out.println("Connecting to " + this._hostname + " " + this._port);
                this._engine.setState(2, 10, 5);
                try {
                    this._socket = new Socket(this._hostname, this._port);
                    this._engine.setState(3);
                }
                catch (Exception e) {
                    this._engine.setState(4);
                    this._exception = e;
                }
                break;
            }
            case 3: {
                System.out.println("Connection ready");
                this._engine.setState(6);
                break;
            }
            case 4: {
                System.out.println("Connection Failed : " + this._exception);
                this._engine.setState(6);
                break;
            }
            case 5: {
                System.out.println("Connection timed out");
                this._engine.setState(6);
                break;
            }
            case 6: {
                System.out.println("Connection finished");
                this._engine.setFinalState();
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println(" USAGE : <hostname> <port>");
            System.exit(3);
        }
        int port = new Integer(args[1]);
        new StateThreadTest(args[0], port);
    }
}

