/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class PulsSampler {
    private HashMap _map = new HashMap();

    public synchronized Sample newSample(int delta) {
        Sample sample = new Sample(delta, 20);
        this._map.put(delta, sample);
        return sample;
    }

    public synchronized Sample getSample(int delta) {
        return (Sample)this._map.get(delta);
    }

    public synchronized void tick() {
        long t = System.currentTimeMillis();
        Iterator i = this._map.values().iterator();
        while (i.hasNext()) {
            ((Sample)i.next()).tick(t);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this._map.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString()).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        final PulsSampler sampler = new PulsSampler();
        Sample[] sample = new Sample[]{sampler.newSample(60), sampler.newSample(300), sampler.newSample(600)};
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    System.out.println(sampler.toString());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Random random = new Random();
                while (true) {
                    int n;
                    n = (n = random.nextInt()) > 0 ? n : -n;
                    long l = n % 100;
                    try {
                        Thread.sleep(l);
                    }
                    catch (Exception e) {
                        break;
                    }
                    sampler.tick();
                }
            }
        }).start();
    }

    public static void mains(String[] args) throws Exception {
        int n = 0;
        while (true) {
            if (++n >= 0) {
                continue;
            }
            System.out.println("Swapped");
        }
    }

    public class Sample {
        private int _samples = 20;
        private int _deltaBySample = 0;
        private int _delta = 0;
        private int[] _sample = null;
        private int _currentPosition = -1;
        private int _swaps = 0;

        private Sample(int delta, int samples) {
            if (delta < 1) {
                throw new IllegalArgumentException("Delta must > 0");
            }
            if (samples > 100 || samples < 10) {
                throw new IllegalArgumentException("10 <= samples <= 100");
            }
            this._samples = samples;
            this._delta = delta * 1000;
            this._deltaBySample = this._delta / this._samples;
            this._sample = new int[this._samples];
        }

        public synchronized void tick() {
            this.tick(System.currentTimeMillis());
        }

        public synchronized void tick(long c) {
            int position = (int)(c / (long)this._deltaBySample % (long)this._samples);
            if (position != this._currentPosition) {
                ++this._swaps;
                this._sample[position] = 0;
                this._currentPosition = position;
            }
            int n = position;
            this._sample[n] = this._sample[n] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            int sum = 0;
            Sample sample = this;
            synchronized (sample) {
                for (int i = 0; i < this._sample.length; ++i) {
                    sum += this._sample[i];
                }
            }
            return " samples=" + this._samples + ";delta=" + this._delta / 1000 + ";sum=" + sum + ";result=" + this.getRate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTicks() {
            int sum = 0;
            Sample sample = this;
            synchronized (sample) {
                for (int i = 0; i < this._sample.length; ++i) {
                    sum += this._sample[i];
                }
            }
            return sum;
        }

        public int getDelta() {
            return this._delta;
        }

        public int getRealDelta() {
            return this._swaps < this._samples ? (this._swaps == 0 ? 1 : this._deltaBySample * this._swaps) : this._delta;
        }

        public float getRate() {
            return (float)this.getTicks() / (float)this.getRealDelta() * 1000.0f;
        }
    }
}

