/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class LogoCanvas
extends Canvas
implements MouseListener,
Runnable {
    private String _string = "PnfsSpy";
    private String _result;
    private Font _font;
    private Font _smallFont;
    private Toolkit _toolkit;
    private ActionListener _actionListener = null;
    private boolean _makeChoiseMode = false;
    private String[] _choises;
    private final Object _choiseLock = new Object();
    private int[] _offsets;
    private Thread _worker = null;
    private int _animationMode = 0;
    private int _animationState = 0;
    private int _edges = 3;
    private Image _offImage;
    private final Object _animationLock = new Object();
    private Image[] _snowImages;
    private int _snowImagesCount = 8;
    private int _snowImagesWidth;
    private int _snowImagesHeight;
    public static final int INFINIT = 1;
    public static final int GROWING = 2;
    public static final int SHRINKING = 3;
    public static final int SNOW = 4;

    public LogoCanvas(String title) {
        this._string = title == null ? "" : title;
        this._toolkit = this.getToolkit();
        this.setBackground(Color.blue);
        this.addMouseListener(this);
        this._font = new Font("TimesRoman", 1, 20);
        this._smallFont = new Font("TimesRoman", 2, 20);
        this._makeChoiseMode = false;
        this._animationMode = 0;
    }

    public void setActionListener(ActionListener l) {
        this._actionListener = l;
    }

    public void setString(String str) {
        this._makeChoiseMode = false;
        System.out.println("Going into stop animation");
        this._stopAnimation();
        System.out.println("Going into repaint");
        this._string = str;
        this.repaint();
        this._toolkit.sync();
        System.out.println("Leaving repaint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animation(int mode) {
        this._makeChoiseMode = false;
        this._animationMode = mode;
        this._animationState = this._animationMode == 1 || this._animationMode == 2 ? 0 : 1000;
        Object object = this._animationLock;
        synchronized (object) {
            if (this._worker != null) {
                this._worker.interrupt();
            }
            this._worker = new Thread(this);
            this._worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeChoise(String title, String[] choises) {
        this._stopAnimation();
        this._makeChoiseMode = true;
        this._string = title;
        this._choises = choises;
        this._offsets = new int[choises.length];
        Object object = this._choiseLock;
        synchronized (object) {
            System.out.println(" choise : repaint ");
            this.repaint();
            this._toolkit.sync();
            try {
                this._choiseLock.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        this._makeChoiseMode = false;
        this._string = "";
        return this._result;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this._makeChoiseMode) {
            g.setColor(Color.red);
            g.setFont(this._font);
            FontMetrics fm = g.getFontMetrics();
            int y = 10;
            int x = 10;
            g.drawString(this._string, x, y += fm.getHeight());
            x += 10;
            g.setFont(this._smallFont);
            fm = g.getFontMetrics();
            int height = fm.getHeight();
            int leading = fm.getLeading();
            for (int i = 0; i < this._choises.length; ++i) {
                g.drawString(this._choises[i], x, y += height + 2 * leading);
                this._offsets[i] = y;
            }
            this._toolkit.sync();
        } else if (this._animationMode > 0) {
            if (this._animationMode == 4) {
                this._createSnowImages(d);
                this._drawSnowImages(g);
            } else {
                this._offImage = this.createImage(d.width, d.height);
                this._makeFun(g);
            }
        } else {
            if (this._string == null) {
                return;
            }
            g.setFont(this._font);
            FontMetrics fm = g.getFontMetrics();
            int height = fm.getHeight();
            int width = fm.stringWidth(this._string);
            int y = (d.height + height) / 2;
            int x = (d.width - width) / 2;
            g.setColor(Color.red);
            g.drawString(this._string, x, y);
        }
    }

    @Override
    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this._animationMode > 0) {
            if (this._animationMode == 4) {
                this._createSnowImages(d);
                this._drawSnowImages(g);
            } else {
                if (this._offImage == null) {
                    this._offImage = this.createImage(d.width, d.height);
                }
                this._makeFun(g);
            }
        } else {
            g.setColor(Color.blue);
            g.fillRect(0, 0, d.width, d.height);
            this.paint(g);
        }
    }

    private void _drawSnowImages(Graphics g) {
        int s = this._animationState % this._snowImagesCount;
        g.drawImage(this._snowImages[s], 0, 0, null);
    }

    private void _createSnowImages(Dimension d) {
        Random r = new Random();
        if (this._snowImages == null || d.height != this._snowImagesHeight || d.width != this._snowImagesWidth) {
            this._snowImages = new Image[this._snowImagesCount];
            this._snowImagesHeight = d.height;
            this._snowImagesWidth = d.width;
            for (int i = 0; i < this._snowImagesCount; ++i) {
                this._snowImages[i] = this.createImage(d.width, d.height);
                Graphics g = this._snowImages[i].getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, d.width, d.height);
                g.setColor(Color.black);
                System.out.println(" Creating snow image " + i);
                for (int w = 0; w < d.width; ++w) {
                    for (int h = 0; h < d.height; ++h) {
                        if (r.nextInt() % 2 <= 0) continue;
                        g.drawLine(w, h, w, h);
                    }
                }
                System.out.println(" Ready");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopAnimation() {
        this._animationMode = 0;
        System.out.println("Trying to enter animationLock ");
        Object object = this._animationLock;
        synchronized (object) {
            System.out.println("AnimationLock entered ");
            if (this._worker != null) {
                System.out.println("Worker not yet zero ");
                this._worker = null;
            } else {
                System.out.println("Worker is zero ( doing nothing) ");
            }
        }
        System.out.println("AnimationLock left ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread worker;
        Object object = this._animationLock;
        synchronized (object) {
            worker = this._worker;
        }
        if (Thread.currentThread() == worker) {
            System.out.println(" run (mode=" + this._animationMode + ")");
            if (this._animationMode == 1) {
                while (true) {
                    this._runUp();
                    this._runDown();
                    ++this._edges;
                    if (this._edges <= 5) continue;
                    this._edges = 3;
                }
            }
            if (this._animationMode == 2) {
                this._edges = 3;
                this._runUp();
                System.out.println("RunUp stopped, going into ActionListner");
                if (this._actionListener != null) {
                    this._actionListener.actionPerformed(new ActionEvent(this, 0, "finished"));
                }
                System.out.println("ActionListner returned");
            } else if (this._animationMode == 3) {
                this._edges = 3;
                this._runDown();
                if (this._actionListener != null) {
                    this._actionListener.actionPerformed(new ActionEvent(this, 0, "finished"));
                }
            } else if (this._animationMode == 4) {
                this._runSnow();
                if (this._actionListener != null) {
                    this._actionListener.actionPerformed(new ActionEvent(this, 0, "finished"));
                }
            }
        }
        object = this._animationLock;
        synchronized (object) {
            this._worker = null;
        }
    }

    private void _runSnow() {
        this._animationState = 0;
        while (true) {
            this.repaint();
            this._toolkit.sync();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this._animationState;
        }
    }

    private void _runDown() {
        this._animationState = 1000;
        while (this._animationState >= 0) {
            this.repaint();
            this._toolkit.sync();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._animationState -= 10;
        }
    }

    private void _runUp() {
        this._animationState = 0;
        while (this._animationState < 1001) {
            this.repaint();
            this._toolkit.sync();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._animationState += 10;
        }
    }

    private void _makeFun(Graphics g) {
        double fraction = (double)this._animationState / 1000.0;
        Dimension d = this.getSize();
        if (this._offImage == null) {
            return;
        }
        Graphics offGraphics = this._offImage.getGraphics();
        offGraphics.setColor(Color.blue);
        offGraphics.fillRect(0, 0, d.width, d.height);
        offGraphics.setColor(Color.red);
        this._drawPolygon(offGraphics, fraction);
        offGraphics.setColor(Color.blue);
        this._drawPolygon(offGraphics, fraction * 0.5);
        offGraphics.setColor(Color.yellow);
        this._drawPolygon(offGraphics, fraction * 0.25);
        g.drawImage(this._offImage, 0, 0, null);
    }

    public void _drawPolygon(Graphics g, double fraction) {
        Dimension d = this.getSize();
        double y0 = (double)d.height / 2.0;
        double x0 = (double)d.width / 2.0;
        double r = Math.min(x0, y0) * fraction;
        double a = fraction * 2.0 * Math.PI;
        int n = this._edges;
        double diff = Math.PI * 2 / (double)n;
        int[] x = new int[n];
        int[] y = new int[n];
        int i = 0;
        while (i < n) {
            x[i] = (int)(x0 + r * Math.sin(a));
            y[i] = (int)(y0 - r * Math.cos(a));
            ++i;
            a += diff;
        }
        g.fillPolygon(x, y, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._makeChoiseMode) {
            Object object = this._choiseLock;
            synchronized (object) {
                int i;
                this._result = null;
                if (this._offsets == null) {
                    return;
                }
                for (i = 0; i < this._offsets.length && this._offsets[i] <= e.getY(); ++i) {
                }
                if (i == this._offsets.length) {
                    return;
                }
                this._result = this._choises[i];
                this._choiseLock.notifyAll();
            }
        } else if (this._animationMode > 0) {
            this._stopAnimation();
            if (this._actionListener != null) {
                this._actionListener.actionPerformed(new ActionEvent(this, 0, "clicked"));
            }
        } else if (this._actionListener != null) {
            this._actionListener.actionPerformed(new ActionEvent(this, 0, "clicked"));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

