/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import dmg.util.Args;
import dmg.util.Authorizable;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandPanicException;
import dmg.util.CommandRequestable;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.Interpretable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandInterpreter
implements Interpretable {
    private static final Class<?> __asciiArgsClass = Args.class;
    private static final Class<?> __binaryArgsClass = CommandRequestable.class;
    private static final int ASCII = 0;
    private static final int BINARY = 1;
    private static final int FULL_HELP = 2;
    private static final int HELP_HINT = 3;
    private static final int ACLS = 4;
    private final CommandEntry _rootEntry = new CommandEntry("");
    private static final int FT_HELP_HINT = 0;
    private static final int FT_FULL_HELP = 1;
    private static final int FT_ACL = 2;

    public CommandInterpreter() {
        this.addCommandListener(this);
    }

    public CommandInterpreter(Object commandListener) {
        this.addCommandListener(commandListener);
    }

    public void addCommandListener(Object commandListener) {
        this._addCommandListener(commandListener);
    }

    private synchronized void _addCommandListener(Object commandListener) {
        CommandEntry currentEntry;
        Class<?> c = commandListener.getClass();
        for (Method method : c.getMethods()) {
            String comName;
            Class<?>[] params = method.getParameterTypes();
            int methodType = 0;
            if (params.length != 1) continue;
            if (params[0].equals(__asciiArgsClass)) {
                methodType = 0;
            } else {
                if (!params[0].equals(__binaryArgsClass)) continue;
                methodType = 1;
            }
            Iterator i = Splitter.on((char)'_').split((CharSequence)method.getName()).iterator();
            if (!((String)i.next()).equals("ac")) continue;
            currentEntry = this._rootEntry;
            while (i.hasNext() && !(comName = (String)i.next()).equals("$")) {
                CommandEntry h = currentEntry.get(comName);
                if (h == null) {
                    h = new CommandEntry(comName);
                    currentEntry.put(comName, h);
                }
                currentEntry = h;
            }
            int minArgs = 0;
            int maxArgs = 0;
            try {
                if (i.hasNext()) {
                    minArgs = Integer.parseInt((String)i.next());
                    maxArgs = i.hasNext() ? Integer.parseInt((String)i.next()) : minArgs;
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(method.getName() + ": " + e.getMessage());
            }
            currentEntry.setMethod(methodType, commandListener, method, minArgs, maxArgs);
        }
        block9: for (AccessibleObject accessibleObject : c.getFields()) {
            Iterator i = Splitter.on((char)'_').split((CharSequence)((Field)accessibleObject).getName()).iterator();
            int helpMode = -1;
            String helpType = (String)i.next();
            if (helpType.equals("hh")) {
                helpMode = 0;
            } else if (helpType.equals("fh")) {
                helpMode = 1;
            } else {
                if (!helpType.equals("acl")) continue;
                helpMode = 2;
            }
            currentEntry = this._rootEntry;
            CommandEntry h = null;
            while (i.hasNext() && (h = currentEntry.get((String)i.next())) != null) {
                currentEntry = h;
            }
            if (h == null) continue;
            switch (helpMode) {
                case 1: {
                    currentEntry.setFullHelp(commandListener, (Field)accessibleObject);
                    continue block9;
                }
                case 0: {
                    currentEntry.setHelpHint(commandListener, (Field)accessibleObject);
                    continue block9;
                }
                case 2: {
                    currentEntry.setACLS(commandListener, (Field)accessibleObject);
                }
            }
        }
    }

    private void dumpHelpHint(List<CommandEntry> path, CommandEntry entry, StringBuilder sb) {
        StringBuilder sbx = new StringBuilder();
        for (CommandEntry ce : path) {
            sbx.append(ce.getName()).append(" ");
        }
        String top = sbx.toString();
        this.dumpHelpHint(top, entry, sb);
    }

    private void dumpHelpHint(String top, CommandEntry entry, StringBuilder sb) {
        Field helpHint = entry.getHelpHint();
        int mt = 0;
        Method method = entry.getMethod(mt);
        if (helpHint != null) {
            try {
                sb.append(top).append(helpHint.get(entry.getListener(mt))).append("\n");
            }
            catch (IllegalAccessException iae) {}
        } else if (method != null) {
            int i;
            sb.append(top);
            for (i = 0; i < entry.getMinArgs(mt); ++i) {
                sb.append(" <arg-").append(i).append(">");
            }
            if (entry.getMaxArgs(mt) != entry.getMinArgs(mt)) {
                sb.append(" [ ");
                for (i = entry.getMinArgs(mt); i < entry.getMaxArgs(mt); ++i) {
                    sb.append(" <arg-").append(i).append(">");
                }
                sb.append(" ] ");
            }
            sb.append("\n");
        }
        for (CommandEntry ce : entry) {
            this.dumpHelpHint(top + ce.getName() + " ", ce, sb);
        }
    }

    private String runHelp(Args args) {
        CommandEntry ce;
        CommandEntry entry = this._rootEntry;
        ArrayList path = Lists.newArrayList();
        while (args.argc() > 0 && (ce = entry.get(args.argv(0))) != null) {
            path.add(ce);
            args.shift();
            entry = ce;
        }
        Field f = entry.getFullHelp();
        StringBuilder sb = new StringBuilder();
        if (f == null) {
            this.dumpHelpHint(path, entry, sb);
        } else {
            try {
                sb.append(f.get(entry.getListener(0)));
            }
            catch (IllegalAccessException ee) {
                this.dumpHelpHint(path, entry, sb);
            }
        }
        return sb.toString();
    }

    public String command(String str) throws CommandExitException {
        try {
            Object o = this.command(new Args(str));
            if (o == null) {
                return "";
            }
            return (String)o;
        }
        catch (CommandSyntaxException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Syntax Error : ").append(e.getMessage()).append("\n");
            String help = e.getHelpText();
            if (help != null) {
                sb.append("Help : \n");
                sb.append(help);
            }
            return sb.toString();
        }
        catch (CommandExitException e) {
            throw e;
        }
        catch (CommandThrowableException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage()).append("\n");
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandPanicException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Panic : ").append(e.getMessage()).append("\n");
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandException e) {
            return "??? : " + e.toString();
        }
    }

    public Object command(Args args) throws CommandException {
        return this.execute(args, 0);
    }

    public Object command(CommandRequestable request) throws CommandException {
        return this.execute(request, 1);
    }

    public Object execute(Object command, int methodType) throws CommandException {
        Field aclField;
        CommandEntry ce;
        Object values;
        int params;
        CommandRequestable request;
        Args args;
        if (methodType == 0) {
            args = (Args)command;
            request = null;
            params = args.argc();
            values = args;
        } else {
            request = (CommandRequestable)command;
            args = new Args(request.getRequestCommand());
            params = request.getArgc();
            values = request;
        }
        if (args.argc() == 0) {
            return "";
        }
        if (args.argc() > 0 && args.argv(0).equals("help")) {
            args.shift();
            return this.runHelp(args);
        }
        if (args.argc() > 0 && args.argv(0).equals("xyzzy")) {
            return "Nothing happens.";
        }
        CommandEntry entry = this._rootEntry;
        CommandEntry lastAcl = null;
        ArrayList path = Lists.newArrayList();
        while (args.argc() > 0 && (ce = entry.get(args.argv(0))) != null) {
            if (ce.getACLS() != null) {
                lastAcl = ce;
            }
            path.add(ce);
            entry = ce;
            args.shift();
        }
        Method method = entry.getMethod(methodType);
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            if (methodType == 0) {
                this.dumpHelpHint(path, entry, sb);
            }
            throw new CommandSyntaxException("Command not found" + (args.argc() > 0 ? " : " + args.argv(0) : ""), sb.toString());
        }
        if (methodType == 0) {
            params = args.argc();
        }
        if (entry.getMinArgs(methodType) > params || entry.getMaxArgs(methodType) < params) {
            StringBuilder sb = new StringBuilder();
            if (methodType == 0) {
                this.dumpHelpHint(path, entry, sb);
            }
            throw new CommandSyntaxException("Invalid number of arguments", sb.toString());
        }
        boolean _checkAcls = true;
        Field field = aclField = lastAcl == null ? null : lastAcl.getACLS();
        if (_checkAcls && values instanceof Authorizable && aclField != null) {
            String[] acls = null;
            try {
                Object field2 = aclField.get(entry.getListener(0));
                if (field2 instanceof String[]) {
                    acls = (String[])field2;
                } else if (field2 instanceof String) {
                    acls = new String[]{(String)field2};
                }
            }
            catch (IllegalAccessException ee) {
                // empty catch block
            }
            if (acls != null) {
                this.checkAclPermission((Authorizable)values, command, acls);
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            return method.invoke(entry.getListener(methodType), values);
        }
        catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            if (te instanceof CommandSyntaxException) {
                CommandSyntaxException cse = (CommandSyntaxException)te;
                if (methodType == 0 && cse.getHelpText() == null) {
                    this.dumpHelpHint(path, entry, sb);
                    cse.setHelpText(sb.toString());
                }
                throw cse;
            }
            if (te instanceof CommandException) {
                throw (CommandException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            if (te instanceof RuntimeException && !(te instanceof IllegalArgumentException) && !(te instanceof IllegalStateException)) {
                boolean declared = false;
                for (Class<?> clazz : method.getExceptionTypes()) {
                    if (!clazz.isAssignableFrom(te.getClass())) continue;
                    declared = true;
                }
                if (!declared) {
                    throw (RuntimeException)te;
                }
            }
            throw new CommandThrowableException(te.toString() + " from " + method.getName(), te);
        }
        catch (IllegalAccessException iae) {
            throw new CommandPanicException("Exception while invoking " + method.getName(), iae);
        }
    }

    protected void checkAclPermission(Authorizable values, Object command, String[] acls) throws CommandException {
    }

    private static class CommandEntry
    implements Iterable<CommandEntry> {
        ImmutableSortedMap<String, CommandEntry> _hash = ImmutableSortedMap.of();
        final String _name;
        final Method[] _method = new Method[2];
        final int[] _minArgs = new int[2];
        final int[] _maxArgs = new int[2];
        final Object[] _listener = new Object[5];
        Field _fullHelp;
        Field _helpHint;
        Field _acls;

        CommandEntry(String com) {
            this._name = com;
        }

        String getName() {
            return this._name;
        }

        void setMethod(int methodType, Object commandListener, Method m, int mn, int mx) {
            if (this.hasCommand()) {
                this.clearFullHelp();
                this.clearHelpHint();
                this.clearACLS();
            }
            this._method[methodType] = m;
            this._minArgs[methodType] = mn;
            this._maxArgs[methodType] = mx;
            this._listener[methodType] = commandListener;
        }

        Method getMethod(int type) {
            return this._method[type];
        }

        Object getListener(int type) {
            return this._listener[type];
        }

        int getMinArgs(int type) {
            return this._minArgs[type];
        }

        int getMaxArgs(int type) {
            return this._maxArgs[type];
        }

        boolean hasCommand(int type) {
            return this._method[type] != null;
        }

        boolean hasCommand() {
            return this.hasCommand(0) || this.hasCommand(1);
        }

        void clearFullHelp() {
            this._listener[2] = null;
            this._fullHelp = null;
        }

        void clearHelpHint() {
            this._listener[3] = null;
            this._helpHint = null;
        }

        void clearACLS() {
            this._listener[4] = null;
            this._acls = null;
        }

        void setFullHelp(Object commandListener, Field f) {
            this._fullHelp = f;
            this._listener[2] = commandListener;
        }

        void setHelpHint(Object commandListener, Field f) {
            this._helpHint = f;
            this._listener[3] = commandListener;
        }

        void setACLS(Object commandListener, Field f) {
            this._acls = f;
            this._listener[4] = commandListener;
        }

        Field getACLS() {
            return this._acls;
        }

        Field getFullHelp() {
            return this._fullHelp;
        }

        Field getHelpHint() {
            return this._helpHint;
        }

        boolean checkArgs(int a) {
            return a >= this._minArgs[0] && a <= this._maxArgs[0];
        }

        String getArgs() {
            return "" + this._minArgs[0] + "<x<" + this._maxArgs[0] + "|" + "" + this._minArgs[1] + "<x<" + this._maxArgs[1];
        }

        String getMethodString() {
            return "" + this._method[0] + "|" + this._method[1];
        }

        void put(String str, CommandEntry e) {
            this._hash = ImmutableSortedMap.naturalOrder().putAll(this._hash).put((Object)str, (Object)e).build();
        }

        @Override
        public Iterator<CommandEntry> iterator() {
            return this._hash.values().iterator();
        }

        CommandEntry get(String str) {
            return (CommandEntry)this._hash.get((Object)str);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry : ").append(this.getName());
            for (String key : this._hash.keySet()) {
                sb.append(" -> ").append(key).append("\n");
            }
            return sb.toString();
        }
    }
}

