/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.ClassDataProvider;
import dmg.util.ClassLoaderA;
import java.io.File;

public class ClassLoaderFactory {
    private File _dir = null;
    private ClassDataProvider _provider = null;

    public ClassLoaderFactory() {
    }

    public ClassLoaderFactory(ClassDataProvider dataProvider) {
        this._provider = dataProvider;
    }

    public ClassLoaderFactory(String dir) {
        this._dir = new File(dir);
        if (!this._dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory : " + this._dir);
        }
    }

    public Class loadClass(String className) {
        ClassLoaderA loader = null;
        if (this._dir != null) {
            loader = new ClassLoaderA(this._dir);
        } else if (this._provider != null) {
            loader = new ClassLoaderA(this._provider);
        } else {
            throw new IllegalArgumentException("Class Load Provider not set");
        }
        return loader.loadClass(className);
    }

    public Class loadClass(String className, File dir) {
        ClassLoaderA loader = new ClassLoaderA(dir);
        return loader.loadClass(className);
    }

    public Class loadClass(String className, ClassDataProvider dataProvider) {
        ClassLoaderA loader = new ClassLoaderA(dataProvider);
        return loader.loadClass(className);
    }

    public String toString() {
        return this._dir != null ? this._dir.toString() : "Call By Call";
    }
}

