/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.BufferDescriptor;
import dmg.util.BufferScheduler;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferSchedulerTest
implements Runnable {
    private BufferScheduler _scheduler;
    private Thread _consumerThread;
    private Thread _producerThread;
    private byte[] _inBuffer;
    private byte[] _outBuffer;
    private InputStream _inFile;
    private OutputStream _outFile;
    private int _sleepTime = 1000;
    private int _maxProducerCount = 0;
    private int _bufferSize;
    private int _nob;
    private String _mode;
    private static final String USAGE = "Usage : ... <numOfBuffers> <sizeOfBuffers>";

    public BufferSchedulerTest(String[] args) throws Exception {
        this._nob = new Integer(args[0]);
        this._bufferSize = new Integer(args[1]);
        this._mode = args[2];
        this._scheduler = new BufferScheduler(this._nob, this._bufferSize);
        this._consumerThread = new Thread(this);
        this._producerThread = new Thread(this);
        this._inBuffer = new byte[this._bufferSize];
        this._outBuffer = new byte[this._bufferSize];
        if (this._mode.equals("memory")) {
            if (args.length < 4) {
                throw new IllegalArgumentException("");
            }
            this._maxProducerCount = new Integer(args[3]);
        } else if (this._mode.equals("filecopy")) {
            if (args.length < 5) {
                throw new IllegalArgumentException("");
            }
            this._inFile = new FileInputStream(args[3]);
            this._outFile = new FileOutputStream(args[4]);
        }
        this._consumerThread.start();
        this._producerThread.start();
    }

    @Override
    public void run() {
        if (this._mode.equals("memory")) {
            this.runMemory();
        } else if (this._mode.equals("filecopy")) {
            this.runFilecopy();
        }
    }

    public void runFilecopy() {
        try {
            if (Thread.currentThread() == this._consumerThread) {
                BufferDescriptor b;
                long startTime = System.currentTimeMillis();
                while (true) {
                    int size;
                    if ((size = (b = this._scheduler.getFullBuffer()).getUsable()) < 0) break;
                    byte[] base = b.getBase();
                    this._outFile.write(base, 0, b.getUsable());
                    this._scheduler.release(b);
                }
                this._scheduler.release(b);
                long diff = System.currentTimeMillis() - startTime;
                System.out.println("Consumer : " + diff + " msec ");
                System.out.println("" + this._scheduler);
                this._outFile.close();
            } else if (Thread.currentThread() == this._producerThread) {
                int inbytes;
                long startTime = System.currentTimeMillis();
                do {
                    BufferDescriptor b = this._scheduler.getEmptyBuffer();
                    byte[] base = b.getBase();
                    inbytes = this._inFile.read(base, 0, base.length);
                    b.setUsable(inbytes);
                    this._scheduler.release(b);
                } while (inbytes >= 0);
                long diff = System.currentTimeMillis() - startTime;
                System.out.println("Producer : " + diff + " msec ");
                this._inFile.close();
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }

    public void runMemory() {
        try {
            if (Thread.currentThread() == this._consumerThread) {
                BufferDescriptor b;
                long startTime = System.currentTimeMillis();
                while (true) {
                    int size;
                    if ((size = (b = this._scheduler.getFullBuffer()).getUsable()) < 0) break;
                    byte[] base = b.getBase();
                    System.arraycopy(base, 0, this._outBuffer, 0, size);
                    this._scheduler.release(b);
                }
                this._scheduler.release(b);
                long diff = System.currentTimeMillis() - startTime;
                System.out.println("Consumer : " + diff + " msec ");
                System.out.println("" + this._scheduler);
            } else if (Thread.currentThread() == this._producerThread) {
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < this._maxProducerCount; ++i) {
                    BufferDescriptor b = this._scheduler.getEmptyBuffer();
                    byte[] base = b.getBase();
                    System.arraycopy(this._inBuffer, 0, base, 0, this._inBuffer.length);
                    b.setUsable(this._inBuffer.length);
                    this._scheduler.release(b);
                }
                BufferDescriptor b = this._scheduler.getEmptyBuffer();
                b.setUsable(-1);
                this._scheduler.release(b);
                long diff = System.currentTimeMillis() - startTime;
                System.out.println("Producer : " + diff + " msec ");
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage : ... <numOfBuffers> <sizeOfBuffers>memory <producerCount>");
            System.out.println("Usage : ... <numOfBuffers> <sizeOfBuffers>filecopy <in> <out>");
            System.exit(3);
        }
        try {
            new BufferSchedulerTest(args);
        }
        catch (IllegalArgumentException ae) {
            System.out.println("Usage : ... <numOfBuffers> <sizeOfBuffers>memory <producerCount>");
            System.out.println("Usage : ... <numOfBuffers> <sizeOfBuffers>filecopy <in> <out>");
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }
}

