/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.idea;

import dmg.security.cipher.EncryptionKey;

public class IdeaEncryptionKey
implements EncryptionKey {
    byte[] _key = new byte[16];
    String[] _domainList = null;
    private static final char[] _byteToChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public IdeaEncryptionKey(String keyString) throws NumberFormatException {
        this(null, keyString);
    }

    public IdeaEncryptionKey(byte[] key) throws NumberFormatException {
        this._IdeaEncryptionKey(null, key);
    }

    public IdeaEncryptionKey(String[] domainList, String keyString) throws NumberFormatException {
        if (keyString == null || keyString.length() != 32) {
            throw new NumberFormatException("KeyLength != IdeaKeyLength(16)");
        }
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(this._byteFromChar(keyString.charAt(2 * i)) << 4 | this._byteFromChar(keyString.charAt(2 * i + 1)) & 0xF);
        }
        this._IdeaEncryptionKey(domainList, key);
    }

    private void _IdeaEncryptionKey(String[] domainList, byte[] key) throws NumberFormatException {
        if (key == null || key.length != 16) {
            throw new NumberFormatException("KeyLength != IdeaKeyLength(16)");
        }
        System.arraycopy(key, 0, this._key, 0, 16);
        this._domainList = new String[domainList.length];
        for (int i = 0; i < domainList.length; ++i) {
            this._domainList[i] = domainList[i];
        }
    }

    @Override
    public String[] getDomainList() {
        return this._domainList;
    }

    public byte[] getBytes() {
        return this._key;
    }

    @Override
    public String getKeyType() {
        return "idea";
    }

    @Override
    public String getKeyMode() {
        return "shared";
    }

    public String getString() {
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            sb.append("" + _byteToChar[this._key[i] >>> 4 & 0xF] + _byteToChar[this._key[i] & 0xF]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ---- Idea Shared Key --------\n");
        sb.append(" Key     = " + this.getString() + "\n");
        if (this._domainList != null) {
            sb.append(" Domains = ");
            for (int i = 0; i < this._domainList.length; ++i) {
                sb.append(this._domainList[i] + " ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private byte _byteFromChar(char c) throws NumberFormatException {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new NumberFormatException("None Hex in key string");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.exit(4);
        }
        IdeaEncryptionKey key = new IdeaEncryptionKey(args[0]);
        System.out.println(" Key Type : " + key.getKeyType());
        System.out.println(" Key vale : " + key);
    }
}

