/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.des;

import dmg.security.cipher.BlockCipher;

public class Jdes
implements BlockCipher {
    private static byte[] bK_C;
    private static byte[] bK_D;
    private static byte[] preshift;
    private static byte[] bCD_KS;
    private static byte[] P;
    private static byte[][] S;
    private static byte[] St;
    private static int[][] wC_K4;
    private static int[][] wC_K3;
    private static int[][] wD_K4;
    private static int[][] wD_K3;
    private static int[][] hKS_C4;
    private static int[][] lKS_D4;
    private static int[] wL_I8;
    private static int[] wO_L4;
    private static int[][] wPS;
    private long[][] _keySchedule;
    private byte[] _keyBytes;
    static long[] _x1;
    static long[] _x2;
    static long[] _x3;
    static long[] _x4;
    static long[] _x5;
    static long[] _x6;
    static long[] _x7;
    static long[] _x8;
    static long[][] _x;

    private void fsetkey(byte[] key, long[][] ks) {
        int i;
        int C = 0;
        int D = 0;
        for (i = 0; i < 8; ++i) {
            int v = key[i] >>> 1;
            v = v < 0 ? 256 + v : v;
            C |= wC_K4[i][v >> 3 & 0xF] | wC_K3[i][v & 7];
            D |= wD_K4[i][v >> 3 & 0xF] | wD_K3[i][v & 7];
        }
        for (i = 0; i < 16; ++i) {
            C <<= preshift[i];
            C = C >> 28 & 3 | C & 0xFFFFFFF;
            ks[i][1] = hKS_C4[6][C & 0xF] | hKS_C4[5][C >> 4 & 0xF] | hKS_C4[4][C >> 8 & 0xF] | hKS_C4[3][C >> 12 & 0xF] | hKS_C4[2][C >> 16 & 0xF] | hKS_C4[1][C >> 20 & 0xF] | hKS_C4[0][C >> 24 & 0xF];
            D <<= preshift[i];
            D = D >> 28 & 3 | D & 0xFFFFFFF;
            ks[i][0] = lKS_D4[6][D & 0xF] | lKS_D4[5][D >> 4 & 0xF] | lKS_D4[4][D >> 8 & 0xF] | lKS_D4[3][D >> 12 & 0xF] | lKS_D4[2][D >> 16 & 0xF] | lKS_D4[1][D >> 20 & 0xF] | lKS_D4[0][D >> 24 & 0xF];
        }
    }

    public static void say(String str) {
        System.out.println(str);
    }

    private void fencrypt(byte[] block, boolean decrypt, long[][] ks) {
        this.fencrypt(block, 0, block, 0, decrypt, ks);
    }

    private void fencrypt(byte[] block, int blockOff, byte[] out, int outOff, boolean decrypt, long[][] ks) {
        int i;
        long R = 0L;
        long L = 0L;
        for (i = 7 + blockOff; i >= blockOff; --i) {
            int v = block[i];
            v = v < 0 ? 256 + v : v;
            L = (long)wL_I8[v & 0x55] | L << 1;
            R = (long)wL_I8[v >> 1 & 0x55] | R << 1;
        }
        R &= 0xFFFFFFFFL;
        L &= 0xFFFFFFFFL;
        long[] ksp = decrypt ? ks[15] : ks[0];
        for (i = 15; i >= 0; --i) {
            ksp = decrypt ? ks[i] : ks[15 - i];
            long tR = R >> 15 | R << 17;
            long k = ksp[1];
            L ^= (long)(wPS[0][(int)(tR >>> 12 ^ k >>> 24) & 0x3F] | wPS[1][(int)(tR >>> 8 ^ k >>> 16) & 0x3F] | wPS[2][(int)(tR >>> 4 ^ k >>> 8) & 0x3F] | wPS[3][(int)(tR ^ k) & 0x3F]);
            k = ksp[0];
            L ^= (long)(wPS[4][(int)(R >>> 11 ^ k >>> 24) & 0x3F] | wPS[5][(int)(R >>> 7 ^ k >>> 16) & 0x3F] | wPS[6][(int)(R >>> 3 ^ k >>> 8) & 0x3F] | wPS[7][(int)(tR >>> 16 ^ k) & 0x3F]);
            tR = L;
            L = R & 0xFFFFFFFFL;
            R = tR & 0xFFFFFFFFL;
        }
        long t = wO_L4[(int)(L >> 0) & 0xF] << 1 | wO_L4[(int)(R >> 0) & 0xF] | (wO_L4[(int)(L >> 8) & 0xF] << 1 | wO_L4[(int)(R >> 8) & 0xF] | (wO_L4[(int)(L >> 16) & 0xF] << 1 | wO_L4[(int)(R >> 16) & 0xF] | (wO_L4[(int)(L >> 24) & 0xF] << 1 | wO_L4[(int)(R >> 24) & 0xF]) << 2) << 2) << 2;
        R = wO_L4[(int)(L >> 4) & 0xF] << 1 | wO_L4[(int)(R >> 4) & 0xF] | (wO_L4[(int)(L >> 12) & 0xF] << 1 | wO_L4[(int)(R >> 12) & 0xF] | (wO_L4[(int)(L >> 20) & 0xF] << 1 | wO_L4[(int)(R >> 20) & 0xF] | (wO_L4[(int)(L >> 28) & 0xF] << 1 | wO_L4[(int)(R >> 28) & 0xF]) << 2) << 2) << 2;
        L = t & 0xFFFFFFFFL;
        t = R & 0xFFFFFFFFL;
        long lt = t & 0xFFL;
        out[outOff + 7] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = (t >>= 8) & 0xFFL;
        out[outOff + 6] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = (t >>= 8) & 0xFFL;
        out[outOff + 5] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = t >> 8 & 0xFFL;
        out[outOff + 4] = (byte)(lt > 127L ? lt - 256L : lt);
        t = L;
        lt = t & 0xFFL;
        out[outOff + 3] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = (t >>= 8) & 0xFFL;
        out[outOff + 2] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = (t >>= 8) & 0xFFL;
        out[outOff + 1] = (byte)(lt > 127L ? lt - 256L : lt);
        lt = t >> 8 & 0xFFL;
        out[outOff + 0] = (byte)(lt > 127L ? lt - 256L : lt);
    }

    public Jdes(byte[] key) {
        if (key.length < 8) {
            throw new IllegalArgumentException("key too short");
        }
        this._keyBytes = new byte[8];
        System.arraycopy(key, 0, this._keyBytes, 0, 8);
        this._keySchedule = this.getKeySchedule(key);
    }

    private long[][] getKeySchedule(byte[] key) {
        long[][] ks = new long[16][];
        for (int i = 0; i < 16; ++i) {
            ks[i] = new long[2];
        }
        this.fsetkey(key, ks);
        return ks;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    public byte[] getKeyBytes() {
        return this._keyBytes;
    }

    @Override
    public void encrypt(byte[] inBlock, int inOff, byte[] outBlock, int outOff) {
        this.fencrypt(inBlock, inOff, outBlock, outOff, false, this._keySchedule);
    }

    @Override
    public void decrypt(byte[] inBlock, int inOff, byte[] outBlock, int outOff) {
        this.fencrypt(inBlock, inOff, outBlock, outOff, true, this._keySchedule);
    }

    public void encrypt(byte[] inBlock, byte[] outBlock) {
        this.fencrypt(inBlock, 0, outBlock, 0, false, this._keySchedule);
    }

    public void decrypt(byte[] inBlock, byte[] outBlock) {
        this.fencrypt(inBlock, 0, outBlock, 0, true, this._keySchedule);
    }

    public void encrypt(byte[] block) {
        this.fencrypt(block, 0, block, 0, false, this._keySchedule);
    }

    public void decrypt(byte[] block) {
        this.fencrypt(block, 0, block, 0, true, this._keySchedule);
    }

    private void printKeySchedule() {
        byte[] out = new byte[8];
        for (int i = 0; i < 16; ++i) {
            Jdes.twoIntsToEightBytes(this._keySchedule[i][1], this._keySchedule[i][0], out);
            System.out.println("keys[" + i + "]-> " + Jdes.byteToHexString(out));
        }
    }

    public static void main(String[] args) {
        byte[] out = new byte[8];
        byte[] key = new byte[8];
        byte[] in = new byte[8];
        for (int i = 0; i < _x.length; ++i) {
            long[] ar = _x[i];
            boolean decrypt = ar[0] > 0L;
            Jdes.twoIntsToEightBytes(ar[1], ar[2], key);
            Jdes.twoIntsToEightBytes(ar[3], ar[4], in);
            Jdes.twoIntsToEightBytes(ar[5], ar[6], out);
            Jdes des = new Jdes(key);
            System.out.println("\n\n Key " + Jdes.byteToHexString(key));
            System.out.println(" In  " + Jdes.byteToHexString(in));
            if (decrypt) {
                des.decrypt(in);
            } else {
                des.encrypt(in);
            }
            System.out.println(" Out " + Jdes.byteToHexString(in));
            System.out.println(" Exp " + Jdes.byteToHexString(out));
        }
    }

    private static void twoIntsToEightBytes(long high, long low, byte[] out) {
        int s = 24;
        int i = 0;
        while (i < 4) {
            out[i] = (byte)(high >>> s & 0xFFL);
            ++i;
            s -= 8;
        }
        s = 24;
        i = 4;
        while (i < 8) {
            out[i] = (byte)(low >>> s & 0xFFL);
            ++i;
            s -= 8;
        }
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length + 1);
        for (int i = 0; i < b.length; ++i) {
            sb.append(Jdes.byteToHexString(b[i])).append(" ");
        }
        return sb.toString();
    }

    static {
        int j;
        int i;
        int i2;
        bK_C = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36};
        bK_D = new byte[]{63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        preshift = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
        bCD_KS = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        P = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        St = new byte[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13, 15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9, 10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12, 7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14, 2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3, 12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13, 4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12, 13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};
        S = new byte[8][];
        for (i2 = 0; i2 < 8; ++i2) {
            Jdes.S[i2] = new byte[64];
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 64; ++j2) {
                Jdes.S[i2][j2] = St[i2 * 64 + j2];
            }
        }
        wC_K4 = new int[8][];
        wC_K3 = new int[8][];
        wD_K4 = new int[8][];
        wD_K3 = new int[8][];
        hKS_C4 = new int[7][];
        lKS_D4 = new int[7][];
        wPS = new int[8][];
        wL_I8 = new int[86];
        wO_L4 = new int[16];
        for (i2 = 0; i2 < 8; ++i2) {
            Jdes.wC_K4[i2] = new int[16];
            Jdes.wC_K3[i2] = new int[8];
            Jdes.wD_K4[i2] = new int[16];
            Jdes.wD_K3[i2] = new int[8];
            Jdes.wPS[i2] = new int[64];
        }
        for (i2 = 0; i2 < 7; ++i2) {
            Jdes.hKS_C4[i2] = new int[16];
            Jdes.lKS_D4[i2] = new int[16];
        }
        int[] wC_K = new int[64];
        int[] wD_K = new int[64];
        int[] hKS_C = new int[28];
        int[] lKS_D = new int[28];
        int[] Smap = new int[64];
        int[] wP = new int[32];
        int v = 1;
        int j3 = 28;
        while (--j3 >= 0) {
            int n = v;
            wD_K[Jdes.bK_D[j3] - 1] = n;
            wC_K[Jdes.bK_C[j3] - 1] = n;
            v += v;
        }
        for (i = 0; i < 64; ++i) {
            int t = 8 >> (i & 3);
            for (int j4 = 0; j4 < 16; ++j4) {
                if ((j4 & t) == 0) continue;
                int[] nArray = wC_K4[i >> 3];
                int n = j4;
                nArray[n] = nArray[n] | wC_K[i];
                int[] nArray2 = wD_K4[i >> 3];
                int n2 = j4;
                nArray2[n2] = nArray2[n2] | wD_K[i];
                if (j4 >= 8) continue;
                int[] nArray3 = wC_K3[i >> 3];
                int n3 = j4;
                nArray3[n3] = nArray3[n3] | wC_K[i + 3];
                int[] nArray4 = wD_K3[i >> 3];
                int n4 = j4;
                nArray4[n4] = nArray4[n4] | wD_K[i + 3];
            }
            if (t != 1) continue;
            i += 4;
        }
        v = 1;
        i = 24;
        while ((i -= 6) >= 0) {
            j = i + 5;
            do {
                int n = v;
                lKS_D[Jdes.bCD_KS[j + 24] - 28 - 1] = n;
                hKS_C[Jdes.bCD_KS[j] - 1] = n;
                v += v;
            } while (--j >= i);
            v <<= 2;
        }
        for (i = 0; i < 28; ++i) {
            v = 8 >> (i & 3);
            for (j = 0; j < 16; ++j) {
                if ((j & v) == 0) continue;
                int[] nArray = hKS_C4[i >> 2];
                int n = j;
                nArray[n] = nArray[n] | hKS_C[i];
                int[] nArray5 = lKS_D4[i >> 2];
                int n5 = j;
                nArray5[n5] = nArray5[n5] | lKS_D[i];
            }
        }
        for (i = 0; i <= 85; ++i) {
            v = 0;
            if ((i & 0x40) != 0) {
                v = 0x1000000;
            }
            if ((i & 0x10) != 0) {
                v |= 0x10000;
            }
            if ((i & 4) != 0) {
                v |= 0x100;
            }
            if ((i & 1) != 0) {
                v |= 1;
            }
            Jdes.wL_I8[i] = v;
        }
        for (i = 0; i < 16; ++i) {
            v = 0;
            if ((i & 1) != 0) {
                v = 0x1000000;
            }
            if ((i & 2) != 0) {
                v |= 0x10000;
            }
            if ((i & 4) != 0) {
                v |= 0x100;
            }
            if ((i & 8) != 0) {
                v |= 1;
            }
            Jdes.wO_L4[i] = v;
        }
        for (i = 0; i < 64; ++i) {
            Smap[i] = i & 0x20 | (i & 1) << 4 | (i & 0x1E) >> 1;
        }
        v = 1;
        i = 32;
        while (--i >= 0) {
            wP[Jdes.P[i] - 1] = v;
            v += v;
        }
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 64; ++j) {
                int t = S[i][Smap[j]];
                for (int k = 0; k < 4; ++k) {
                    if ((t & 8) != 0) {
                        int[] nArray = wPS[i];
                        int n = j;
                        nArray[n] = nArray[n] | wP[4 * i + k];
                    }
                    t += t;
                }
            }
        }
        _x1 = new long[]{0L, 0L, 0L, 0L, 0L, -1935258135L, -1045355609L};
        _x2 = new long[]{0L, 0x11111111L, 0x11111111L, 0L, 0L, -2099169691L, -1268625931L};
        _x3 = new long[]{0L, 0x11111111L, 0x11111111L, 0L, 0L, -2099169691L, -1268625931L};
        _x4 = new long[]{1L, 306733640L, 1648910920L, -253635901L, -1264216441L, -547783153L, -2063754929L};
        _x5 = new long[]{0L, 464290055L, 1782121517L, -2128084518L, -873889533L, -662160596L, 1249665501L};
        _x6 = new long[]{1L, 464290055L, 1782121517L, -662160596L, 1249665501L, -2128084518L, -873889533L};
        _x7 = new long[]{1L, -19088744L, 1985229328L, -1500717911L, 210772473L, 0L, 0L};
        _x8 = new long[]{0L, -324508640L, 324508639L, 19088743L, -1985229329L, -1472099756L, -6839035L};
        _x = new long[][]{_x1, _x2, _x3, _x4, _x5, _x6, _x7, _x8};
    }
}

