/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.blowfish;

import dmg.security.cipher.BlockCipher;

public class Jblowfish
implements BlockCipher {
    private static final long[] pBox = new long[]{608135816L, -2052912941L, 320440878L, 57701188L, -1542899678L, 698298832L, 137296536L, -330404727L, 1160258022L, 953160567L, -1101764913L, 887688300L, -1062458953L, -914599715L, 1065670069L, -1253635817L, -1843997223L, -1988494565L};
    private static final long[] sBox = new long[]{-785314906L, -1730169428L, 805139163L, -803545161L, -1193168915L, 1780907670L, -1166241723L, -248741991L, 614570311L, -1282315017L, 134345442L, -2054226922L, 1667834072L, 1901547113L, -1537671517L, -191677058L, 227898511L, 1921955416L, 1904987480L, -2112533778L, 2069144605L, -1034266187L, -1674521287L, 720527379L, -976113629L, 677414384L, -901678824L, -1193592593L, -1904616272L, 1614419982L, 1822297739L, -1340175810L, -686458943L, -1120842969L, 2024746970L, 1432378464L, -430627341L, -1437226092L, 1464375394L, 1676153920L, 1439316330L, 715854006L, -1261675468L, 289532110L, -1588296017L, 2087905683L, -1276242927L, 1668267050L, 732546397L, 1947742710L, -832815594L, -1685613794L, -1344882125L, 1814351708L, 2050118529L, 680887927L, 999245976L, 1800124847L, -994056165L, 1713906067L, 1641548236L, -81679983L, 1216130144L, 1575780402L, -276538019L, -377129551L, -601480446L, -345695352L, 596196993L, -745100091L, 258830323L, -2081144263L, 772490370L, -1534844924L, 1774776394L, -1642095778L, 566650946L, -152474470L, 1728879713L, -1412200208L, 1783734482L, -665571480L, -1777359064L, -1420741725L, 1861159788L, 326777828L, -1170476976L, 2130389656L, -1578015459L, 967770486L, 1724537150L, -2109534584L, -1930525159L, 1164943284L, 2105845187L, 998989502L, -529566248L, -2050940813L, 1075463327L, 1455516326L, 1322494562L, 910128902L, 469688178L, 1117454909L, 936433444L, -804646328L, -619713837L, 1240580251L, 122909385L, -2137449605L, 634681816L, -152510729L, -469872614L, -1233564613L, -1754472259L, 79693498L, -1045868618L, 1084186820L, 1583128258L, 426386531L, 1761308591L, 1047286709L, 322548459L, 995290223L, 1845252383L, -1691314900L, -863943356L, -1352745719L, -1092366332L, -567063811L, 1712269319L, 422464435L, -1060394921L, 1170764815L, -771006663L, -1177289765L, 1434042557L, 442511882L, -694091578L, 1076654713L, 1738483198L, -81812532L, -1901729288L, -617471240L, 1014306527L, -43947243L, 793779912L, -1392160085L, 842905082L, -48003232L, 1395751752L, 1040244610L, -1638115397L, -898659168L, 445077038L, -552113701L, -717051658L, 679411651L, -1402522938L, -1940957837L, 1767581616L, -1144366904L, -503340195L, -1192226400L, 284835224L, -48135240L, 1258075500L, 768725851L, -1705778055L, -1225243291L, -762426948L, 1274779536L, -505548070L, -1530167757L, 1660621633L, -823867672L, -283063590L, 913787905L, -797008130L, 737222580L, -1780753843L, -1366257256L, -357724559L, 1804850592L, -795946544L, -1345903136L, -1908647121L, -1904896841L, -1879645445L, -233690268L, -2004305902L, -1878134756L, 1336762016L, 1754252060L, -774901359L, -1280786003L, 791618072L, -1106372745L, -361419266L, -1962795103L, -442446833L, -1250986776L, 413987798L, -829824359L, -1264037920L, -49028937L, 2093235073L, -760370983L, 375366246L, -2137688315L, -1815317740L, 555357303L, -424861595L, 2008414854L, -950779147L, -73583153L, -338841844L, 2067696032L, -700376109L, -1373733303L, 2428461L, 544322398L, 577241275L, 1471733935L, 610547355L, -267798242L, 1432588573L, 1507829418L, 2025931657L, -648391809L, 545086370L, 48609733L, -2094660746L, 1653985193L, 298326376L, 1316178497L, -1287180854L, 2064951626L, 458293330L, -1705826027L, -703637697L, -1130641692L, 727753846L, -2115603456L, 146436021L, 1461446943L, -224990101L, 705550613L, -1235000031L, -407242314L, -13368018L, -981117340L, 1404054877L, -1449160799L, 146425753L, 1854211946L, 1266315497L, -1246549692L, -613086930L, -1004984797L, -1385257296L, 1235738493L, -1662099272L, -1880247706L, -324367247L, 1771706367L, 1449415276L, -1028546847L, 422970021L, 1963543593L, -1604775104L, -468174274L, 1062508698L, 1531092325L, 1804592342L, -1711849514L, -1580033017L, -269995787L, 1294809318L, -265986623L, 1289560198L, -2072974554L, 1669523910L, 35572830L, 157838143L, 1052438473L, 1016535060L, 1802137761L, 1753167236L, 1386275462L, -1214491899L, -1437595849L, 1040679964L, 2145300060L, -1904392980L, 1461121720L, -1338320329L, -263189491L, -266592508L, 33600511L, -1374882534L, 1018524850L, 629373528L, -603381315L, -779021319L, 2091462646L, -1808644237L, 586499841L, 988145025L, 935516892L, -927631820L, -1695294041L, -1455136442L, 265290510L, -322386114L, -1535828415L, -499593831L, 1005194799L, 847297441L, 406762289L, 1314163512L, 1332590856L, 1866599683L, -167115585L, 750260880L, 613907577L, 1450815602L, -1129346641L, -560302305L, -644675568L, -1282691566L, -590397650L, 1427272223L, 778793252L, 1343938022L, -1618686585L, 2052605720L, 1946737175L, -1130390852L, -380928628L, -327488454L, -612033030L, 1661551462L, -1000029230L, -283371449L, 840292616L, -582796489L, 616741398L, 312560963L, 711312465L, 1351876610L, 322626781L, 1910503582L, 271666773L, -2119403562L, 1594956187L, 70604529L, -677132437L, 1007753275L, 1495573769L, -225450259L, -1745748998L, -1631928532L, 504708206L, -2031925904L, -353800271L, -2045878774L, 1514023603L, 1998579484L, 1312622330L, 694541497L, -1712906993L, -2143385130L, 1382467621L, 776784248L, -1676627094L, -971698502L, -1797068168L, -1510196141L, 503983604L, -218673497L, 907881277L, 423175695L, 432175456L, 1378068232L, -149744970L, -340918674L, -356311194L, -474200683L, -1501837181L, -1317062703L, 26017576L, -1020076561L, -1100195163L, 1700274565L, 1756076034L, -288447217L, -617638597L, 720338349L, 1533947780L, 354530856L, 688349552L, -321042571L, 1637815568L, 332179504L, -345916010L, 53804574L, -1442618417L, -1250730864L, 1282449977L, -711025141L, -877994476L, -288586052L, 1617046695L, -1666491221L, -1292663698L, 1686838959L, 431878346L, -1608291911L, 1700445008L, 1080580658L, 1009431731L, 832498133L, -1071531785L, -1688990951L, -2023776103L, -1778935426L, 1648197032L, -130578278L, -1746719369L, 300782431L, 375919233L, 238389289L, -941219882L, -1763778655L, 2019080857L, 1475708069L, 455242339L, -1685863425L, 448939670L, -843904277L, 1395535956L, -1881585436L, 1841049896L, 1491858159L, 885456874L, -30872223L, -293847949L, 1565136089L, -396052509L, 1108368660L, 540939232L, 1173283510L, -1549095958L, -613658859L, -87339056L, -951913406L, -278217803L, 1699691293L, 1103962373L, -669091426L, -2038084153L, -464828566L, 1031889488L, -815619598L, 1535977030L, -58162272L, -1043876189L, 2132092099L, 1774941330L, 1199868427L, 1452454533L, 157007616L, -1390851939L, 342012276L, 595725824L, 1480756522L, 206960106L, 497939518L, 591360097L, 863170706L, -1919713727L, -698356495L, 1814182875L, 2094937945L, -873565088L, 1082520231L, -831049106L, -1509457788L, 435703966L, -386934699L, 1641649973L, -1452693590L, -989067582L, 1510255612L, -2146710820L, -1639679442L, -1018874748L, -36346107L, 236887753L, -613164077L, 274041037L, 1734335097L, -479771840L, -976997275L, 1899903192L, 1026095262L, -244449504L, 356393447L, -1884275382L, -421290197L, -612127241L, -381855128L, -1803468553L, -162781668L, -1805047500L, 1091903735L, 1979897079L, -1124832466L, -727580568L, -737663887L, 857797738L, 1136121015L, 1342202287L, 507115054L, -1759230650L, 337727348L, -1081374656L, 1301675037L, -1766485585L, 1895095763L, 1721773893L, -1078195732L, 62756741L, 2142006736L, 835421444L, -1762973773L, 1442658625L, -635090970L, -1412822374L, 676362277L, 1392781812L, 170690266L, -373920261L, 1759253602L, -683120384L, 1745797284L, 664899054L, 1329594018L, -393761396L, -1249058810L, 2062866102L, -1429332356L, -751345684L, -830954599L, 1080764994L, 553557557L, -638351943L, -298199125L, 991055499L, 499776247L, 1265440854L, 648242737L, -354183246L, 980351604L, -581221582L, 1749149687L, -898096901L, -83167922L, -654396521L, 1161844396L, -1169648345L, 0x55533A3AL, 545492359L, -26498633L, -795437749L, 1437099964L, -1592419752L, -861329053L, -1713251533L, -1507177898L, 1060185593L, 1593081372L, -1876348548L, -34019326L, 69676912L, -2135222948L, 86519011L, -1782508216L, -456757982L, 1220612927L, -955283748L, 133810670L, 1090789135L, 1078426020L, 1569222167L, 845107691L, -711212847L, -222510705L, 1091646820L, 628848692L, 1613405280L, -537335645L, 526609435L, 236106946L, 48312990L, -1352249391L, -892239595L, 1797494240L, 859738849L, 992217954L, -289490654L, -2051890674L, -424014439L, -562951028L, 765654824L, -804095931L, -1783130883L, 1685915746L, -405998096L, 1414112111L, -2021832454L, -1013056217L, -214004450L, 172450625L, -1724973196L, 980381355L, -185008841L, -1475158944L, -1578377736L, -1726226100L, -613520627L, -964995824L, 1835478071L, 660984891L, -590288892L, -248967737L, -872349789L, -1254551662L, 1762651403L, 1719377915L, -824476260L, -1601057013L, -652910941L, -1156370552L, 1364962596L, 2073328063L, 1983633131L, 926494387L, -871278215L, -2144935273L, -198299347L, 1749200295L, -966120645L, 309677260L, 2016342300L, 1779581495L, -1215147545L, 111262694L, 1274766160L, 443224088L, 298511866L, 1025883608L, -488520759L, 1145181785L, 168956806L, -653464466L, -710153686L, 1689216846L, -628709281L, -1094719096L, 1692713982L, -1648590761L, -252198778L, 1618508792L, 1610833997L, -771914938L, -164094032L, 2001055236L, -684262196L, -2092799181L, -266425487L, -1333771897L, 1006657119L, 2006996926L, -1108824540L, 1430667929L, -1084739999L, 1314452623L, -220332638L, -193663176L, -2021016126L, 1399257539L, -927756684L, -1267338667L, 1190975929L, 2062231137L, -1960976508L, -2073424263L, -1856006686L, 1181637006L, 548689776L, -1932175983L, -922558900L, -1190417183L, -1149106736L, 296247880L, 1970579870L, -1216407114L, -525738999L, 1714227617L, -1003338189L, -396747006L, 166772364L, 1251581989L, 493813264L, 448347421L, 195405023L, -1584991729L, 677966185L, -591930749L, 1463355134L, -1578971493L, 1338867538L, 1343315457L, -1492745222L, -1610435132L, 233230375L, -1694987225L, 2000651841L, -1017099258L, 1638401717L, -266896856L, -1057650976L, 6314154L, 819756386L, 300326615L, 590932579L, 1405279636L, -1027467724L, -1144263082L, -1866680610L, -335774303L, -833020554L, 1862657033L, 1266418056L, 963775037L, 2089974820L, -2031914401L, 1917689273L, 448879540L, -744572676L, -313240200L, 150775221L, -667058989L, 1303187396L, 508620638L, -1318983944L, -1568336679L, 1817252668L, 1876281319L, 1457606340L, 908771278L, -574175177L, -677760460L, -1838972398L, 1729034894L, 1080033504L, 976866871L, -738527793L, -1413318857L, 1522871579L, 1555064734L, 1336096578L, -746444992L, -1715692610L, -720269667L, -1089506539L, -701686658L, -956251013L, -1215554709L, 564236357L, -1301368386L, 1781952180L, 1464380207L, -1131123079L, -962365742L, 1699332808L, 1393555694L, 1183702653L, -713881059L, 1288719814L, 691649499L, -1447410096L, -1399511320L, -1101077756L, -1577396752L, 1781354906L, 1676643554L, -1702433246L, -1064713544L, 1126444790L, -1524759638L, -1661808476L, -2084544070L, -1679201715L, -1880812208L, -1167828010L, 673620729L, -1489356063L, 1269405062L, -279616791L, -953159725L, -145557542L, 1057255273L, 2012875353L, -2132498155L, -2018474495L, -1693849939L, 993977747L, -376373926L, -1640704105L, 753973209L, 36408145L, -1764381638L, 25011837L, -774947114L, 2088578344L, 530523599L, -1376601957L, 1524020338L, 1518925132L, -534139791L, -535190042L, 1202760957L, -309069157L, -388774771L, 674977740L, -120232407L, 2031300136L, 2019492241L, -311074731L, -141160892L, -472686964L, 352677332L, -1997247046L, 60907813L, 90501309L, -1007968747L, 1016092578L, -1759044884L, -1455814870L, 457141659L, 509813237L, -174299397L, 652014361L, 1966332200L, -1319764491L, 55981186L, -1967506245L, 676427537L, -1039476232L, -1412673177L, -861040033L, 1307055953L, 942726286L, 933058658L, -1826555503L, -361066302L, -79791154L, 1361170020L, 2001714738L, -1464409218L, -1020707514L, 1222529897L, 1679025792L, -1565652976L, -580013532L, 1770335741L, 151462246L, -1281735158L, 1682292957L, 1483529935L, 471910574L, 1539241949L, 458788160L, -858652289L, 1807016891L, -576558466L, 978976581L, 1043663428L, -1129001515L, 1927990952L, -94075717L, -1922690386L, -1086558393L, -761535389L, 1412390302L, -1362987237L, -162634896L, 1947078029L, -413461673L, -126740879L, -1353482915L, 1077988104L, 1320477388L, 886195818L, 18198404L, -508558296L, -1785185763L, 112762804L, -831610808L, 1866414978L, 891333506L, 18488651L, 661792760L, 1628790961L, -409780260L, -1153795797L, 876946877L, -1601685023L, 1372485963L, 791857591L, -1608533303L, -534984578L, -1127755274L, -822013501L, -1578587449L, 445679433L, -732971622L, -790962485L, -720709064L, 54117162L, -963561881L, -1913048708L, -525259953L, -140617289L, 1140177722L, -220915201L, 668550556L, -1080614356L, 367459370L, 261225585L, -1684794075L, -85617823L, -826893077L, -1029151655L, 314222801L, -1228863650L, -486184436L, 282218597L, -888953790L, -521376242L, 379116347L, 1285071038L, 846784868L, -1625320142L, -523005217L, -744475605L, -1989021154L, 453669953L, 1268987020L, -977374944L, -1015663912L, -550133875L, -1684459730L, -435458233L, 266596637L, -447948204L, 517658769L, -832407089L, -851542417L, 370717030L, -47440635L, -2070949179L, -151313767L, -182193321L, -1506642397L, -1817692879L, 1456262402L, -1393524382L, 1517677493L, 1846949527L, -1999473716L, -560569710L, -2118563376L, 1280348187L, 1908823572L, -423180355L, 846861322L, 1172426758L, -1007518822L, -911584259L, 1655181056L, -1155153950L, 901632758L, 1897031941L, -1308360158L, -1228157060L, -847864789L, 1393639104L, 373351379L, 950779232L, 625454576L, -1170726756L, -146354570L, 2007998917L, 544563296L, -2050228658L, -1964470824L, 2058025392L, 1291430526L, 424198748L, 50039436L, 29584100L, -689184263L, -1865090967L, -1503863136L, 1057563949L, -1039604065L, -1219600078L, -831004069L, 1469046755L, 985887462L};
    private byte[] _key;
    private long[] _S;
    private long[] _P;

    private void createKey() {
        int i;
        this._S = new long[sBox.length];
        this._P = new long[pBox.length];
        System.arraycopy(sBox, 0, this._S, 0, sBox.length);
        System.arraycopy(pBox, 0, this._P, 0, pBox.length);
        int keybytes = this._key.length;
        int j = 0;
        for (i = 0; i < 18; ++i) {
            long temp = ((long)this._key[j] & 0xFFL) << 24 | ((long)this._key[(j + 1) % keybytes] & 0xFFL) << 16 | ((long)this._key[(j + 2) % keybytes] & 0xFFL) << 8 | (long)this._key[(j + 3) % keybytes] & 0xFFL;
            this._P[i] = this._P[i] ^ temp;
            j = (j + 4) % keybytes;
        }
        long data_l = 0L;
        long data_r = 0L;
        long[] output = new long[2];
        for (i = 0; i < 18; i += 2) {
            this.blowfish_encrypt(data_l, data_r, output);
            data_l = output[0];
            data_r = output[1];
            this._P[i] = data_l;
            this._P[i + 1] = data_r;
        }
        for (i = 0; i < 4; ++i) {
            j = 0;
            int count = i * 256;
            while (j < 256) {
                this.blowfish_encrypt(data_l, data_r, output);
                data_l = output[0];
                data_r = output[1];
                this._S[count] = data_l;
                this._S[count + 1] = data_r;
                j += 2;
                count += 2;
            }
        }
    }

    @Override
    public void encrypt(byte[] in, int inOff, byte[] out, int outOff) {
        long[] d = new long[]{((long)in[inOff + 0] & 0xFFL) << 24 | ((long)in[inOff + 1] & 0xFFL) << 16 | ((long)in[inOff + 2] & 0xFFL) << 8 | ((long)in[inOff + 3] & 0xFFL) << 0, ((long)in[inOff + 4] & 0xFFL) << 24 | ((long)in[inOff + 5] & 0xFFL) << 16 | ((long)in[inOff + 6] & 0xFFL) << 8 | ((long)in[inOff + 7] & 0xFFL) << 0};
        long[] dout = new long[2];
        this.blowfish_encrypt(d[0], d[1], dout);
        out[outOff + 0] = (byte)(dout[0] >>> 24 & 0xFFL);
        out[outOff + 1] = (byte)(dout[0] >>> 16 & 0xFFL);
        out[outOff + 2] = (byte)(dout[0] >>> 8 & 0xFFL);
        out[outOff + 3] = (byte)(dout[0] >>> 0 & 0xFFL);
        out[outOff + 4] = (byte)(dout[1] >>> 24 & 0xFFL);
        out[outOff + 5] = (byte)(dout[1] >>> 16 & 0xFFL);
        out[outOff + 6] = (byte)(dout[1] >>> 8 & 0xFFL);
        out[outOff + 7] = (byte)(dout[1] >>> 0 & 0xFFL);
    }

    @Override
    public void decrypt(byte[] in, int inOff, byte[] out, int outOff) {
        long[] d = new long[]{((long)in[inOff + 0] & 0xFFL) << 24 | ((long)in[inOff + 1] & 0xFFL) << 16 | ((long)in[inOff + 2] & 0xFFL) << 8 | ((long)in[inOff + 3] & 0xFFL) << 0, ((long)in[inOff + 4] & 0xFFL) << 24 | ((long)in[inOff + 5] & 0xFFL) << 16 | ((long)in[inOff + 6] & 0xFFL) << 8 | ((long)in[inOff + 7] & 0xFFL) << 0};
        long[] dout = new long[2];
        this.blowfish_decrypt(d[0], d[1], dout);
        out[outOff + 0] = (byte)(dout[0] >>> 24 & 0xFFL);
        out[outOff + 1] = (byte)(dout[0] >>> 16 & 0xFFL);
        out[outOff + 2] = (byte)(dout[0] >>> 8 & 0xFFL);
        out[outOff + 3] = (byte)(dout[0] >>> 0 & 0xFFL);
        out[outOff + 4] = (byte)(dout[1] >>> 24 & 0xFFL);
        out[outOff + 5] = (byte)(dout[1] >>> 16 & 0xFFL);
        out[outOff + 6] = (byte)(dout[1] >>> 8 & 0xFFL);
        out[outOff + 7] = (byte)(dout[1] >>> 0 & 0xFFL);
    }

    private void blowfish_encrypt(long xl, long xr, long[] output) {
        long yl = xl;
        long yr = xr;
        long[] S = this._S;
        long[] P = this._P;
        yl ^= P[0];
        for (int i = 0; i < 16; i += 2) {
            yl ^= (S[(int)(0L + ((yr ^= (S[(int)(0L + (yl >> 24 & 0xFFL))] + S[(int)(256L + (yl >> 16 & 0xFFL))] ^ S[(int)(512L + (yl >> 8 & 0xFFL))]) + S[(int)(768L + (yl & 0xFFL))] ^ P[i + 1]) >> 24 & 0xFFL))] + S[(int)(256L + (yr >> 16 & 0xFFL))] ^ S[(int)(512L + (yr >> 8 & 0xFFL))]) + S[(int)(768L + (yr & 0xFFL))] ^ P[i + 2];
        }
        output[0] = yr ^= P[17];
        output[1] = yl;
    }

    private void blowfish_decrypt(long xl, long xr, long[] output) {
        long yl = xl;
        long yr = xr;
        long[] S = this._S;
        long[] P = this._P;
        yl ^= P[17];
        for (int i = 16; i > 0; i -= 2) {
            yl ^= (S[(int)(0L + ((yr ^= (S[(int)(0L + (yl >> 24 & 0xFFL))] + S[(int)(256L + (yl >> 16 & 0xFFL))] ^ S[(int)(512L + (yl >> 8 & 0xFFL))]) + S[(int)(768L + (yl & 0xFFL))] ^ P[i]) >> 24 & 0xFFL))] + S[(int)(256L + (yr >> 16 & 0xFFL))] ^ S[(int)(512L + (yr >> 8 & 0xFFL))]) + S[(int)(768L + (yr & 0xFFL))] ^ P[i - 1];
        }
        output[0] = yr ^= P[0];
        output[1] = yl;
    }

    public Jblowfish(byte[] key) {
        this._key = new byte[key.length];
        System.arraycopy(key, 0, this._key, 0, this._key.length);
        this.createKey();
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    public byte[] getKeyBytes() {
        byte[] out = new byte[this._key.length];
        System.arraycopy(this._key, 0, out, 0, this._key.length);
        return out;
    }
}

