/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.BlockCipher;
import dmg.security.cipher.StreamCipher;

public class StreamFromBlockCipher
implements StreamCipher {
    BlockCipher _generator;
    byte[] _vector;
    int _pointer = 0;
    int _blockLength = 0;
    int _mode = 0;
    private static final int MODE_CFB = 1;
    private static final int MODE_CBC = 2;
    private static final int MODE_CBC_EXP = 3;

    public StreamFromBlockCipher(BlockCipher generator, byte[] vector) {
        this._StreamFromBlockCipher(generator, vector, null);
    }

    public StreamFromBlockCipher(BlockCipher generator, byte[] vector, String mode) {
        this._StreamFromBlockCipher(generator, vector, mode);
    }

    public void _StreamFromBlockCipher(BlockCipher generator, byte[] vector, String mode) {
        int block;
        this._generator = generator;
        this._pointer = 0;
        this._blockLength = generator.getBlockLength();
        if (mode != null) {
            if (mode.equals("cfb")) {
                this._mode = 1;
            } else if (mode.equals("cbc")) {
                this._mode = 2;
            } else if (mode.equals("cbc-exp")) {
                this._mode = 3;
            } else {
                throw new IllegalArgumentException("Mode not supported : " + mode);
            }
        }
        if ((block = this._blockLength / 8) > vector.length) {
            throw new IllegalArgumentException("Cipher Block Length doesn't match vector length");
        }
        this._vector = new byte[block];
        System.arraycopy(vector, 0, this._vector, 0, block);
    }

    @Override
    public int getBlockLength() {
        return this._generator.getBlockLength();
    }

    @Override
    public byte[] getKeyBytes() {
        return this._generator.getKeyBytes();
    }

    @Override
    public void encrypt(byte[] inBlock, int inOff, byte[] outBlock, int outOff, int len) {
        switch (this._mode) {
            case 1: {
                this.encryptCFB(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            case 2: {
                this.encryptCBC(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            case 3: {
                this.encryptCBC_EXP(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            default: {
                throw new IllegalArgumentException("No Mode selected");
            }
        }
    }

    @Override
    public void decrypt(byte[] inBlock, int inOff, byte[] outBlock, int outOff, int len) {
        switch (this._mode) {
            case 1: {
                this.decryptCFB(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            case 2: {
                this.decryptCBC(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            case 3: {
                this.decryptCBC_EXP(inBlock, inOff, outBlock, outOff, len);
                break;
            }
            default: {
                throw new IllegalArgumentException("No Mode selected");
            }
        }
    }

    public void encryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this._generator.encrypt(in, inOff, out, outOff);
    }

    public void decryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this._generator.decrypt(in, inOff, out, outOff);
    }

    public void encryptCFB(byte[] in, int inOff, byte[] out, int outOff, int len) {
        for (int i = 0; i < len; ++i) {
            if (this._pointer == 0) {
                this._generator.encrypt(this._vector, 0, this._vector, 0);
            }
            byte by = (byte)(this._vector[this._pointer] ^ in[i + inOff]);
            out[i + outOff] = by;
            this._vector[this._pointer] = by;
            this._pointer = this._pointer + 1 & 7;
        }
    }

    public void decryptCFB(byte[] in, int inOff, byte[] out, int outOff, int len) {
        for (int i = 0; i < len; ++i) {
            if (this._pointer == 0) {
                this._generator.encrypt(this._vector, 0, this._vector, 0);
            }
            this._vector[this._pointer] = in[i + inOff];
            out[i + outOff] = (byte)(this._vector[this._pointer] ^ this._vector[this._pointer]);
            this._pointer = this._pointer + 1 & 7;
        }
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        return StreamFromBlockCipher.byteToHexString(b, 0, b.length);
    }

    public static String byteToHexString(byte[] b, int off, int len) {
        StringBuilder sb = new StringBuilder(b.length + 1);
        for (int i = off; i < off + len; ++i) {
            sb.append(StreamFromBlockCipher.byteToHexString(b[i])).append(" ");
        }
        return sb.toString();
    }

    public void encryptCBC(byte[] in, int inOff, byte[] out, int outOff, int len) {
        int block = this._blockLength / 8;
        if (len % block != 0) {
            throw new IllegalArgumentException("len not block aligned");
        }
        for (int i = 0; i < len; i += block) {
            this._vector[0] = (byte)(in[inOff + i + 3] ^ this._vector[0]);
            this._vector[1] = (byte)(in[inOff + i + 2] ^ this._vector[1]);
            this._vector[2] = (byte)(in[inOff + i + 1] ^ this._vector[2]);
            this._vector[3] = (byte)(in[inOff + i + 0] ^ this._vector[3]);
            this._vector[4] = (byte)(in[inOff + i + 7] ^ this._vector[4]);
            this._vector[5] = (byte)(in[inOff + i + 6] ^ this._vector[5]);
            this._vector[6] = (byte)(in[inOff + i + 5] ^ this._vector[6]);
            this._vector[7] = (byte)(in[inOff + i + 4] ^ this._vector[7]);
            this._generator.encrypt(this._vector, 0, this._vector, 0);
            System.arraycopy(this._vector, 0, out, outOff + i, block);
            out[outOff + i + 0] = this._vector[3];
            out[outOff + i + 1] = this._vector[2];
            out[outOff + i + 2] = this._vector[1];
            out[outOff + i + 3] = this._vector[0];
            out[outOff + i + 4] = this._vector[7];
            out[outOff + i + 5] = this._vector[6];
            out[outOff + i + 6] = this._vector[5];
            out[outOff + i + 7] = this._vector[4];
        }
    }

    public void encryptCBC_EXP(byte[] in, int inOff, byte[] out, int outOff, int len) {
        int block = this._blockLength / 8;
        if (len % block != 0) {
            throw new IllegalArgumentException("len not block aligned");
        }
        for (int i = 0; i < len; i += block) {
            int j;
            for (j = 0; j < block; ++j) {
                this._vector[j] = (byte)(in[inOff + i + j] ^ this._vector[j]);
            }
            this._generator.encrypt(this._vector, 0, this._vector, 0);
            System.arraycopy(this._vector, 0, out, outOff + i, block);
            for (j = 0; j < block; ++j) {
                out[outOff + i + j] = this._vector[j];
            }
        }
    }

    private void swap(byte[] b, int off) {
        byte tmp = b[off + 0];
        b[off + 0] = b[off + 3];
        b[off + 3] = tmp;
        tmp = b[off + 1];
        b[off + 1] = b[off + 2];
        b[off + 2] = tmp;
    }

    public void decryptCBC(byte[] in, int inOff, byte[] out, int outOff, int len) {
        int block = this._blockLength / 8;
        byte[] tmp = new byte[block];
        byte[] tmp2 = new byte[block];
        if (len % block != 0) {
            throw new IllegalArgumentException("len not block aligned");
        }
        for (int i = 0; i < len; i += block) {
            tmp[0] = in[inOff + i + 3];
            tmp[1] = in[inOff + i + 2];
            tmp[2] = in[inOff + i + 1];
            tmp[3] = in[inOff + i + 0];
            tmp[4] = in[inOff + i + 7];
            tmp[5] = in[inOff + i + 6];
            tmp[6] = in[inOff + i + 5];
            tmp[7] = in[inOff + i + 4];
            this._generator.decrypt(tmp, 0, tmp2, 0);
            out[outOff + i + 0] = (byte)(tmp2[3] ^ this._vector[0]);
            out[outOff + i + 1] = (byte)(tmp2[2] ^ this._vector[1]);
            out[outOff + i + 2] = (byte)(tmp2[1] ^ this._vector[2]);
            out[outOff + i + 3] = (byte)(tmp2[0] ^ this._vector[3]);
            out[outOff + i + 4] = (byte)(tmp2[7] ^ this._vector[4]);
            out[outOff + i + 5] = (byte)(tmp2[6] ^ this._vector[5]);
            out[outOff + i + 6] = (byte)(tmp2[5] ^ this._vector[6]);
            out[outOff + i + 7] = (byte)(tmp2[4] ^ this._vector[7]);
            this._vector[0] = tmp[3];
            this._vector[1] = tmp[2];
            this._vector[2] = tmp[1];
            this._vector[3] = tmp[0];
            this._vector[4] = tmp[7];
            this._vector[5] = tmp[6];
            this._vector[6] = tmp[5];
            this._vector[7] = tmp[4];
        }
    }

    public void decryptCBC_EXP(byte[] in, int inOff, byte[] out, int outOff, int len) {
        int block = this._blockLength / 8;
        byte[] tmp = new byte[block];
        byte[] tmp2 = new byte[block];
        if (len % block != 0) {
            throw new IllegalArgumentException("len not block aligned");
        }
        for (int i = 0; i < len; i += block) {
            tmp[0] = in[inOff + i + 0];
            tmp[1] = in[inOff + i + 1];
            tmp[2] = in[inOff + i + 2];
            tmp[3] = in[inOff + i + 3];
            tmp[4] = in[inOff + i + 4];
            tmp[5] = in[inOff + i + 5];
            tmp[6] = in[inOff + i + 6];
            tmp[7] = in[inOff + i + 7];
            this._generator.decrypt(tmp, 0, tmp2, 0);
            out[outOff + i + 0] = (byte)(tmp2[0] ^ this._vector[0]);
            out[outOff + i + 1] = (byte)(tmp2[1] ^ this._vector[1]);
            out[outOff + i + 2] = (byte)(tmp2[2] ^ this._vector[2]);
            out[outOff + i + 3] = (byte)(tmp2[3] ^ this._vector[3]);
            out[outOff + i + 4] = (byte)(tmp2[4] ^ this._vector[4]);
            out[outOff + i + 5] = (byte)(tmp2[5] ^ this._vector[5]);
            out[outOff + i + 6] = (byte)(tmp2[6] ^ this._vector[6]);
            out[outOff + i + 7] = (byte)(tmp2[7] ^ this._vector[7]);
            this._vector[0] = tmp[0];
            this._vector[1] = tmp[1];
            this._vector[2] = tmp[2];
            this._vector[3] = tmp[3];
            this._vector[4] = tmp[4];
            this._vector[5] = tmp[5];
            this._vector[6] = tmp[6];
            this._vector[7] = tmp[7];
        }
    }

    public static void main(String[] args) {
        int a = 10;
        int b = -10;
        byte c = (byte)(a ^ b);
        System.out.println(" c : " + c);
    }
}

