/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.EncryptionKey;
import dmg.security.cipher.EncryptionKeyInputStream;
import dmg.security.cipher.rsa.RsaEncryptionKey;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class SshPrivateKeyInputStream
extends FilterInputStream
implements EncryptionKeyInputStream {
    private DataInputStream _in;
    private static final int SSH_CIPHER_NONE = 0;
    private static final String AUTHFILE_ID_STRING = "SSH PRIVATE_KEY_FILE_FORMAT 1.1\n";
    BigInteger _n = null;
    BigInteger _e = null;
    BigInteger _d = null;
    String _comment = null;
    String[] _domainList = null;
    int _readCounter = 0;

    public SshPrivateKeyInputStream(InputStream in) {
        super(in);
        this._in = new DataInputStream(in);
    }

    @Override
    public EncryptionKey readEncryptionKey() throws IOException {
        ++this._readCounter;
        if (this._readCounter == 1) {
            this._readAll();
            return new RsaEncryptionKey(this._domainList, "private", this._d, this._n);
        }
        if (this._readCounter == 2) {
            return new RsaEncryptionKey(this._domainList, "public", this._e, this._n);
        }
        return null;
    }

    private void _readAll() throws IOException {
        byte[] check = new byte[4];
        byte[] id = new byte[AUTHFILE_ID_STRING.length() + 1];
        this._in.readFully(id);
        byte cipherType = this._in.readByte();
        int waste = this._in.readInt();
        int bits = this._in.readInt();
        this._n = this.readBigInteger(this._in);
        this._e = this.readBigInteger(this._in);
        String _comment = this.readString(this._in);
        this._in.readFully(check);
        if (check[0] != check[2] || check[1] != check[3]) {
            throw new IOException("check failed");
        }
        this._d = this.readBigInteger(this._in);
        BigInteger u = this.readBigInteger(this._in);
        BigInteger p = this.readBigInteger(this._in);
        BigInteger q = this.readBigInteger(this._in);
        this._domainList = new String[1];
        this._domainList[0] = _comment;
    }

    private String readString(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len > 2048) {
            throw new IOException("Comment String too long " + len);
        }
        byte[] data = new byte[len];
        in.readFully(data);
        return new String(data);
    }

    private BigInteger readBigInteger(DataInputStream in) throws IOException {
        int bits = in.readUnsignedShort();
        int len = (bits + 7) / 8;
        byte[] data = new byte[len];
        in.readFully(data);
        BigInteger n = new BigInteger(data);
        return n;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE : ... <keyfilename> ");
            System.exit(4);
        }
        try {
            EncryptionKey key;
            SshPrivateKeyInputStream in = new SshPrivateKeyInputStream(new FileInputStream(args[0]));
            while ((key = in.readEncryptionKey()) != null) {
                System.out.println("" + key);
            }
        }
        catch (IOException e) {
            System.err.println(" Exception : " + e);
            System.exit(4);
        }
    }
}

