/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshRsaKey;
import dmg.security.cipher.StreamCipher;
import dmg.security.digest.Md5;
import java.util.Date;
import java.util.Random;

public class SshSmsgPublicKey
extends SshPacket {
    private SshRsaKey _server = null;
    private SshRsaKey _host = null;
    private int _cipherMask;
    private int _authMask;
    private int _flags;
    private byte[] _cookie;
    private static Random __r = new Random(new Date().getTime());
    private SshRsaKey[] _keys = null;

    public SshSmsgPublicKey(SshPacket packet) {
        byte[] payload = packet.getPayload();
        this._cookie = new byte[8];
        this._keys = new SshRsaKey[2];
        int pos = 0;
        System.arraycopy(payload, pos, this._cookie, 0, this._cookie.length);
        pos += 8;
        for (int i = 0; i < 2; ++i) {
            int mpBits = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
            int exLength = (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
            byte[] ex = new byte[(exLength + 7) / 8];
            System.arraycopy(payload, pos, ex, 0, ex.length);
            pos += ex.length;
            int mdLength = (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
            byte[] md = new byte[(mdLength + 7) / 8];
            System.arraycopy(payload, pos, md, 0, md.length);
            pos += md.length;
            this._keys[i] = new SshRsaKey(mpBits, ex, md);
        }
        this._flags = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        this._cipherMask = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        this._authMask = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
    }

    public SshRsaKey getServerKey() {
        return this._keys[0];
    }

    public SshRsaKey getHostKey() {
        return this._keys[1];
    }

    public SshSmsgPublicKey(SshRsaKey server, SshRsaKey host, int cipherMask, int authMask) {
        this._server = server;
        this._host = host;
        this._cipherMask = cipherMask;
        this._authMask = authMask;
        this._cookie = new byte[8];
        __r.nextBytes(this._cookie);
    }

    public byte[] getCookie() {
        byte[] cookie = new byte[this._cookie.length];
        System.arraycopy(this._cookie, 0, cookie, 0, this._cookie.length);
        return cookie;
    }

    @Override
    public byte[] toByteArray(StreamCipher cipher) {
        byte[] server = this._server.toByteArray();
        byte[] host = this._host.toByteArray();
        byte[] out = new byte[server.length + host.length + 8 + 12];
        int pos = 0;
        System.arraycopy(this._cookie, 0, out, pos, this._cookie.length);
        System.arraycopy(server, 0, out, pos += this._cookie.length, server.length);
        System.arraycopy(host, 0, out, pos += server.length, host.length);
        this.punchInt(out, pos += host.length, 0);
        this.punchInt(out, pos += 4, this._cipherMask);
        this.punchInt(out, pos += 4, this._authMask);
        return this.makePacket(cipher, out);
    }

    public byte[] getSessionId() {
        if (this._keys == null) {
            return this._getSessionId(this._host.getModulusBytes(), this._server.getModulusBytes());
        }
        return this._getSessionId(this._keys[1].getModulus().toByteArray(), this._keys[0].getModulus().toByteArray());
    }

    private byte[] _getSessionId(byte[] host, byte[] server) {
        try {
            Md5 digest = new Md5();
            int off = host[0] == 0 ? 1 : 0;
            digest.update(host, off, host.length - off);
            off = server[0] == 0 ? 1 : 0;
            digest.update(server, off, server.length - off);
            digest.update(this._cookie);
            return digest.digest();
        }
        catch (Exception e) {
            System.err.println("Problem in getSessionId : " + e);
            return null;
        }
    }
}

