/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.security.digest.Md5;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;

public class SshRsaKey {
    private boolean _fullIdentity = false;
    private int _bits = 0;
    private int _cipherLength = 0;
    private int _blockLength = 0;
    private BigInteger _n = null;
    private BigInteger _e = null;
    private BigInteger _d = null;
    private String _comment = null;
    private static final int SSH_CIPHER_NONE = 0;
    private static final String AUTHFILE_ID_STRING = "SSH PRIVATE_KEY_FILE_FORMAT 1.1\n";

    public SshRsaKey(InputStream in) throws IOException {
        this._readSshIdentity(new DataInputStream(in));
        this._cipherLength = (this._n.bitLength() + 7) / 8;
        this._blockLength = this._cipherLength - 3 - 8;
        this._fullIdentity = true;
    }

    public SshRsaKey(int bits, byte[] exponent, byte[] modulus) {
        this._bits = bits;
        this._n = new BigInteger(1, modulus);
        this._e = new BigInteger(1, exponent);
        this._comment = "None";
        this._cipherLength = (this._n.bitLength() + 7) / 8;
        this._blockLength = this._cipherLength - 3 - 8;
        this._fullIdentity = false;
    }

    public SshRsaKey(int bits, BigInteger exponent, BigInteger modulus, String user) {
        this._bits = bits;
        this._n = modulus;
        this._e = exponent;
        this._comment = user;
        this._cipherLength = (this._n.bitLength() + 7) / 8;
        this._blockLength = this._cipherLength - 3 - 8;
        this._fullIdentity = false;
    }

    public SshRsaKey(int bits, byte[] modulus) {
        this._bits = bits;
        this._n = new BigInteger(1, modulus);
        this._comment = "None";
        this._cipherLength = (this._n.bitLength() + 7) / 8;
        this._blockLength = this._cipherLength - 3 - 8;
        this._fullIdentity = false;
    }

    public SshRsaKey(String str) {
        StringTokenizer st = new StringTokenizer(str);
        try {
            String com = st.nextToken();
            try {
                this._bits = new Integer(com);
            }
            catch (NumberFormatException nfe) {
                this._bits = new Integer(st.nextToken());
                this._comment = com;
            }
            this._e = new BigInteger(st.nextToken());
            this._n = new BigInteger(st.nextToken());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Rsa : Public Key Format Problem : " + e);
        }
        this._cipherLength = (this._n.bitLength() + 7) / 8;
        this._blockLength = this._cipherLength - 3 - 8;
        if (st.hasMoreTokens()) {
            this._comment = this._comment == null ? st.nextToken() : this._comment + " " + st.nextToken();
        } else if (this._comment == null) {
            this._comment = "NoComment";
        }
        this._fullIdentity = false;
    }

    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, 0, data.length);
    }

    public byte[] encrypt(byte[] data, int off, int size) {
        return this.encryptBigInteger(data, off, size).toByteArray();
    }

    public BigInteger encryptBigInteger(byte[] data, int off, int size) {
        if (size > this._blockLength) {
            throw new IllegalArgumentException(" Rsa : Max Blocksize exceeded");
        }
        byte[] in = new byte[this._cipherLength];
        int randomCount = in.length - 3 - size;
        Random r = new Random(new Date().getTime());
        byte[] randoms = new byte[randomCount];
        r.nextBytes(randoms);
        for (int i = 0; i < randoms.length; ++i) {
            while (randoms[i] == 0) {
                randoms[i] = (byte)r.nextInt();
            }
        }
        in[0] = 0;
        in[1] = 2;
        System.arraycopy(randoms, 0, in, 2, randoms.length);
        in[randoms.length + 2] = 0;
        System.arraycopy(data, off, in, randoms.length + 3, size);
        BigInteger x = new BigInteger(1, in);
        x = x.modPow(this._e, this._n);
        return x;
    }

    public byte[] decrypt(byte[] in) {
        int i;
        BigInteger x = new BigInteger(1, in);
        if (x.compareTo(this._n) > 0) {
            throw new IllegalArgumentException("Rsa : Cipher larger then modulus ");
        }
        in = (x = x.modPow(this._d, this._n)).toByteArray();
        if (in[0] != 2) {
            throw new IllegalArgumentException("Rsa : protocol violation 2 != " + in[0]);
        }
        for (i = 1; i < in.length && in[i] != 0; ++i) {
        }
        if (i == in.length) {
            throw new IllegalArgumentException("Rsa : Random delimiter missing");
        }
        byte[] out = new byte[in.length - ++i];
        System.arraycopy(in, i, out, 0, out.length);
        return out;
    }

    public byte[] toByteArray() {
        byte[] nArray = this._n.toByteArray();
        byte[] eArray = this._e.toByteArray();
        byte[] out = new byte[nArray.length + eArray.length + 8];
        int pos = 0;
        this.punchInt(out, pos, this._bits);
        this.punchShort(out, pos += 4, eArray.length * 8);
        System.arraycopy(eArray, 0, out, pos += 2, eArray.length);
        this.punchShort(out, pos += eArray.length, nArray.length * 8);
        System.arraycopy(nArray, 0, out, pos += 2, nArray.length);
        return out;
    }

    public boolean equals(Object n) {
        if (this == n) {
            return true;
        }
        if (n instanceof SshRsaKey) {
            SshRsaKey other = (SshRsaKey)n;
            return this._n.equals(other._n);
        }
        return false;
    }

    public int hashCode() {
        return this._n.hashCode();
    }

    public BigInteger getModulus() {
        return this._n;
    }

    public int getKeySize() {
        return this._bits;
    }

    public String getComment() {
        return this._comment;
    }

    public byte[] getModulusBytes() {
        return this._n.toByteArray();
    }

    public int getModulusBits() {
        return this._bits;
    }

    public boolean isFullIdentity() {
        return this._fullIdentity;
    }

    public String getFingerPrint() {
        try {
            Md5 md5 = new Md5();
            md5.update(this._n.toByteArray());
            return SshRsaKey.byteToHexString(md5.digest());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" SshRsaKey : " + (this._fullIdentity ? "Full Identity" : (this._e == null ? "Modulus Only" : "Public Part")) + "\n");
        sb.append(" Comment   : " + this._comment + "\n");
        sb.append(" KeySize   : " + this._bits + "\n");
        if (this._e != null) {
            sb.append(" Exp (e)   : " + this._e.toString(10) + "\n");
        }
        if (this._fullIdentity) {
            sb.append(" Exp (d)   : " + this._d.toString(10) + "\n");
        }
        sb.append(" Modulus   : " + this._n.toString(10) + "\n");
        return sb.toString();
    }

    private void _readSshIdentity(DataInputStream dataIn) throws IOException {
        byte[] check = new byte[4];
        byte[] id = new byte[AUTHFILE_ID_STRING.length() + 1];
        dataIn.readFully(id);
        byte cipherType = dataIn.readByte();
        if (cipherType != 0) {
            throw new IOException("Rsa : Sorry, Identity file encrypted");
        }
        int waste = dataIn.readInt();
        this._bits = dataIn.readInt();
        this._n = this.readBigInteger(dataIn);
        this._e = this.readBigInteger(dataIn);
        String _comment = this.readString(dataIn);
        dataIn.readFully(check);
        if (check[0] != check[2] || check[1] != check[3]) {
            throw new IOException("Rsa : Check failed");
        }
        this._d = this.readBigInteger(dataIn);
        BigInteger u = this.readBigInteger(dataIn);
        BigInteger p = this.readBigInteger(dataIn);
        BigInteger q = this.readBigInteger(dataIn);
    }

    private String readString(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len > 2048) {
            throw new IOException("Comment String too long " + len);
        }
        byte[] data = new byte[len];
        in.readFully(data);
        return new String(data);
    }

    private BigInteger readBigInteger(DataInputStream in) throws IOException {
        int bits = in.readUnsignedShort();
        int len = (bits + 7) / 8;
        byte[] data = new byte[len];
        in.readFully(data);
        BigInteger n = new BigInteger(1, data);
        return n;
    }

    private void punchInt(byte[] a, int off, int value) {
        a[off + 0] = (byte)(value >>> 24 & 0xFF);
        a[off + 1] = (byte)(value >>> 16 & 0xFF);
        a[off + 2] = (byte)(value >>> 8 & 0xFF);
        a[off + 3] = (byte)(value >>> 0 & 0xFF);
    }

    private void punchShort(byte[] a, int off, int value) {
        a[off + 0] = (byte)(value >>> 8 & 0xFF);
        a[off + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            sb.append(SshRsaKey.byteToHexString(b[i]) + (i == b.length - 1 ? "" : ":"));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println(" USAGE : ... <identityFile>");
            System.exit(4);
        }
        SshRsaKey key = null;
        try {
            key = new SshRsaKey(new FileInputStream(args[0]));
        }
        catch (Exception e) {
            System.err.println("Problem reading : " + args[0] + " : " + e);
            System.exit(4);
        }
        Random r = new Random(new Date().getTime());
        byte[] challenge = new byte[32];
        for (int i = 0; i < 1000; ++i) {
            byte[] de = null;
            byte[] re = null;
            try {
                int l;
                r.nextBytes(challenge);
                de = key.encrypt(challenge);
                BigInteger bi = new BigInteger(1, de);
                System.out.println(" encrypted " + bi.bitCount() + " " + bi.bitLength() + " :\n" + SshRsaKey.byteToHexString(de));
                re = key.decrypt(de);
                if (challenge.length != re.length) {
                    System.out.println("Problem in decryption length : ");
                    System.out.println(" or : " + SshRsaKey.byteToHexString(challenge));
                    System.out.println(" en : " + SshRsaKey.byteToHexString(de));
                    System.out.println(" de : " + SshRsaKey.byteToHexString(re));
                    System.exit(5);
                }
                for (l = 0; l < challenge.length && challenge[l] == re[l]; ++l) {
                }
                if (l < challenge.length) {
                    System.out.println("Problem in decryption content : ");
                    System.out.println(" or : " + SshRsaKey.byteToHexString(challenge));
                    System.out.println(" en : " + SshRsaKey.byteToHexString(de));
                    System.out.println(" de : " + SshRsaKey.byteToHexString(re));
                    System.exit(5);
                }
                System.out.println("O.K. " + i);
                continue;
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Problem  : " + iae);
                System.out.println(" or : " + SshRsaKey.byteToHexString(challenge));
                if (de != null) {
                    System.out.println(" en : " + SshRsaKey.byteToHexString(de));
                }
                if (re != null) {
                    System.out.println(" de : " + SshRsaKey.byteToHexString(re));
                }
                System.exit(5);
            }
        }
    }
}

