/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshPacket;
import dmg.security.cipher.StreamCipher;

public class SshMpIntPacket
extends SshPacket {
    byte[] _mp = null;
    int _mpLength = 0;
    byte[] _payload = null;

    public SshMpIntPacket(StreamCipher cipher, byte[] data, int len) {
        super(cipher, data, len);
        byte[] payload = this.getPayload();
        this.convertMpInt(payload, 0, payload.length);
    }

    public SshMpIntPacket(byte[] data, int len) {
        super(null, data, len);
        byte[] payload = this.getPayload();
        this.convertMpInt(payload, 0, payload.length);
    }

    public SshMpIntPacket(SshPacket packet) {
        byte[] payload = packet.getPayload();
        this.convertMpInt(payload, 0, payload.length);
    }

    public SshMpIntPacket(byte[] mp, int off, int mpLengthBits) {
        this(null, mp, off, mpLengthBits);
    }

    public SshMpIntPacket(StreamCipher cipher, byte[] mp, int off, int mpLengthBits) {
        super(cipher);
        this._mpLength = mpLengthBits;
        int payLoadBytes = (mpLengthBits + 7) / 8 + 2;
        this._payload = new byte[payLoadBytes];
        this.punchShort(this._payload, 0, this._mpLength);
        int skip = mp.length - (mpLengthBits + 7) / 8;
        System.arraycopy(mp, off + skip, this._payload, 2, payLoadBytes - 2);
    }

    public void convertMpInt(byte[] data, int pos, int len) {
        this._mpLength = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        this._mp = new byte[(this._mpLength + 7) / 8];
        System.arraycopy(data, pos + 2, this._mp, 0, this._mp.length);
    }

    public byte[] getMpInt() {
        return this._mp;
    }

    public int getMpIntLength() {
        return this._mpLength;
    }

    @Override
    public byte[] toByteArray() {
        return this.makePacket(this._payload);
    }

    @Override
    public byte[] toByteArray(StreamCipher cipher) {
        return this.makePacket(cipher, this._payload);
    }
}

