/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshRsaKey;
import dmg.security.cipher.StreamCipher;

public class SshCmsgSessionKey
extends SshPacket {
    private int _cipher;
    private byte[] _cookie = new byte[8];
    private byte[] _mp;
    private byte[] _data;
    private byte[] _sessionKey;
    private SshRsaKey _server;
    private SshRsaKey _host;
    private byte[] _payload;

    public SshCmsgSessionKey(SshRsaKey server, SshRsaKey host, SshPacket packet) {
        this._server = server;
        this._host = host;
        int pos = 0;
        this._data = packet.getPayload();
        this._cipher = this._data[pos++];
        System.arraycopy(this._data, pos, this._cookie, 0, this._cookie.length);
        int mpLength = (this._data[pos += this._cookie.length] & 0xFF) << 8 | this._data[pos + 1] & 0xFF;
        mpLength = (mpLength + 7) / 8;
        this._mp = new byte[mpLength];
        System.arraycopy(this._data, pos += 2, this._mp, 0, this._mp.length);
        pos += this._mp.length;
        byte[] flags = new byte[4];
        this._sessionKey = this._server.decrypt(this._host.decrypt(this._mp));
    }

    public SshCmsgSessionKey(int cipherType, byte[] cookie, byte[] sessionKey, int flags) {
        int payloadLength = 1 + cookie.length + 2 + sessionKey.length + 4;
        int pos = 0;
        this._payload = new byte[payloadLength];
        this._payload[pos++] = (byte)cipherType;
        System.arraycopy(cookie, 0, this._payload, pos, cookie.length);
        this.punchShort(this._payload, pos += cookie.length, sessionKey.length * 8);
        System.arraycopy(sessionKey, 0, this._payload, pos += 2, sessionKey.length);
        this.punchInt(this._payload, pos += sessionKey.length, flags);
    }

    public byte[] getSessionKey() {
        byte[] out = new byte[this._sessionKey.length];
        System.arraycopy(this._sessionKey, 0, out, 0, this._sessionKey.length);
        return out;
    }

    public int getCipher() {
        return this._cipher;
    }

    @Override
    public byte[] toByteArray() {
        return this.makePacket(this._payload);
    }

    @Override
    public byte[] toByteArray(StreamCipher cipher) {
        return this.toByteArray();
    }
}

