/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpGetNextRequest;
import dmg.protocols.snmp.SnmpGetRequest;
import dmg.protocols.snmp.SnmpGetResponse;
import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpOctetString;
import dmg.protocols.snmp.SnmpPDU;
import dmg.protocols.snmp.SnmpSequence;

public class SnmpRequest
extends SnmpSequence {
    private SnmpPDU _pdu;
    private SnmpSequence _varBindList;
    private SnmpOctetString _community;
    private int _type = 0;

    public SnmpRequest(SnmpObject snmp) {
        super((SnmpSequence)snmp);
        try {
            this._community = (SnmpOctetString)this.objectAt(1);
            this._pdu = (SnmpPDU)this.objectAt(2);
            this._varBindList = this._pdu.getVarBindList();
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a SnmpRequest");
        }
        if (this._pdu instanceof SnmpGetRequest) {
            this._type = 160;
        } else if (this._pdu instanceof SnmpGetNextRequest) {
            this._type = 161;
        }
    }

    public SnmpRequest(SnmpOctetString community, SnmpInteger requestID, int type) {
        this._type = type;
        this.addObject(new SnmpInteger(0L));
        this._community = community;
        this.addObject(this._community);
        this._varBindList = new SnmpSequence();
        if (type == 160) {
            this._pdu = new SnmpGetRequest(requestID, new SnmpInteger(0L), new SnmpInteger(0L), this._varBindList);
        } else if (type == 161) {
            this._pdu = new SnmpGetNextRequest(requestID, new SnmpInteger(0L), new SnmpInteger(0L), this._varBindList);
        } else if (type == 162) {
            this._pdu = new SnmpGetResponse(requestID, new SnmpInteger(0L), new SnmpInteger(0L), this._varBindList);
        }
        this.addObject(this._pdu);
    }

    public SnmpRequest(SnmpOctetString community, SnmpInteger requestID, SnmpInteger errorStatus, SnmpInteger errorIndex) {
        this._type = 162;
        this.addObject(new SnmpInteger(0L));
        this._community = community;
        this.addObject(this._community);
        this._varBindList = new SnmpSequence();
        this._pdu = new SnmpGetResponse(requestID, errorStatus, errorIndex, this._varBindList);
        this.addObject(this._pdu);
    }

    public void addVarBind(SnmpOID oid, SnmpObject value) {
        SnmpSequence seq = new SnmpSequence();
        seq.addObject(oid);
        seq.addObject(value);
        this._varBindList.addObject(seq);
    }

    public SnmpSequence getVarBindList() {
        return this._varBindList;
    }

    public SnmpInteger getRequestID() {
        return this._pdu.getRequestID();
    }

    public int varBindListSize() {
        return this._varBindList.size();
    }

    public SnmpOID varBindOIDAt(int i) {
        SnmpSequence varBind = (SnmpSequence)this._varBindList.objectAt(i);
        return (SnmpOID)varBind.objectAt(0);
    }

    public SnmpInteger getErrorStatus() {
        return this._pdu.getErrorStatus();
    }

    public SnmpInteger getErrorIndex() {
        return this._pdu.getErrorIndex();
    }

    public int getRequestType() {
        return this._type;
    }

    public SnmpObject varBindValueAt(int i) {
        SnmpSequence varBind = (SnmpSequence)this._varBindList.objectAt(i);
        return varBind.objectAt(1);
    }

    public SnmpOctetString getCommunity() {
        return this._community;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SnmpRequest , Version " + this.objectAt(0).toString() + " , Community " + this.objectAt(1).toString() + "\n");
        sb.append(this._pdu.toString());
        return sb.toString();
    }
}

