/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpGetNextRequest;
import dmg.protocols.snmp.SnmpGetRequest;
import dmg.protocols.snmp.SnmpGetResponse;
import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpIpNumber;
import dmg.protocols.snmp.SnmpNull;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpObjectHeader;
import dmg.protocols.snmp.SnmpOctetString;
import dmg.protocols.snmp.SnmpSequence;
import dmg.protocols.snmp.SnmpSetRequest;
import dmg.protocols.snmp.SnmpTimeTicks;
import dmg.protocols.snmp.SnmpTrap;

abstract class SnmpObject {
    private int _codedLength = 0;

    SnmpObject() {
    }

    abstract byte[] getSnmpBytes();

    public static SnmpObject generate(byte[] b, int offIn, int len) throws NumberFormatException {
        SnmpObjectHeader header = new SnmpObjectHeader(b, offIn, len);
        SnmpObject snmp = null;
        switch (header.getType()) {
            case 6: {
                snmp = new SnmpOID(header, b, offIn, len);
                break;
            }
            case 5: {
                snmp = new SnmpNull(header, b, offIn, len);
                break;
            }
            case 64: {
                snmp = new SnmpIpNumber(header, b, offIn, len);
                break;
            }
            case 67: {
                snmp = new SnmpTimeTicks(header, b, offIn, len);
                break;
            }
            case 2: 
            case 65: 
            case 66: 
            case 68: {
                snmp = new SnmpInteger(header, b, offIn, len);
                break;
            }
            case 4: {
                snmp = new SnmpOctetString(header, b, offIn, len);
                break;
            }
            case 48: {
                snmp = new SnmpSequence(header, b, offIn, len);
                break;
            }
            case 160: {
                snmp = new SnmpGetRequest(header, b, offIn, len);
                break;
            }
            case 161: {
                snmp = new SnmpGetNextRequest(header, b, offIn, len);
                break;
            }
            case 163: {
                snmp = new SnmpSetRequest(header, b, offIn, len);
                break;
            }
            case 162: {
                snmp = new SnmpGetResponse(header, b, offIn, len);
                break;
            }
            case 164: {
                snmp = new SnmpTrap(header, b, offIn, len);
                break;
            }
            default: {
                throw new NumberFormatException();
            }
        }
        return snmp;
    }

    public int getCodedLength() {
        return this._codedLength;
    }

    public void setCodedLength(int len) {
        this._codedLength = len;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(4);
        }
        byte[] b = new byte[args.length];
        for (int i = 0; i < args.length; ++i) {
            int x = Integer.valueOf(args[i], 16);
            x = (x &= 0xFF) > 127 ? x - 256 : x;
            b[i] = (byte)(x > 127 ? x - 256 : x);
        }
        String output = SnmpObjectHeader._print(b, 0, b.length);
        System.out.println(output);
        SnmpObject snmp = SnmpObject.generate(b, 0, b.length);
        System.out.println(" Got class  : " + snmp.getClass().getName());
        System.out.println(" CodeLength : " + snmp.getCodedLength());
        System.out.println(" Value      : \n" + snmp.toString());
        b = snmp.getSnmpBytes();
        output = SnmpObjectHeader._print(b, 0, b.length);
        System.out.println(output);
    }
}

