/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;
import java.util.StringTokenizer;

public class SnmpOID
extends SnmpObject {
    private int[] _array = null;
    private int _arrayLength = 0;

    SnmpOID(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) {
        int off = offIn + head.getCodedLength();
        int len = head.getLength();
        this._array = new int[len + 1];
        int x = b[off++];
        int resPos = 0;
        x = x < 0 ? x + 256 : x;
        this._array[resPos++] = x / 40;
        this._array[resPos++] = x % 40;
        int res = 0;
        for (int i = 1; i < len; ++i) {
            int n = x = (x = b[off++]) < 0 ? x + 256 : x;
            if ((x & 0x80) > 0) {
                res |= x & 0x7F;
                res <<= 7;
                continue;
            }
            this._array[resPos++] = res |= x & 0x7F;
            res = 0;
        }
        this._arrayLength = resPos;
        this.setCodedLength(head.getCodedLength() + len);
    }

    public SnmpOID(int[] vector) {
        this._arrayLength = vector.length;
        this._array = new int[this._arrayLength];
        System.arraycopy(vector, 0, this._array, 0, this._arrayLength);
    }

    public SnmpOID(String str) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(str, ".");
        int len = st.countTokens();
        if (len < 3) {
            throw new NumberFormatException();
        }
        this._arrayLength = len;
        this._array = new int[this._arrayLength];
        for (int i = 0; i < this._arrayLength; ++i) {
            this._array[i] = new Integer(st.nextToken());
        }
    }

    public int[] getVector() {
        int[] v = new int[this._arrayLength];
        System.arraycopy(this._array, 0, v, 0, this._arrayLength);
        return v;
    }

    @Override
    public byte[] getSnmpBytes() {
        byte[] b = new byte[2 * this._arrayLength];
        int x = this._array[0] * 40 + this._array[1];
        int off = 0;
        b[off++] = (byte)(x > 127 ? x - 256 : x);
        int y = 0;
        boolean begin = false;
        for (int i = 2; i < this._arrayLength; ++i) {
            x = this._array[i];
            begin = false;
            for (int j = 3; j >= 0; --j) {
                y = x >> j * 7 & 0x7F;
                if (!begin && y == 0) continue;
                begin = true;
                if (j != 0) {
                    y |= 0x80;
                }
                b[off++] = (byte)(y > 127 ? y - 256 : y);
            }
            if (begin) continue;
            b[off++] = 0;
        }
        SnmpObjectHeader head = new SnmpObjectHeader(6, off);
        int headLen = head.getCodedLength();
        byte[] out = new byte[headLen + off];
        System.arraycopy(head.getSnmpBytes(), 0, out, 0, headLen);
        System.arraycopy(b, 0, out, headLen, off);
        return out;
    }

    public String toString() {
        if (this._array == null || this._arrayLength == 0) {
            return "Null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._arrayLength; ++i) {
            sb.append("" + this._array[i]);
            if (i >= this._arrayLength - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

