/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;

public class SnmpInteger
extends SnmpObject {
    private long _value;

    public SnmpInteger(long value) {
        this._value = value;
    }

    SnmpInteger(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) throws NumberFormatException {
        int off = offIn + head.getCodedLength();
        int len = head.getLength();
        if (len > 7) {
            throw new NumberFormatException("Integer(len)>7");
        }
        for (int i = 0; i < len; ++i) {
            int x;
            x = (x = b[off++]) < 0 ? x + 256 : x;
            this._value <<= 8;
            this._value |= (long)x;
        }
        this.setCodedLength(head.getCodedLength() + len);
    }

    public long longValue() {
        return this._value;
    }

    public int intValue() {
        return (int)this._value;
    }

    public String toString() {
        return "" + this._value;
    }

    @Override
    public byte[] getSnmpBytes() {
        byte[] b = new byte[8];
        boolean started = false;
        int off = 0;
        if (this._value == 0L) {
            b[off++] = 0;
        } else {
            for (int i = 7; i >= 0; --i) {
                long y = this._value >> i * 8 & 0xFFL;
                if (!started && y == 0L) continue;
                started = true;
                b[off++] = (byte)(y > 127L ? y - 256L : y);
            }
        }
        SnmpObjectHeader head = new SnmpObjectHeader(2, off);
        int headLen = head.getCodedLength();
        byte[] out = new byte[headLen + off];
        System.arraycopy(head.getSnmpBytes(), 0, out, 0, headLen);
        System.arraycopy(b, 0, out, headLen, off);
        return out;
    }
}

