/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpNull;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpOctetString;
import dmg.protocols.snmp.SnmpRequest;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class Snmp
extends Frame
implements ActionListener,
Runnable {
    private MenuBar _menuBar;
    private Menu _editMenu;
    private Menu _fileMenu;
    private Menu _widthMenu;
    private MenuItem _editEditItem;
    private MenuItem _fileExitItem;
    private TextField _hostText;
    private TextField _communityText;
    private TextField _portText;
    private TextField _oidText;
    private TextField _valueText;
    private TextField _messageText;
    private Choice _typeChoice;
    private TextArea _outputText;
    private Button _nextButton;
    private Button _getButton;
    private Button _clearButton;
    private Button _walkButton;
    private Button _stopButton;
    private Button _resetButton;
    private Button _systemButton;
    private Thread _receiverThread;
    private Thread _senderThread;
    private DatagramSocket _socket = null;
    private boolean _isNext = false;
    private int _requestId = 100;
    private SnmpOID _argOID;
    private InetAddress _argHost;
    private int _argPort;
    private SnmpOctetString _argCommunity;
    private int _walk = 0;
    private int _id = 0;
    private int _special = 0;
    private final Object _sendLock = new Object();
    private final Object _receiveLock = new Object();
    private SnmpRequest _request = null;
    private SnmpRequest _result = null;
    private boolean _sending = false;
    static final String[] __sysAll = new String[]{"System Description", "System Object ID  ", "System Uptime     ", "System Contact    ", "System Name       ", "System Location   ", "System Services   "};

    public Snmp(String[] args) {
        String frameName = args.length < 1 ? "Snmp" : args[0];
        this.setTitle(frameName);
        this.installMenu();
        this._hostText = new TextField("oho");
        this._portText = new TextField("161");
        this._communityText = new TextField("public");
        this._oidText = new TextField("1.3.6.1.2.1.1.1");
        this._oidText.setBackground(Color.orange);
        this._valueText = new TextField("");
        this._valueText.setBackground(Color.blue);
        this._valueText.setForeground(Color.yellow);
        this._messageText = new TextField("");
        this._messageText.setForeground(Color.red);
        this._typeChoice = new Choice();
        this._typeChoice.add("TimeTicks");
        this._typeChoice.add("OctetString");
        this._typeChoice.add("Integer");
        this._typeChoice.add("IpNumber");
        this._typeChoice.add("OID");
        this._outputText = new TextArea(15, 100);
        this._outputText.setFont(new Font("Monospaced", 1, 12));
        this._nextButton = new Button("Next");
        this._getButton = new Button("Get");
        this._clearButton = new Button("Clear");
        this._walkButton = new Button("Walk");
        this._stopButton = new Button("Stop");
        this._resetButton = new Button("Reset OID");
        this._systemButton = new Button("System");
        this._nextButton.addActionListener(this);
        this._getButton.addActionListener(this);
        this._clearButton.addActionListener(this);
        this._walkButton.addActionListener(this);
        this._stopButton.addActionListener(this);
        this._resetButton.addActionListener(this);
        this._systemButton.addActionListener(this);
        this.setLayout(new BorderLayout(0, 1));
        Panel buttonPanel = new Panel(new GridLayout(0, 1));
        buttonPanel.add(this._clearButton);
        buttonPanel.add(this._resetButton);
        buttonPanel.add(this._getButton);
        buttonPanel.add(this._nextButton);
        buttonPanel.add(this._walkButton);
        buttonPanel.add(this._stopButton);
        buttonPanel.add(this._systemButton);
        Panel actionPanel = new Panel(new GridLayout(0, 3));
        this.add((Component)actionPanel, "North");
        this.add((Component)this._outputText, "Center");
        this.add((Component)buttonPanel, "West");
        this.add((Component)this._messageText, "South");
        Label hostLabel = new Label("Host");
        Label portLabel = new Label("Port");
        Label communityLabel = new Label("Community");
        Label oidLabel = new Label("ObjectIdentifier");
        Label valueLabel = new Label("ObjectValue");
        Label typeLabel = new Label("ObjectType");
        actionPanel.add(hostLabel);
        actionPanel.add(portLabel);
        actionPanel.add(communityLabel);
        actionPanel.add(this._hostText);
        actionPanel.add(this._portText);
        actionPanel.add(this._communityText);
        actionPanel.add(oidLabel);
        actionPanel.add(valueLabel);
        actionPanel.add(typeLabel);
        actionPanel.add(this._oidText);
        actionPanel.add(this._valueText);
        actionPanel.add(this._typeChoice);
        this.pack();
        this.setVisible(true);
        try {
            this._socket = new DatagramSocket();
        }
        catch (SocketException e) {
            // empty catch block
        }
        this._receiverThread = new Thread(this);
        this._receiverThread.start();
        this._senderThread = new Thread(this);
        this._senderThread.start();
    }

    private void installMenu() {
        this._menuBar = new MenuBar();
        this._fileMenu = new Menu("File");
        this._fileExitItem = new MenuItem("Exit");
        this._fileMenu.add(this._fileExitItem);
        this._fileExitItem.addActionListener(this);
        this._fileExitItem.setActionCommand("exit");
        this._editMenu = new Menu("Edit");
        this._editEditItem = new MenuItem("Edit Topology");
        this._editMenu.add(this._editEditItem);
        this._editEditItem.addActionListener(this);
        this._editEditItem.setActionCommand("edit");
        this._widthMenu = new Menu("Options");
        this._menuBar.add(this._fileMenu);
        this._menuBar.add(this._widthMenu);
        this.setMenuBar(this._menuBar);
    }

    public String _cut(String in) {
        int x = in.lastIndexOf(46);
        if (x < 0) {
            return in;
        }
        if (x == in.length() - 1) {
            return in;
        }
        String s = in.substring(x + 1);
        if (!s.startsWith("Snmp")) {
            return s;
        }
        return s.substring(4);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        String s = event.getActionCommand();
        this._messageText.setText("");
        this._special = 0;
        if (s.equals("exit")) {
            System.exit(0);
        } else if (s.equals("System")) {
            this._isNext = false;
            this._special = 1;
            this._walk = 0;
            this._next();
        } else if (s.equals("Get")) {
            this._isNext = false;
            this._walk = 0;
            this._next();
        } else if (s.equals("Get")) {
            this._isNext = false;
            this._walk = 0;
            this._next();
        } else if (s.equals("Next")) {
            this._isNext = true;
            this._walk = 0;
            this._next();
        } else if (s.equals("Walk")) {
            this._isNext = true;
            this._walk = 100000;
            this._next();
        } else if (s.equals("Stop")) {
            this.stopSending();
        } else if (s.equals("Reset OID")) {
            this._oidText.setText("1.3.6.1.2.1.1.1.0");
        } else if (s.equals("Clear")) {
            this._outputText.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this._senderThread) {
            if (Thread.currentThread() != this._receiverThread) {
                return;
            }
        } else {
            while (true) {
                Object object = this._sendLock;
                synchronized (object) {
                    while (!this._sending) {
                        try {
                            this._sendLock.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                this.say("Transmission initialized\n");
                do {
                    byte[] b = this._request.getSnmpBytes();
                    SnmpRequest result = null;
                    DatagramPacket packet = new DatagramPacket(b, b.length, this._argHost, this._argPort);
                    Object object2 = this._receiveLock;
                    synchronized (object2) {
                        this._result = null;
                        this._id = this._request.getRequestID().intValue();
                        for (int i = 0; i < 3 && this._result == null; ++i) {
                            try {
                                this.say("Sending ..." + packet + "\n");
                                this._socket.send(packet);
                                this.say("Send Ready; Waiting\n");
                                this._receiveLock.wait(3000L);
                                this.say("Wait Ready\n");
                            }
                            catch (Exception iei) {
                                this.esay("Exception in send : " + iei);
                            }
                            if (!this._sending) break;
                        }
                        if (this._result == null || !this._sending) {
                            this._id = 0;
                            this.snmpAnswer(null);
                            break;
                        }
                        result = this._result;
                        this._result = null;
                        this._id = 0;
                    }
                    this._request = this.snmpAnswer(result);
                } while (this._request != null);
                this._sending = false;
            }
        }
        while (true) {
            try {
                while (true) {
                    byte[] b = new byte[2048];
                    DatagramPacket p = new DatagramPacket(b, b.length);
                    this._socket.receive(p);
                    Object object = this._receiveLock;
                    synchronized (object) {
                        this.say("Data received\n");
                        if (this._id == 0) {
                            continue;
                        }
                        SnmpObject snmp = SnmpObject.generate(p.getData(), 0, p.getLength());
                        SnmpRequest request = new SnmpRequest(snmp);
                        if (this._id != request.getRequestID().intValue()) {
                            continue;
                        }
                        this._result = request;
                        this._receiveLock.notifyAll();
                    }
                }
            }
            catch (Exception ee) {
                this.esay("Exception \n" + ee.toString());
                continue;
            }
            break;
        }
    }

    private SnmpRequest snmpAnswer(SnmpRequest request) {
        if (request == null) {
            return null;
        }
        SnmpOID oid = request.varBindOIDAt(0);
        SnmpObject value = request.varBindValueAt(0);
        String cls = this._cut(value.getClass().getName());
        int errorStatus = request.getErrorStatus().intValue();
        if (errorStatus != 0) {
            this._outputText.append(oid.toString() + ": Error status = " + errorStatus + " Error index = " + request.getErrorIndex().intValue() + "\n");
            return null;
        }
        if (this._special == 0) {
            this._typeChoice.select(cls);
            this._valueText.setText(value.toString());
            this._outputText.append(oid.toString() + ": (" + cls + ") :" + value + "\n");
            this._oidText.setText(oid.toString());
        } else if (this._special == 1) {
            if (request.varBindListSize() < 7) {
                this._outputText.setText("not enought system infos received : " + request.varBindListSize());
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 7; ++i) {
                sb.append(__sysAll[i] + " : " + request.varBindValueAt(i) + "\n");
            }
            this._outputText.setText(sb.toString());
            return null;
        }
        int type = this._isNext ? 161 : 160;
        request = new SnmpRequest(this._argCommunity, new SnmpInteger(this._requestId++), type);
        request.addVarBind(oid, new SnmpNull());
        --this._walk;
        return this._walk > 0 ? request : null;
    }

    private boolean _getArguments() {
        try {
            this._argOID = new SnmpOID(this._oidText.getText());
            this._argHost = InetAddress.getByName(this._hostText.getText());
            this._argPort = new Integer(this._portText.getText());
            this._argCommunity = new SnmpOctetString(this._communityText.getText());
            return true;
        }
        catch (Exception ie) {
            this._outputText.append("Exception : " + ie);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(SnmpRequest request) {
        Object object = this._sendLock;
        synchronized (object) {
            if (this._sending) {
                return false;
            }
            this._sending = true;
            this._request = request;
            this.say("Notifying sender\n");
            this._sendLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSending() {
        Object object = this._sendLock;
        synchronized (object) {
            if (!this._sending) {
                return;
            }
            this._sending = false;
            this._sendLock.notifyAll();
        }
    }

    private void _next() {
        SnmpRequest request;
        int type;
        this.say("Preparing Request\n");
        if (!this._getArguments()) {
            this.esay("Argument error");
            return;
        }
        this.say("Host : " + this._argHost + "\n");
        this.say("Port : " + this._argPort + "\n");
        this.say("OID  : " + this._argOID + "\n");
        this.say("Community  : " + this._argCommunity + "\n");
        int n = type = this._isNext ? 161 : 160;
        if (this._special == 1) {
            request = new SnmpRequest(this._argCommunity, new SnmpInteger(this._requestId++), 160);
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.1.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.2.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.3.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.4.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.5.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.6.0"), new SnmpNull());
            request.addVarBind(new SnmpOID("1.3.6.1.2.1.1.7.0"), new SnmpNull());
        } else {
            request = new SnmpRequest(this._argCommunity, new SnmpInteger(this._requestId++), type);
            request.addVarBind(this._argOID, new SnmpNull());
        }
        if (!this.sendRequest(request)) {
            this._messageText.setText("Send Action still Locked");
        }
    }

    private void say(String text) {
        System.out.print(text);
    }

    private void esay(String text) {
        this._messageText.setText(text);
    }

    public static void main(String[] args) {
        new Snmp(args);
    }
}

