/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.kerberos;

import dmg.protocols.kerberos.Krb5Exception;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Keytab {
    private Vector _list = null;

    public void list() {
        Enumeration e = this._list.elements();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement().toString());
        }
    }

    public Enumeration keyEntries() {
        return this._list == null ? new Vector().elements() : this._list.elements();
    }

    public int size() {
        return this._list == null ? 0 : this._list.size();
    }

    public KeytabEntry getEntryAt(int i) {
        if (this._list == null) {
            throw new NoSuchElementException("No Entries");
        }
        return (KeytabEntry)this._list.elementAt(i);
    }

    public Keytab(String keytabFilename) throws IOException, Krb5Exception {
        this.loadKeytabFile(new File(keytabFilename));
    }

    public void loadKeytabFile(File file) throws IOException, Krb5Exception {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        Vector<KeytabEntry> list = new Vector<KeytabEntry>();
        try {
            byte version = in.readByte();
            if (version != 5) {
                throw new Krb5Exception(1, "Unacceptable kerberos version : " + version);
            }
            version = in.readByte();
            if (version != 2) {
                throw new Krb5Exception(2, "Can only read keytab(2) not : " + version);
            }
            int block = 0;
            while (true) {
                try {
                    block = in.readInt();
                }
                catch (IOException ioee) {
                    break;
                }
                if (block < 0) {
                    in.skipBytes(-block);
                    continue;
                }
                int nameCount = in.readShort();
                String realm = in.readUTF();
                String[] principals = new String[nameCount];
                for (int i = 0; i < nameCount; ++i) {
                    principals[i] = in.readUTF();
                }
                int principalNameType = in.readInt();
                long timestamp = in.readInt() * 1000;
                byte vno = in.readByte();
                short keyType = in.readShort();
                short keyLength = in.readShort();
                byte[] key = new byte[keyLength];
                in.readFully(key);
                list.addElement(new KeytabEntry(realm, principals, principalNameType, timestamp, vno, keyType, key));
            }
        }
        catch (EOFException eof) {
            throw new Krb5Exception(3, "Illegal Krb5 Keytab format");
        }
        catch (IOException io) {
            throw io;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        this._list = list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <keytabFile>");
            System.exit(4);
        }
        Keytab keytab = new Keytab(args[0]);
        keytab.list();
        System.exit(0);
    }

    public class KeytabEntry {
        String _realm;
        String[] _principals;
        long _timestamp;
        int _vno;
        int _keytype;
        byte[] _key;

        public KeytabEntry(String realm, String[] principals, int nameType, long timestamp, int vno, int keytype, byte[] key) {
            this._realm = realm;
            this._principals = principals;
            this._timestamp = timestamp;
            this._vno = vno;
            this._keytype = keytype;
            this._key = key;
        }

        public String getPrincipalName() {
            StringBuffer sb = new StringBuffer();
            if (this._principals.length > 0) {
                sb.append(this._principals[0]);
            }
            for (int i = 1; i < this._principals.length; ++i) {
                sb.append("/").append(this._principals[i]);
            }
            return sb.toString();
        }

        public int getVno() {
            return this._vno;
        }

        public int getKeytype() {
            return this._keytype;
        }

        public byte[] getKey() {
            return this._key;
        }

        public String getKeytypeString() {
            switch (this._keytype) {
                case 1: {
                    return "des-cbc-crc";
                }
                case 2: {
                    return "des-cbc-md4";
                }
                case 3: {
                    return "des-cbc-md5";
                }
                case 16: {
                    return "des3-cbc-sha1";
                }
            }
            return "<Unknown(" + this._keytype + ")>";
        }

        public String toString() {
            return "  " + this.getVno() + "  " + this.getKeytypeString() + "\t   " + this.getPrincipalName();
        }
    }
}

