/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerObject;

public class BerObjectIdentifier
extends BerObject {
    private int[] _value = null;

    public BerObjectIdentifier(byte[] data, int off, int size) {
        super(0, true, 6, data, off, size);
        int a = 0;
        int count = 2;
        for (int i = 1; i < size; ++i) {
            a = data[off + i];
            int n = a = a < 0 ? a + 256 : a;
            if ((a & 0x80) != 0) continue;
            ++count;
        }
        this._value = new int[count];
        count = 0;
        a = data[off];
        a = a < 0 ? a + 256 : a;
        this._value[count++] = a / 40;
        this._value[count++] = a % 40;
        int l = 0;
        for (int i = 1; i < size; ++i) {
            a = data[off + i];
            a = a < 0 ? a + 256 : a;
            l <<= 7;
            l += a & 0x7F;
            if ((a & 0x80) != 0) continue;
            this._value[count++] = l;
            l = 0;
        }
    }

    @Override
    public String getTypeString() {
        return super.getTypeString() + " ObjectIdentifier";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._value[0]);
        for (int i = 0; i < this._value.length; ++i) {
            sb.append(".").append(this._value[i]);
        }
        return sb.toString();
    }

    public int getIdentifierAt(int p) {
        if (p > this._value.length) {
            throw new IllegalArgumentException("Out of range");
        }
        return this._value[p];
    }

    public int getIdentifierLength() {
        return this._value.length;
    }

    @Override
    public byte[] getEncodedData() {
        return this.getEncodedData(this.getData());
    }
}

