/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.multicaster;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import dmg.cells.services.multicaster.MulticastClose;
import dmg.cells.services.multicaster.MulticastEvent;
import dmg.cells.services.multicaster.MulticastMessage;
import dmg.cells.services.multicaster.MulticastOpen;
import dmg.cells.services.multicaster.MulticastRegister;
import dmg.cells.services.multicaster.MulticastUnregister;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(MulticastCell.class);
    private CellNucleus _nucleus = null;
    private Args _args = null;
    private final Hashtable _classHash = new Hashtable();
    private final Object _ioLock = new Object();

    public MulticastCell(String name, String args) throws Exception {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void messageArrived(CellMessage message) {
        block14: {
            Object obj = message.getMessageObject();
            CellPath path = (CellPath)message.getSourcePath().clone();
            if (obj instanceof NoRouteToCellException) {
                Object object = this._ioLock;
                synchronized (object) {
                    NoRouteToCellException nrtc = (NoRouteToCellException)obj;
                    _log.info("NRTCE arrived : " + nrtc);
                    this.removeByUOID(nrtc.getUOID());
                    return;
                }
            }
            if (!(obj instanceof MulticastEvent)) {
                return;
            }
            MulticastEvent mce = (MulticastEvent)obj;
            try {
                if (mce instanceof MulticastOpen) {
                    MulticastOpen mco = (MulticastOpen)mce;
                    this.openArrived(mco, path);
                    mce.isOk(true);
                    break block14;
                }
                if (mce instanceof MulticastClose) {
                    MulticastClose mcc = (MulticastClose)mce;
                    this.closeArrived(mcc);
                    mce.isOk(true);
                    return;
                }
                if (mce instanceof MulticastRegister) {
                    MulticastRegister mcr = (MulticastRegister)mce;
                    this.registerArrived(mcr, path);
                    mce.isOk(true);
                    break block14;
                }
                if (mce instanceof MulticastUnregister) {
                    MulticastUnregister mcu = (MulticastUnregister)mce;
                    this.unregisterArrived(mcu, path);
                    mce.isOk(true);
                    return;
                }
                if (mce instanceof MulticastMessage) {
                    MulticastMessage mcm = (MulticastMessage)mce;
                    this.registerMessageArrived(mcm, path, message);
                    return;
                }
                throw new IllegalArgumentException("Illegal Command : " + mce);
            }
            catch (Exception ee) {
                _log.warn(ee.toString(), (Throwable)ee);
                mce.isOk(false);
                mce.setReplyObject(ee);
            }
        }
        message.revertDirection();
        try {
            this.sendMessage(message);
        }
        catch (Exception e) {
            _log.warn("Failed to reply : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(String eventClass, String eventName) {
        Hashtable hashtable = this._classHash;
        synchronized (hashtable) {
            Hashtable names = (Hashtable)this._classHash.get(eventClass);
            if (names == null) {
                return null;
            }
            return (Entry)names.get(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(String eventClass, String eventName) throws NoSuchElementException {
        Hashtable hashtable = this._classHash;
        synchronized (hashtable) {
            Hashtable names = (Hashtable)this._classHash.get(eventClass);
            if (names == null) {
                throw new NoSuchElementException("Class not found : " + eventClass);
            }
            Object obj = names.get(eventName);
            if (obj == null) {
                throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
            }
            names.remove(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry newEntry(String eventClass, String eventName, boolean overwrite) {
        Hashtable hashtable = this._classHash;
        synchronized (hashtable) {
            Entry entry = this.getEntry(eventClass, eventName);
            if (entry != null && !overwrite) {
                throw new IllegalArgumentException("Duplicate entry");
            }
            entry = new Entry(eventClass, eventName);
            Hashtable<String, Entry> hash = (Hashtable<String, Entry>)this._classHash.get(eventClass);
            if (hash == null) {
                hash = new Hashtable<String, Entry>();
                this._classHash.put(eventClass, hash);
            }
            hash.put(eventName, entry);
            return entry;
        }
    }

    private void registerArrived(MulticastRegister register, CellPath path) throws Exception {
        String eventName;
        String eventClass = register.getEventClass();
        Entry entry = this.getEntry(eventClass, eventName = register.getEventName());
        if (entry == null) {
            throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
        }
        path.revert();
        entry.addClient(new Client(path));
        register.setServerInfo(entry.getServerDetail(), entry.getServerState());
    }

    private void unregisterArrived(MulticastUnregister register, CellPath path) throws Exception {
        String eventName;
        String eventClass = register.getEventClass();
        Entry entry = this.getEntry(eventClass, eventName = register.getEventName());
        if (entry == null) {
            return;
        }
        path.revert();
        entry.removeClient(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMessageArrived(MulticastMessage message, CellPath path, CellMessage originalMessage) throws Exception {
        String eventClass = message.getEventClass();
        String eventName = message.getEventName();
        Object info = message.getMessage();
        Entry entry = this.getEntry(eventClass, eventName);
        if (entry == null) {
            throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
        }
        entry.setServerState(info);
        CellPath serverPath = entry.getSourcePath();
        _log.info("message Path : " + path + "; serverPath : " + serverPath);
        if (path.equals(serverPath)) {
            Enumeration clients = entry.clients();
            while (clients.hasMoreElements()) {
                Client client = (Client)clients.nextElement();
                CellPath outPath = client.getPath();
                try {
                    _log.info("Distributing to " + outPath);
                    Object object = this._ioLock;
                    synchronized (object) {
                        CellMessage msg = new CellMessage(outPath, message);
                        this.sendMessage(msg);
                        client.setUOID(msg.getUOID());
                    }
                }
                catch (NoRouteToCellException nrtce) {
                    _log.warn("remove enforced for client " + path);
                    entry.removeClient(path);
                }
                catch (Throwable t) {
                    _log.warn(t.toString(), t);
                }
            }
        } else {
            _log.info("Message from client " + path);
            serverPath = (CellPath)serverPath.clone();
            serverPath.revert();
            originalMessage.getDestinationPath().add(serverPath);
            originalMessage.nextDestination();
            try {
                this.sendMessage(originalMessage);
            }
            catch (NoRouteToCellException ee) {
                _log.warn(ee.toString(), (Throwable)ee);
            }
            catch (Exception eee) {
                _log.warn(eee.toString(), (Throwable)eee);
            }
        }
    }

    private void openArrived(MulticastOpen open, CellPath path) throws Exception {
        Entry entry = this.newEntry(open.getEventClass(), open.getEventName(), open.isOverwrite());
        entry.setSourcePath(path);
        entry.setServerDetail(open.getServerDetail());
        entry.setServerState(open.getServerState());
    }

    private void closeArrived(MulticastClose close) throws Exception {
        Entry entry = this.getEntry(close.getEventClass(), close.getEventName());
        if (entry == null) {
            return;
        }
        this.removeEntry(close.getEventClass(), close.getEventName());
        Enumeration clients = entry.clients();
        while (clients.hasMoreElements()) {
            Client client = (Client)clients.nextElement();
            CellPath path = client.getPath();
            try {
                _log.info("Close Distributing to " + path);
                this.sendMessage(new CellMessage(path, close));
            }
            catch (Throwable t) {
                _log.warn(t.toString(), t);
            }
        }
    }

    private void removeByUOID(UOID uoid) {
        Enumeration classes = this._classHash.elements();
        while (classes.hasMoreElements()) {
            Enumeration instances = ((Hashtable)classes.nextElement()).elements();
            while (instances.hasMoreElements()) {
                Entry entry = (Entry)instances.nextElement();
                Enumeration clients = entry.clients();
                while (clients.hasMoreElements()) {
                    Client client = (Client)clients.nextElement();
                    UOID u = client.getUOID();
                    if (u == null || !u.equals(uoid)) continue;
                    entry.removeClient(client.getPath());
                    _log.info("Removed : " + client);
                    return;
                }
            }
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        Enumeration classes = this._classHash.elements();
        while (classes.hasMoreElements()) {
            Enumeration instances = ((Hashtable)classes.nextElement()).elements();
            while (instances.hasMoreElements()) {
                Entry entry = (Entry)instances.nextElement();
                pw.println(entry.toString());
            }
        }
    }

    private class Entry {
        private String _eventClass = null;
        private String _eventName = null;
        private Object _serverDetail = null;
        private Object _serverState = null;
        private CellPath _path = null;
        private Hashtable _clients = new Hashtable();

        private Entry(String eventClass, String eventName) {
            this._eventClass = eventClass;
            this._eventName = eventName;
        }

        private void addClient(Client client) {
            this._clients.put(client.getPath(), client);
        }

        private void removeClient(CellPath path) {
            this._clients.remove(path);
        }

        private Client getClient(CellPath path) {
            return (Client)this._clients.get(path);
        }

        private Enumeration clients() {
            return ((Hashtable)this._clients.clone()).elements();
        }

        private void setSourcePath(CellPath path) {
            this._path = path;
        }

        private CellPath getSourcePath() {
            return this._path;
        }

        private void setServerState(Object serverState) {
            this._serverState = serverState;
        }

        private Object getServerState() {
            return this._serverState;
        }

        private void setServerDetail(Object serverDetail) {
            this._serverDetail = serverDetail;
        }

        private Object getServerDetail() {
            return this._serverDetail;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" Server   : " + this._eventClass + ":" + this._eventName + "\n");
            sb.append("   Detail : " + (this._serverDetail == null ? "<none>" : this._serverDetail.toString()) + "\n");
            sb.append("   State  : " + (this._serverState == null ? "<none>" : this._serverState.toString()) + "\n");
            sb.append("   Path   : " + (this._path == null ? "<none>" : this._path.toString()) + "\n");
            Enumeration e = this._clients.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = this._clients.get(key);
                sb.append("      " + key.toString() + "=" + value.toString() + "\n");
            }
            return sb.toString();
        }
    }

    private class Client {
        private UOID _uoid = null;
        private CellPath _path = null;

        private Client(CellPath path) {
            this._path = path;
        }

        private CellPath getPath() {
            return this._path;
        }

        private UOID getUOID() {
            return this._uoid;
        }

        private void setUOID(UOID uoid) {
            this._uoid = uoid;
        }

        public String toString() {
            return "Client" + this._path;
        }
    }
}

